<?php

use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\HomeController;
use \App\Http\Controllers\UserController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\PayPalController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::post('users/register', [UserController::class, 'store'])->name('users.register');
Route::any('users/subscribe/{id}', [UserController::class, 'subscribe'])->name('users.subscribe');

// subcription
Route::any('renew/{company}', [HomeController::class, 'showRenew'])->name('subscribe.showRenew');
Route::get('paiement_renew/{company}/{subscription}/{type}/{annual}/{mode?}/{paymentInfosSup?}', [HomeController::class, 'paiementRenew'])->name('subscribe.paiementRenew');
Route::get('save_renew/{company}/{subscription}/{type}/{annual}/{mode?}/{paymentInfosSup?}', [HomeController::class, 'saveRenew'])->name('subscribe.saveRenew');

Route::any('404', function(){
    return view('errors.404');
})->name('404');

Route::any('/selflogout', function (){
    \Illuminate\Support\Facades\Auth::logout();
    return redirect('/login');
})->name('Logout');

// stripe
Route::post('/create-payment-intent', [StripeController::class, 'createPaymentIntent']);
Route::post('/create-checkout-session', [StripeController::class, 'createCheckoutSession']);
Route::post('/create-subscription', [StripeController::class, 'createSubscription']);
// paypal
Route::post('/paypal/subscription/create', [PayPalController::class, 'createSubscription'])->name('paypal.subscription.create');
Route::get('/paypal/subscription/success', [PayPalController::class, 'subscriptionSuccess'])->name('paypal.subscription.success');
Route::get('/paypal/subscription/cancel', [PayPalController::class, 'subscriptionCancel'])->name('paypal.subscription.cancel');
Route::post('/paypal/webhook', [PayPalController::class, 'handleWebhook'])->name('paypal.webhook');

// routes/web.php
Route::post('/proxy/inference', function (\Illuminate\Http\Request $request) {
    $client = new \GuzzleHttp\Client();
    $response = $client->request('POST', 'https://api.genhealth.ai/v1/inference', [
        'headers' => [
            'Authorization' => 'Bearer '.env('GENHEALTH_API'),
            'Content-Type' => 'application/json',
        ],
        'json' => [
            'prompt' => $request->input('prompt'),
        ],
    ]);
    return response()->json(json_decode($response->getBody()), $response->getStatusCode());
});

Route::get('/scripts/js/site/scripts', function () {
    return response()->view('site.scripts')->header('Content-Type', 'application/javascript');
});

Route::get('/scripts/js/scriptjs', function () {
    return response()->view('scriptjs')->header('Content-Type', 'application/javascript');
});

Route::post('/get_pp_id/', function (\Illuminate\Http\Request $request) {
    $data = $request->get('data');
    if (!isset($data['subscription_id'])) {
        return null;
    }

    if ($data['subscription_type'] === 'trial') {
        switch ($data['subscription_id']) {
            case '1':
                return $data['subscription_annual'] ? env('SANDBOX_PLAN_1_TRIAL_ANNUAL') : env('SANDBOX_PLAN_1_TRIAL_MENSUAL');
            case '2':
                return $data['subscription_annual'] ? env('SANDBOX_PLAN_2_TRIAL_ANNUAL') : env('SANDBOX_PLAN_2_TRIAL_MENSUAL');
            case '3':
                return $data['subscription_annual'] ? env('SANDBOX_PLAN_3_TRIAL_ANNUAL') : env('SANDBOX_PLAN_3_TRIAL_MENSUAL');
        }
    } else {
        switch ($data['subscription_id']) {
            case '1':
                return $data['subscription_annual'] ? env('SANDBOX_PLAN_1_ANNUAL') : env('SANDBOX_PLAN_1_MENSUAL');
            case '2':
                return $data['subscription_annual'] ? env('SANDBOX_PLAN_2_ANNUAL') : env('SANDBOX_PLAN_2_MENSUAL');
            case '3':
                return $data['subscription_annual'] ? env('SANDBOX_PLAN_3_ANNUAL') : env('SANDBOX_PLAN_3_MENSUAL');
        }
    }

    return null; // Au cas où aucun des cas ne correspondrait});
});

Route::get('/dynamic-scripts', function () {
    return response()->view('dynamic-scripts-loader')->header('Content-Type', 'application/javascript');
})->name('dynamic-scripts');

Route::get('/paypal-access-token', function () {
    $clientId = config('paypal.sandbox.client_id');
    $clientSecret = config('paypal.sandbox.client_secret');
    // Obtenir un token depuis l'API de PayPal
    $response = \Illuminate\Support\Facades\Http::withBasicAuth($clientId, $clientSecret)
        ->asForm()
        ->post('https://api-m.sandbox.paypal.com/v1/oauth2/token', [
            'grant_type' => 'client_credentials',
        ]);

    if ($response->successful()) {
        return response()->json(['access_token' => $response->json()['access_token']]);
    }
    return response()->json(['error' => 'Unable to generate access token'], 500);
});

// Dans vos routes web ou API Laravel
Route::get('/paypal-client-id', function () {
    return response()->json(['client_id' => config('paypal.sandbox.client_id')]);
});

