<?php
//use App\Http\Controllers\RdvController;
use App\Mail\RdvMail;
use App\Mail\StatMail;
use App\Models\Dashboard;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\Admin\CareController;
use \App\Http\Controllers\Admin\ConsultationController;
use \App\Http\Controllers\Admin\TeleconsultationController;
use \App\Http\Controllers\Admin\GroupController;
use \App\Http\Controllers\Admin\InterventionController;
use \App\Http\Controllers\Admin\InvoiceController;
use \App\Http\Controllers\Admin\LogController;
use \App\Http\Controllers\Admin\NotificationController;
use \App\Http\Controllers\Admin\PatientController;
use \App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\RdvController;
use \App\Http\Controllers\Admin\RoomController;
use \App\Http\Controllers\Admin\SaleController;
use \App\Http\Controllers\Admin\SpecialtyController;
use \App\Http\Controllers\Admin\StatusController;
use \App\Http\Controllers\Admin\TroubleController;
use \App\Http\Controllers\Admin\TypeconsultationController;
use \App\Http\Controllers\Admin\DepartmentController;
use \App\Http\Controllers\Admin\UserController;
use \App\Http\Controllers\Admin\VerdictController;
use \App\Http\Controllers\Admin\TypeinterventionController;
use \App\Http\Controllers\Admin\DashboardController;
use \App\Http\Controllers\Admin\CompanyController;
use \App\Http\Controllers\Admin\InterventioncareController;
use \App\Http\Controllers\Admin\GoogleApiController;
use \App\Http\Controllers\Admin\AnalysisController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//    Route::get('/', function () {
//        if(auth() AND !auth()->user()->active)
//            return redirect()->route('logout');
//        if(password_verify(auth()->user()->firstname(), auth()->user()->password))
//            return redirect()->route('users.edit', auth()->user()->id);
//        return view('dashboard');
//    })->name('index');

// BASIC ROUTES
Route::middleware(['sub_basic'])->group(function () {
    Route::middleware(['admin'])->group(function () {
        Route::resource('users', UserController::class);
    });
//    Route::middleware(['secretary'])->group(function () {
        Route::resource('cares', CareController::class);
        Route::resource('analyses', AnalysisController::class);
//    });
    Route::any('/', [DashboardController::class, 'index'])->name('index');
    Route::resource('consultations', ConsultationController::class);
    Route::resource('interventions', InterventionController::class);
    Route::resource('rdvs', RdvController::class);
    Route::resource('notifications', NotificationController::class);
    Route::resource('patients', PatientController::class);
    Route::resource('products', ProductController::class);
    Route::resource('rooms', RoomController::class);
    Route::resource('departments', DepartmentController::class);
    Route::resource('company', CompanyController::class);

    Route::any('patientarchive/{patient}', [PatientController::class, 'archive'])->name('patients.archive');
    Route::any('patientdelete/{patient}', [PatientController::class, 'destroy'])->name('patients.delete');
    Route::any('consultationdelete/{consultation}', [ConsultationController::class, 'destroy'])->name('consultations.delete');
    Route::any('interventiondelete/{intervention}', [InterventionController::class, 'destroy'])->name('interventions.delete');
    Route::any('checkpassword/{user}', [UserController::class, 'checkPassword'])->name('users.checkPassword');
    Route::any('consultation/create_id/{patientX}', [ConsultationController::class, 'createID'])->name('consultations.createID');
    Route::any('intervention/create_id/{patientX}', [InterventionController::class, 'createID'])->name('interventions.createID');
    Route::any('notificationdelete/{notification}', [NotificationController::class, 'destroy'])->name('notifications.delete');
    Route::any('productdelete/{product}', [ProductController::class, 'destroy'])->name('products.delete');
    Route::any('rdvdelete/{rdv}', [RdvController::class, 'destroy'])->name('rdvs.delete');
    Route::any('roomdelete/{room}', [RoomController::class, 'destroy'])->name('rooms.delete');
    Route::any('departmentdelete/{department}', [DepartmentController::class, 'destroy'])->name('departments.delete');
    Route::any('userdelete/{user}', [UserController::class, 'destroy'])->name('users.delete');
    Route::any('rdvtoggledone/{rdv}', [RdvController::class, 'toggleDone'])->name('rdvs.toggleDone');
    Route::any('caresdelete/{care}', [CareController::class, 'destroy'])->name('cares.delete');
    Route::any('analysisdelete/{care}', [AnalysisController::class, 'destroy'])->name('analyses.delete');

    Route::resource('invoices', InvoiceController::class);
    Route::any('downloadticket/{patient}', [PatientController::class, 'downloadTicket'])->name('patients.downloadTicket');
    Route::any('invoicedelete/{invoice}', [InvoiceController::class, 'destroy'])->name('invoices.delete');
    Route::any('download/{invoice}/{type}', [InvoiceController::class, 'download'])->name('invoices.download');

    Route::any('setdiscount/{invoice}/{discount}', [InvoiceController::class, 'setDiscount'])->name('invoices.setDiscount');


});

// STANDARD ROUTES
Route::middleware(['sub_standard'])->group(function () {
    Route::resource('teleconsultations', TeleconsultationController::class);
    Route::any('teleconsultation/live_id/{patientX}', [TeleconsultationController::class, 'liveID'])->name('teleconsultations.liveID');
    Route::any('teleconsultationdelete/{teleconsultation}', [TeleconsultationController::class, 'destroy'])->name('teleconsultations.delete');
});

// GOLD ROUTES
Route::middleware(['sub_gold'])->group(function () {
    Route::resource('sales', SaleController::class);
    Route::any('saledelete/{sale}', [SaleController::class, 'destroy'])->name('sales.delete');
});

// SUP ADMIN ROUTES
Route::middleware(['super_admin'])->group(function () {
    Route::resource('groups', GroupController::class);
    Route::resource('specialties', SpecialtyController::class);
    Route::resource('status', StatusController::class);
    Route::resource('troubles', TroubleController::class);
    Route::resource('typeconsultations', TypeconsultationController::class);
    Route::resource('verdicts', VerdictController::class);
    Route::resource('typeinterventions', TypeinterventionController::class);
    Route::resource('interventioncares', \App\Http\Controllers\Admin\InterventioncareController::class);
    Route::resource('logs', LogController::class);

    Route::any('groupdelete/{group}', [GroupController::class, 'destroy'])->name('groups.delete');
    Route::any('logdelete/{log}', [LogController::class, 'destroy'])->name('logs.delete');

    Route::any('specialtydelete/{specialty}', [SpecialtyController::class, 'destroy'])->name('specialties.delete');
    Route::any('statusdelete/{status}', [StatusController::class, 'destroy'])->name('status.delete');
    Route::any('troubledelete/{trouble}', [TroubleController::class, 'destroy'])->name('troubles.delete');
    Route::any('typeconsultationdelete/{typeconsultation}', [TypeconsultationController::class, 'destroy'])->name('typeconsultations.delete');
    Route::any('verdictdelete/{verdict}', [VerdictController::class, 'destroy'])->name('verdicts.delete');
    Route::any('typeinterventiondelete/{typeintervention}', [TypeinterventionController::class, 'destroy'])->name('typeinterventions.delete');

});


Route::any('/selflogout', function (){
    \Illuminate\Support\Facades\Auth::logout();
    session(['close_sub_banner' => false]);
    return redirect('/login');
})->name('selfLogout');

Route::post('/close-sub-banner', function(){
    session(['close_sub_banner' => true]);
    return session('close_sub_banner');
})->name('closeSubBanner');

Route::any('/update-ai-credits', [CompanyController::class, 'updateAiCredits'])->name('companies.updateAiCredits');

Route::any('/testmail', function(){

    // Récupérer tous les utilisateurs
    $users = User::all()->filter(function($user){
        return $user->company->where('subscription_active', 1);
    });

    foreach ($users as $user) {
        // Récupérer les rendez-vous du jour pour l'utilisateur
            $rdvs = $user->rdvs()->whereBetween('datetime', [Carbon::today(), Carbon::tomorrow()->subSecond()])->with('patient')->get();
//        $rdvs = $user->rdvs()->with('patient')->get();

        // Vérifier si l'utilisateur a au moins un rendez-vous
        if ($rdvs->isNotEmpty()) {
            // Préparer les données pour l'email
            $mailData = [
                'user' => $user,
                'company' => $user->company,
                'rdvs' => $rdvs,
            ];

            // Envoyer l'email
            if($user == auth()->user())
            Mail::to($user)->send(new RdvMail($mailData));
        }
    }
});

Route::get('/create-google-meet', [GoogleApiController::class, 'createGoogleMeet'])->name('createGoogleMeet');
Route::get('/auth/google', [GoogleApiController::class, 'redirectToGoogle'])->name('oauth');
Route::get('/auth/google/callback', [GoogleApiController::class, 'handleGoogleCallback'])->name('oauth2callback');

// Dans vos routes web ou API Laravel
Route::get('/pplx-id', function () {
    return response()->json(['pplx_id' => env('PPLX_API')]);
});







