@extends('layout.app')

@section('content')
    <style>
        .fa-check, .fa-clock, .clock{
            font-size: 18px;
            position: absolute;
            top: 0;
            left: 0
        }
        .fa-check, .clock{
            cursor: pointer;
        }
        .fa-check{
            color: lime;
        }
        .options{
            position: absolute;
            top: 0;
            right: -10px
        }
        .options a{
            margin-bottom: 5px
        }
        .profil{
            position: absolute;
            top: 0;
            left: -10px;
            font-size: 12px
        }
    </style>
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Personnel ({{ $datas->count() }})  &nbsp;
                        @if(!auth()->user()->company->isUsersMax())
                        <a class="btn btn-primary" href="{{ route('users.create') }}">Ajouter</a>
                        @endif
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        @foreach($dataRoles as $key => $dataRole)
                            <li class="nav-item tab-all">
                                <a class="nav-link {{ $loop->first ? 'active' : '' }}" href="#tab{{ $key }}" data-toggle="tab">{{ $key }}s</a>
                            </li>
                        @endforeach
                    </ul>

                    <div class="tab-content">
                        @foreach($dataRoles as $key => $dataRole)
                            @php $i = 1; @endphp
                            <div class="tab-pane {{ $loop->first ? 'active' : '' }}" id="tab{{ $key }}">
                            @foreach($dataRole as $data)
                                @if($i == 1 OR ($i - 1) % 3 == 0)<div class="row">@endif
                                <div class="col-md-4">
                                    <div class="card card-box">
                                        <div class="card-body no-padding ">
                                            <div class="doctor-profile">
                                                <div class="profile-usertitle" style="position: relative">
                                                    <div class="options">
                                                        <a href="{{ route('users.edit', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Modifier">
                                                            <i class="hgi-stroke hgi-edit-02 text-dark h3"></i>
                                                        </a><br>
                                                        @if(!$data->hasRelatedRecords())
                                                        <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('users.delete', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Supprimer">
                                                            <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3"></i>
                                                        </a>
                                                        @endif
                                                    </div>
                                                    <div class="profil">
                                                        Profil : {{ $data->profil }}
                                                    </div>
                                                    <div class="doctor-pic-bloc">
                                                        @if($data->photo)
                                                            <a href="{{ asset(env('APP_URL').'storage/uploads/users/'.$data->photo) }}" target="_blank">
                                                                <img src="{{ asset(env('APP_URL').'storage/uploads/users/'.$data->photo) }}" class="doctor-pic">
                                                            </a>
                                                        @else
                                                            {{--                                                    <i class="material-icons" style="font-size: 7em">person_pin</i>--}}
                                                            <i class="fa-sharp fa-regular fa-circle-user" style="font-size: 7em; color: #3f51b5"></i>
                                                        @endif
                                                    </div>
                                                    <div class="doctor-name">@if($data->is_doctor == true) Dr. @endif {{ $data->name }}</div>
                                                </div>
                                                <div>
                                                    <p>
                                                        <i class="fa fa-phone text-primary"></i>
                                                        <a href="tel:(123)456-7890" data-toggle="tooltip" data-placement="top" title="Appeler">{{ $data->tel }}</a>
                                                    </p>
                                                </div>
                                                <div class="profile-userbuttons" style="font-size: 11px">
                                                    <span class="pull-left" style="float: left">{{ $data->position }}</span>
                                                    <span class="pull-right">{{ $data->role }} · {{ $data->specialty ? $data->specialty->name : '' }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if($i % 3 == 0 OR $loop->last)</div>@endif
                                @php $i++; @endphp
                            @endforeach
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

