@extends('layout.app')

@section('content')
<div class="page-content">
    <div class="page-bar">
        <div class="page-title-breadcrumb">
            <div class=" pull-left">
                <div class="page-title">Profile du Patient</div>
            </div>

        </div>
    </div>
    <div class="row">
        <div class="col-md-4 col-xs-12">
            <div class="white-box">
{{--                <div class=" cardbox patient-profile">--}}
{{--                    <img src="../assets/img/patient1.jpg" class="img-responsive" alt="">--}}
{{--                </div>--}}
                <div class="cardbox">
                    <div class="body">
                        <div class="user-btm-box">
                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 b-r"><strong>Noms</strong>
                                    <p>{{ $data->name }}</p>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12"><strong>Age</strong>
                                    <p>{{ $data->age() }} ans</p>
                                </div>
                            </div>
                            <!-- /.row -->

                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 b-r"><strong>Genre</strong>
                                    <p>{{ $data->sex }}</p>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12"><strong>Groupe</strong>
                                    <p>{{ $data->group->name }}</p>
                                </div>
                            </div>
                            <!-- /.row -->

                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 b-r"><strong>Pathologie</strong>
                                    <p>{{ $data->pathology }} Kg</p>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12"><strong>Profession</strong>
                                    <p>{{ $data->size }} cm</p>
                                </div>
                            </div>
                            <!-- /.row -->

                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 b-r"><strong>Poids</strong>
                                    <p>{{ $data->weight }} Kg</p>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12"><strong>Taille</strong>
                                    <p>{{ $data->size }} cm</p>
                                </div>
                            </div>
                            <!-- /.row -->

                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 b-r"><strong>Téléphone</strong>
                                    <p>{{ $data->tel }}</p>
                                </div>
                                <div class="col-lg-6 col-md-12 col-sm-6 col-xs-12 b-r"><strong>Adresse</strong>
                                    <p>{{ $data->address }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-8 col-xs-12">
            <div class="cardbox">
                <div class="body">
                    @if($data->stay)
                    <div class="mypost-list">

                        <div class="post-box">
                            <p>
                                <h5>En hospitalisation depuis le {{ $data->lastIntervention()->date }}</h5>
                                <h4>{{ $data->lastIntervention()->room->name }} - {{ $data->lastIntervention()->room->department->name }}</h4>
                            </p>
                            <p>
                                <h5>Maladie ou Gêne actuel</h5>
                                <h4>{{ $data->lastIntervention()->trouble->name }}</h4>
                            </p>
                            <p>
                                <h5>Etat actuel</h5>
                                <h4>{{ $data->lastIntervention()->status->name }}</h4>
                            </p>
                        </div>
                        <hr>
{{--                        <div class="post-box">--}}
{{--                            <h4 class="font-bold">General Report</h4>--}}
{{--                            <hr>--}}
{{--                            <h5>Heart Beat <span class="pull-right">85</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%"> <span class="sr-only">40% Complete (success)</span> </div>--}}
{{--                            </div>--}}
{{--                            <h5>Blood Pressure<span class="pull-right">93</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-warning progress-bar-striped active" role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100" style="width:90%;"> <span class="sr-only">50% Complete</span> </div>--}}
{{--                            </div>--}}
{{--                            <h5>Sugar<span class="pull-right">55</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-primary progress-bar-striped active" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width:50%;"> <span class="sr-only">50% Complete</span> </div>--}}
{{--                            </div>--}}
{{--                            <h5>Haemoglobin<span class="pull-right">78%</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-danger progress-bar-striped active" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:70%;"> <span class="sr-only">50% Complete</span> </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                    </div>
                    <hr>
                    @endif
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card card-box">
                                        <div class="card-header">
                                            <header>Dernières hospitalisations</header>
                                        </div>
                                        <div class="card-body ">
                                            <div class="table-responsive">
                                                <table class="table table-striped custom-table table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Professionnel en charge</th>
                                                        <th>Soins</th>
                                                        <th>Charges ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($data->interventions as $intervention)
                                                    <tr>
                                                        <td>{{ $intevention->date }}</td>
                                                        <td>{{ $intervention->user->name }}</td>
                                                        <td>{{ $intervention->care->name }}</td>
                                                        <td>14$</td>
                                                    </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
