@extends('layout.app')

@section('content')
    <!-- Laravel génère le lien Jitsi et on passe le nom de la réunion au JavaScript -->
    @php
        $roomName = 'reunion-' . round(microtime(true) * 1000);
    @endphp
    <style>
        .form-body, textarea, input, select{
            font-size: 0.9rem !important;
        }
        .form-control-textarea{
            height: 30px !important;
        }
        .tox-tinymce{
            height: 250px !important;
        }
        .mce-content-body{
            font-size: 0.9rem !important;
        }
    </style>
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">
                        <span class="badge badge-pill badge-danger">Live 02:50</span>
                        Téléconsultation · Hôte : <b>{{auth()->user()->proName()}}</b>, Patient : <b id="patient_name"></b></div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
                        {{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
                        {{--                            data-mdl-for = "panel-button">--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <form action="{{ route('teleconsultations.store') }}" id="mainForm" method="POST" id="form_sample_1" enctype="multipart/form-data">

                    <div class="card-body row" id="bar-parent">
                            @csrf
                            <div class="col-8">
                                <div class="form-body">
                                <div class="">


                                    <div class="row">
                                        <select class="form-control col-4" name="patient_id" id="patientSelect" required>
                                            <option value="">Selectionnez le Patient</option>
                                            @foreach($patients as $patient)
                                                <option value="{{ $patient->id }}"
                                                        @if(isset($patientX) AND $patientX->id == $patient->id) selected @endif
                                                        data-id="{{ $patient->id }}"
                                                        data-custom_id="{{ $patient->custom_id }}"
                                                        data-assured="{{ $patient->assured }}"
                                                        data-name="{{ $patient->name }}"
                                                        data-lastname="{{ $patient->lastname() }}"
                                                        data-firstname="{{ $patient->firstname() }}"
                                                        data-email="{{ $patient->email }}"
                                                        data-birth="{{ $patient->birth }}"
                                                        data-sex="{{ $patient->sex }}"
                                                        data-tel="{{ $patient->tel }}"
                                                        data-job="{{ $patient->job }}"
                                                        data-antecedent="{{ $patient->antecedent }}"
                                                        data-pathology="{{ $patient->pathology }}"
                                                        data-weight="{{ $patient->weight }}"
                                                        data-size="{{ $patient->size }}"
                                                        data-group_id="{{ $patient->group_id }}"
                                                        data-address="{{ $patient->address }}"
                                                        data-assured_social_percent="{{ $patient->assured_social_percent }}"
                                                        data-assured_completed_percent="{{ $patient->assured_completed_percent }}"
                                                >
                                                    {{ $patient->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="mb-2 ml-2 col">
                                            <a href="#" class="btn btn-light btn-sm editPatientBtn" id="openEditModal" style="font-size: 1rem" data-toggle="tooltip" data-placement="top" title="Modifier les infos du patient">
                                                <i class="hgi-stroke hgi-edit-02"></i>
                                            </a>

                                            <a href="#" data-target="#patientModal" data-toggle="modal" class="btn btn-light btn-sm" style="font-size: 1.2rem" data-placement="top" title="Ajouter un nouveau patient">+</a>
                                            <a href="#" id="copyEmailBtn" class="btn btn-light btn-sm small"  data-toggle="tooltip" data-placement="top" title="Copier l'email du patient" style="padding-top: 8px; padding-bottom: 8px;">
                                                <i id="copyIcon" class="fa fa-copy"></i>
                                                <span id="patient_email" class="small">Sélectionnez un patient</span>
                                            </a>
                                        </div>

                                    </div>
                                </div>
                                </div>
                                <div id="live-container" style="position: relative; width: 100%; padding-bottom: 56.25%; height: 0; overflow: hidden;">
                                    <iframe id="jitsiIframe"
                                            src="https://meet.jit.si/{{ $roomName }}"
                                            allow="camera; microphone; fullscreen; display-capture"
                                            style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 0; border-radius: 20px">
                                    </iframe>
                                </div>
                            </div>
                            <div class="col-4">
                                    <div class="form-body">
                                        <input type="hidden" name="user_id" value="{{auth()->user()->id}}">
                                        <input type="hidden" name="duration" value="250">
                                        {{--                                @endif--}}

                                        <div class="row">
                                            <div class="col">
                                                <label class="control-label ">Température (C)</label>
                                                <div class="row">
                                                    <input type="text" name="temperature" placeholder="39" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col ml-2">
                                                <label class="control-label ">Montant Total ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})
                                                    <span class="required"> * </span>
                                                </label>
                                                <div class="row">
                                                    <input type="text" name="amount" placeholder="3500" class="form-control" required/>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="">
                                            <div class="row">
                                                <label class="control-label">Diagnostic
                                                    <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Vous pouvez y préciser le diagnostic, le verdict, des éléments clés, etc"></i>
                                                    <span class="required"> * </span>
                                                </label>
                                                @if(auth()->user()->subGold())
                                                    <div class="ml-3">
                                                        <span class="nav-link btn btn-sm btn-light font-weight-bolder font-size-20 countdown" style="display: none; font-size: 11px !important;"></span>
                                                        <i class="fa fa-microphone btn btn-sm btn-light" id="start-btn" style="font-size: 11px !important;"></i>
                                                        <i class="fa fa-microphone fa-beat btn btn-sm btn-light text-danger" id="stop-btn" style="display: none; font-size: 11px !important;"></i>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="row mt-2">
                                            <textarea name="description" class="form-control-textarea" id="description" cols="30" rows="10" style="height: 20%" required></textarea>
                                        </div>

                                        <br>
                                        <div class="">
                                            <div class="row">
                                                <label class="control-label ">Ordonnance
                                                    <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Décrivez en détails l'ordonnance du patient"></i>
                                                </label>
                                                <div class="ml-3">
                                                    <a href="javascript:void(0)" class="btn ai btn-light small" style="font-size: 9px" id="generate-prescription">
                                                        <i class="fa fa-user-nurse" style="font-size:11px"></i>
                                                        @if(auth()->user()->subStandard() AND !auth()->user()->subGold())(<span id="ai-credits">{{auth()->user()->company->ai_credits}}</span> crédits restants)@endif
                                                    </a>
                                                    <a href="javascript:void(0)" class="btn btn-light ai disabled small " style="display: none; font-size: 10px" id="generate-prescription-loading" disabled>
                                                        <i class="fa-solid fa-circle-notch fa-spin" style="font-size:9px"></i>
                                                        Réflexion de Docteur IA
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-2">
                                            <textarea name="prescription" class="form-control-textarea" id="prescription" cols="30" rows="10"></textarea>
                                        </div>



                                        {{--                                    <span class="text-primary font-weight-bolder font-size-20 countdown"></span>--}}
                                            {{--                                    <a href="javascript:void(0)" id="start-btn"><i class="fa fa-microphone text-warning"></i></a>--}}
                                            {{--                                    <a href="javascript:void(0)" id="stop-btn" class="display-none"><i class="fa fa-microphone text-danger fa-beat"></i></a>--}}
                                        </div>

                                        {{--                                <div class=" row">--}}
                                        {{--                                    <label class="control-label ">Produits--}}

                                        {{--                                    </label>--}}
                                        {{--                                    <div class="">--}}
                                        {{--                                        <select class="form-control " name="product_id[]" style="width: 78%; display: inline-block">--}}
                                        {{--                                            <option value="">Selectionnez</option>--}}
                                        {{--                                            @foreach($products as $product)--}}
                                        {{--                                                <option value="{{ $product->id }}">{{ $product->name }}</option>--}}
                                        {{--                                            @endforeach--}}
                                        {{--                                        </select>--}}
                                        {{--                                        <input type="number" class="form-control " name="qte[]" value="1"  style="width: 20%;  display: inline-block">--}}
                                        {{--                                    </div>--}}
                                        {{--                                    <a href="#" id="btn-command" class="nav-link btn btn-light btn-sm">+</a>--}}
                                        {{--                                </div>--}}
                                        <div id="command-bloc">

                                        </div>
                                        <template id="command">
                                            <div class=" row">
                                                <label class="control-label "></label>
                                                <div class="">
                                                    <select class="form-control " name="product_id[]" style="width: 78% ; display: inline-block">
                                                        <option value="">Selectionnez</option>
                                                        @foreach($products as $product)
                                                            <option value="{{ $product->id }}">{{ $product->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    <input type="number" class="form-control " name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                                </div>
                                                <a href="#" class="delete-command nav-link btn btn-primary btn-sm" style="padding: 7px 18px !important; font-size: 20px;">-</a>
                                            </div>
                                        </template>


                                    </div>

                        <div class="form-actions col-12 d-flex flex-column justify-content-center align-items-center" style="font-size: 0.9rem;">
                            <div class="form-group row d-flex justify-content-center align-items-center">
                                <span>
                                    <label class="mdl-switch mdl-js-switch mdl-js-ripple-effect" for="stayToggle">
                                        <input type="checkbox" id="stayToggle" class="mdl-switch__input" name="send_mail" checked>
                                    </label>
                                </span>
                                <span class="ml-3">
                                    Envoyer au patient l'email de rapport cette téléconsultation
                                </span>
                            </div>
                            <div class="row mt-3">
                                <div>
                                    <button type="submit" id="save" class="btn btn-primary">Enregistrer</button>
                                    <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                </div>
                            </div>
                        </div>



                    </div>
                    </form>

                   </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

        let subStandardOnly = {!! json_encode(auth()->user()->subStandard() && !auth()->user()->subGold()) !!}

        if(subStandardOnly)
            checkAiCredits()

        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('.form-body').on('click', '.delete-command', function(e){
            e.preventDefault()
            $(this).parent().remove()
        })

        $('#confirmCreateModal #submit').click(function(){
            $('#mainForm').submit()
        })


        $('#generate-prescription').click(async function() {
            const description = tinymce.get('description').getContent()
            const prescription = tinymce.get('prescription')
            const pplxId = await getPPLXID();

            if(!description)
                return alert('Veuillez renseigner d\'abord le diagnostic du patient')
            // return $('#generate-error').text('Veuillez renseigner d\'abord le diagnostic du patient')
            else
                $('#generate-error').text('')

            $('#generate-prescription').hide()
            $('#generate-prescription-loading').show()

            $.ajax({
                url: 'https://api.perplexity.ai/chat/completions', // URL de l'API
                type: 'POST',
                contentType: 'application/json',
                headers: {
                    'Authorization': 'Bearer ' + pplxId, // Remplacez par votre clé API
                    'Accept': 'application/json'
                },
                data: JSON.stringify({
                    model: 'llama-3.1-sonar-small-128k-online', // Modèle à utiliser
                    messages: [
                        { role: 'user', content: formatDescription(description) }
                    ]
                }),
                success: function(response) {
                    // Traitez la réponse ici
                    prescription.setContent(marked.parse(response.choices[0].message.content))
                    $('#generate-prescription-loading').hide()
                    $('#generate-prescription').show()
                    if(subStandardOnly){
                        updateAiCredits()
                        checkAiCredits()
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erreur:', error);
                    $('#response').text('Une erreur est survenue.');
                    $('#generate-prescription-loading').hide()
                    $('#generate-prescription').show()
                }
            });
        })


        function formatDescription(message){
            const basicPrompt = 'Ordonnance médicale rédigée comme par un médecin pour un diagnostic que je vais décrire en dessous.\n' +
                'Je veux liste de médicaments (avec leur posologie respectifs) et de conseils.\n' +
                'Ne pas mentionner une consultation médicale (ne pas mentionner "il est important de consulter un médecin etc acr le but est d avoir une ordonnance rédigée comme un médecin").\n' +
                'La réponse ne contiendra que les medicaments prescrits et les conseils comme titre pas de d\'intro ni de conlusion ni de résumé en fin. ' +
                'La réponse ne dépassera pas 1000 caractères (très important) et réduis l\'espacement entre les interlignes et paragraphes. ' +
                'Substituer la réponse en 3 grands paragraphes: Diagnostic, Médicaments & Posologies et Conseils. ' +
                'Diagnostic: '

            return basicPrompt + message
        }

        function updateAiCredits(){
            $.post('{{route('companies.updateAiCredits')}}', {_token : "{{ csrf_token() }}"}, function(rsp){
                $('#ai-credits').text(rsp)
            })
        }

        function checkAiCredits(){
            if(subStandardOnly)
                setTimeout(()=>{
                    if($('#ai-credits').text() <= 0){
                        $('#doctor-ai').addClass('disabled')
                    }
                }, 1000)
        }



        $('#mainForm').on('submit', function(e) {
            e.preventDefault(); // Empêche l'envoi automatique du formulaire
            $('#confirmModal').modal('show'); // Affiche la modale de confirmation
        });

        $('#confirmModal #submit').on('click', function() {
            $('#mainForm').off('submit').submit(); // Soumet le formulaire après confirmation
        });

        async function getPPLXID() {
            try {
                const response = await fetch('/admin/pplx-id');

                if (!response.ok) {
                    console.error('Erreur dans la réponse:', response.status);
                    return null;
                }

                const data = await response.json();

                if (data.pplx_id) {
                    return data.pplx_id;
                } else {
                    console.error('PPLX ID introuvable.');
                    return null;
                }

            } catch (error) {
                console.error('Erreur lors de la requête:', error);
                return null;
            }
        }

    </script>
@endpush
