<script>
    // SUPPORT
    var formatPrice = function(price){
        price = parseFloat(price);
        // Séparer la partie entière et la partie décimale
        var parts = price.toFixed(2).split('.');

        // Formater la partie entière avec des espaces
        var wholePart = parseInt(parts[0]).toLocaleString('fr-FR');

        // Partie décimale
        var decimalPart = ',' + parts[1];

        return [wholePart, decimalPart]
        // Afficher les parties séparées
    }

    var getStripePriceID = function(subscription_id, subscription_annual) {
        if (subscription_id == undefined)
            return null
        switch (subscription_id) {
            case '1':
                if(subscription_annual)
                    return 'price_1QDmC4GKHfaav9hRBeV6mW0G'
                else
                    return 'price_1PYViBGKHfaav9hR8uYFMrcv'
            case '2':
                if(subscription_annual)
                    return 'price_1QDmNXGKHfaav9hRqMgUFGxX'
                else
                    return 'price_1PYVgrGKHfaav9hRovLv0f1Y'
            case '3':
                if(subscription_annual)
                    return 'price_1QDmLcGKHfaav9hRjlnnuu4E'
                else
                    return 'price_1PXoY3GKHfaav9hRSvsF3I9e'
        }
    }

    var getPaypalPlanID = function(subscription_id, subscription_annual, subscription_type) {
        if (subscription_id == undefined)
            return null
        if(subscription_type === 'trial'){
            switch (subscription_id) {
                case '1':
                    if(parseInt(subscription_annual))
                        return 'P-71M81872TK168692KM4N3LGI'
                    else
                        return 'P-3U058892MF440380BM4N3LUY'
                case '2':
                    if(parseInt(subscription_annual))
                        return 'P-0BW717678R9933528M4N3GCQ'
                    else
                        return 'P-7D034451NW303101GM4N3GXQ'
                case '3':
                    if(parseInt(subscription_annual))
                        return 'P-0YV7634911943281BM4N27JI'
                    else
                        return 'P-34L16848A4742200SM3ZUUOY'
            }
        }else{
            switch (subscription_id) {
                case '1':
                    if(parseInt(subscription_annual))
                        return 'P-8R6730820C011103TM4PJHTQ'
                    else
                        return 'P-4SY18101UJ352825NM4PJBCI'
                case '2':
                    if(parseInt(subscription_annual))
                        return 'P-6G7268707S643943FM4PJJPI'
                    else
                        return 'P-4H8469630R8006457M4PJEHA'
                case '3':
                    if(parseInt(subscription_annual))
                        return 'P-04511543LH027535CM4PJJ5A'
                    else
                        return 'P-964667370V9778138M4PJE5I'
            }
        }


    }


    // START PRICING MODAL

    var lastSubscriptionInvoice = null;
    var paymentInfosSup = '';

    $('#btn-open-payment-modal, #test-modal').click(function(){
        $('#offer-name').text($('[name="subscription_name"]').val().toUpperCase())
        $('#subscription-price').text($('[name="subscription_value"]').val())
        $('#subscription-price-show, #annual-monthly-price-show').text(formatPrice($('[name="subscription_value"]').val())[0])
        $('#monthly-price-show').text(getMonthlyPrice(formatPrice($('[name="subscription_value"]').val())[0]))
        $('#economy-price').text(economyPrice(formatPrice($('[name="subscription_value"]').val())[0]))
        $('#card-name').val($('#register-form').find('[name="name"]').val())

    })
    $('.btn-open-payment-renew-modal').click(function(){
        $('#offer-name').text($(this).data('subscription-name').toUpperCase())
        $('#subscription-price').text($(this).data('subscription-price'))
        $('[name="subscription_value"]').val($(this).data('subscription-price'))
        $('#subscription-price-show').text(formatPrice($(this).data('subscription-price'))[0])
        $('#card-name').val($('[name="card-name"]').val())
        $('[name="new_subscription_id"]').val($(this).data('subscription-id'))
        $('[name="subscription_annual"][value="1"]').prop('checked', true);
        $('#economy-price').text(economyPrice(formatPrice($('[name="subscription_value"]').val())[0]))
        $('[name="annual"]').val(1)

        lastSubscriptionInvoice = JSON.parse($('[name="last-subscription-invoice"]').val())
        // Sélectionner par défaut le contenu de Stripe
        if(lastSubscriptionInvoice.mode === 'tmoney'){
            $('#menu-tmoney').click();
            $('[name="tmoney"]').val(lastSubscriptionInvoice.tel)
        }else if(lastSubscriptionInvoice.mode === 'flooz'){
            $('#menu-flooz').click();
            $('[name="flooz"]').val(lastSubscriptionInvoice.tel)
        }else{
            // $('#stripeContent').show();
            $('#menu-stripe').click();
        }
    })
    // Script pour gérer le changement de contenu en fonction du clic sur le menu de paiement
    $(document).ready(function() {
        $('.payment-method').click(function() {
            $('.payment-method').removeClass('active'); // Supprime la classe active de tous les éléments
            $(this).addClass('active'); // Ajoute la classe active à l'élément cliqué

            var target = $(this).data('target'); // Récupère l'ID du contenu cible
            $('.payment-content').hide(); // Cache tous les contenus de paiement
            $(target).show(); // Affiche le contenu cible
        });

    });

    // END PRICING MODAL

    // START STRIPE
    // Setup CSRF token for AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': '{{csrf_token()}}'
        }
    });
    // Create a Stripe instance with your publishable API key
    var stripe = Stripe('{{env('STRIPE_PK_TEST')}}');


    // Create an instance of Elements
    var elements = stripe.elements();

    // Create a card Element and mount it to the card-element div
    var cardElement = elements.create('card');
    cardElement.mount('#card-element');

    // Handle form submission
    $('#stripe-checkout-button').on('click', function(event) {
        event.preventDefault();
        $('#stripe-checkout-button').hide()
        $('.btn-modal-loading').show()
        var cardHolderName = $('[name="card_name"]').val()
        var email = lastSubscriptionInvoice ? lastSubscriptionInvoice.card_email : $('#register-form').find('[name="email"]').val()
        var price_id = getStripePriceID($('[name="subscription_id"]').val())


        $('[name="subscription_mode"]').val('stripe')
        stripe.createPaymentMethod({
            type: 'card',
            card: cardElement,
            billing_details: {
                name: cardHolderName,
            },
        })
        .then(function(result) {
            if (result.error) {
                $('#card-errors').show().text(result.error.message);
                $('.btn-modal-loading').hide()
                $('#stripe-checkout-button').show()
            } else {
                $.post('/create-subscription', {
                    payment_method: result.paymentMethod.id,
                    email: email,
                    name: cardHolderName,
                    price_id: price_id
                }, function(data) {
                    console.log('stripe data')
                    console.log(data)
                    if (data.error) {
                        $('#card-errors').show().text(data.error);
                    } else {
                        paymentInfosSup = JSON.stringify({
                            email: email,
                            name: cardHolderName,
                            tel: "",
                            stripe_id: data.subscription.id,
                        });
                        if($('#type-payment').val() === 'trial'){
                            // Convertir les informations de paiement en JSON et les encoder
                            // Mettre à jour la valeur de payment_infos_sup dans le formulaire
                            $('[name="payment_infos_sup"]').val(paymentInfosSup);
                            $('#register-form').submit()
                        }else{
                            let companyId = $('[name="company_id"]').val()
                            let subscriptionId = $('[name="new_subscription_id"]').val()
                            let type = 'renew'
                            let mode = 'stripe'

                            // Construire l'URL avec tous les paramètres nécessaires
                            let href = `/paiement_renew/${companyId}/${subscriptionId}/${type}/${mode}/${paymentInfosSup}`;

                            window.location.href = href
                        }
                        // alert('Abonnement réussi!');
                    }
                });
            }
        });
    });


    // END STRIPE

    // START PAYPAL
    // Charger le script SDK PayPal de manière asynchrone
    paypal.Buttons({
        style: {
            shape: 'pill',
            color: 'blue',
            layout: 'vertical',
            label: 'subscribe'
        },
        createSubscription: function(data, actions) {
            let subscriptionId = $('[name="new_subscription_id"]').val() ? $('[name="new_subscription_id"]').val() : $('[name="subscription_id"]').val()
            let subscriptionAnnual = $('[name="annual"]').val()
            let subscriptionType = $('#type-payment').val()
            let planID = getPaypalPlanID(subscriptionId, subscriptionAnnual, subscriptionType)
            return actions.subscription.create({
                'plan_id': planID // Votre plan ID PayPal
                // 'plan_id': 'P-34L16848A4742200SM3ZUUOY' // Votre plan ID PayPal
            });
        },
        onApprove: function(data, actions) {
            let paypal_given_name = $('[name=name]').val()
            let paypal_email = $('[name=email]').val()
            let subscriptionId = $('[name="new_subscription_id"]') ? $('[name="new_subscription_id"]').val() : $('[name="subscription_id"]').val()
            let subscriptionAnnual = $('[name="annual"]').val()
            let subscriptionType = $('#type-payment').val()
            let planID = getPaypalPlanID(subscriptionId, subscriptionAnnual, subscriptionType)
                $.ajax({
                url: "{{ route('paypal.subscription.create') }}",
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    subscriptionID: data.subscriptionID,
                    planID: planID,
                    // planID: 'P-34L16848A4742200SM3ZUUOY',
                    given_name: paypal_given_name,
                    email: paypal_email,
                },
                success: function(response) {
                    paymentInfosSup = JSON.stringify({
                        email: paypal_email,
                        name: paypal_given_name,
                        tel: "",
                        paypal_id: data.subscriptionID,
                    })
                    if($('#type-payment').val() === 'trial'){
                        // Convertir les informations de paiement en JSON et les encoder
                        // Mettre à jour la valeur de payment_infos_sup dans le formulaire
                        $('[name=subscription_mode]').val('paypal')
                        $('[name=payment_infos_sup]').val(paymentInfosSup)
                        $('#register-form').submit()
                    }else{
                        let companyId = $('[name="company_id"]').val()
                        let subscriptionId = $('[name="new_subscription_id"]').val()
                        let type = 'renew'
                        let mode = 'paypal'
                        let annual = $('[name="subscription_annual"]').val()
                        // let paypalId = data.subscriptionID

                        // Construire l'URL avec tous les paramètres nécessaires
                        let href = `/paiement_renew/${companyId}/${subscriptionId}/${type}/${annual}/${mode}/${paymentInfosSup}`;

                        window.location.href = href
                    }
                    // alert('ok')
                    {{--window.location.href = "{{ route('paypal.subscription.success') }}";--}}
                }
            });
        },
        onCancel: function(data) {
            console.log(data)
            $('#paypal-errors').show().text('Echec de paiement. Veuillez réessayer SVP');
            {{--window.location.href = "{{ route('paypal.subscription.cancel') }}";--}}
        }
    }).render('#paypal-button-container');

    // END PAYPAL

    // START PAYGATE
    $('#tmoney-checkout-button, #flooz-checkout-button').on('click', function(event) {
        event.preventDefault();
        $('[name="subscription_mode"]').val($(this).data('mode'))
        if($(this).data('mode') === 'tmoney')
            paymentInfosSup = JSON.stringify({
                email: "",
                name: "",
                tel: $('[name="tmoney_tel"]').val()
            })
        else
            paymentInfosSup = JSON.stringify({
                email: "",
                name: "",
                tel: $('[name="flooz_tel"]').val()
            })

        $('[name="payment_infos_sup"]').val(paymentInfosSup)
        $('#register-form').submit()
    })

    $('#tmoney-renew-checkout-button, #flooz-renew-checkout-button').on('click', function(event) {
        event.preventDefault();
        let companyId = $('[name="company_id"]').val()
        let subscriptionId = $('[name="new_subscription_id"]').val()
        let type = 'renew'
        let mode = $(this).data('mode')

        if($(this).data('mode') === 'tmoney')
            paymentInfosSup = JSON.stringify({
                email: "",
                name: "",
                tel: $('[name="tmoney_tel"]').val()
            })
        else
            paymentInfosSup = JSON.stringify({
                email: "",
                name: "",
                tel: $('[name="flooz_tel"]').val()
            })

        let href = '/paiement_renew/'+companyId+'/'+subscriptionId+'/'+type+'/'+mode+'/'+paymentInfosSup

        window.location.href = href
    })
    // END PAYGATE




</script>
