<script>
    let patientSelected = null
    let patientSelectedAge = null
    let patientSelectedGroupName = null
    let subStandardOnly = {!! json_encode(auth()->user()->subStandard() && !auth()->user()->subGold()) !!}

    setTimeout(function(){
        triggerPatientSelect()
    }, 3000)

    if(subStandardOnly)
        checkAiCredits()

    $('#btn-command').click(function(e){
        e.preventDefault()
        $('#command-bloc').append($('#command').html())
    })

    $('.form-body').on('click', '.delete-command', function(e){
        e.preventDefault()
        $(this).parent().remove()
    })

    $('#confirmCreateModal #submit').click(function(){
        $('#mainForm').submit()
    })

    $('#generate-prescription').click(function() {
        const description = tinymce.get('description').getContent()
        const prescription = tinymce.get('prescription')

        console.log(formatDescription(description))

        if(!description)
            return alert('Veuillez renseigner d\'abord le diagnostic du patient')
        else
            $('#generate-error').text('')

        $('#generate-prescription').hide()
        $('#generate-prescription-loading').show()

        $.ajax({
            url: 'https://api.perplexity.ai/chat/completions', // URL de l'API
            type: 'POST',
            contentType: 'application/json',
            headers: {
                'Authorization': 'Bearer {{env('PPLX_API')}}', // Remplacez par votre clé API
                'Accept': 'application/json'
            },
            data: JSON.stringify({
                model: 'llama-3.1-sonar-small-128k-online', // Modèle à utiliser
                messages: [
                    { role: 'user', content: formatDescription('Diagnostic: ' + description) }
                ]
            }),
            success: function(response) {
                prescription.setContent(marked.parse(response.choices[0].message.content))
                $('#generate-prescription-loading').hide()
                $('#generate-prescription').show()
                if(subStandardOnly){
                    updateAiCredits()
                    checkAiCredits()
                }
            },
            error: function(xhr, status, error) {
                console.error('Erreur:', error);
                $('#response').text('Une erreur est survenue.');
                $('#generate-prescription-loading').hide()
                $('#generate-prescription').show()
            }
        });
    })

    function formatDescription(message){
        const basicPrompt = 'Ordonnance médicale rédigée comme par un médecin pour un diagnostic que je vais décrire en dessous.\n' +
            'Je veux liste de médicaments (avec leur posologie respectifs) et de conseils.\n' +
            'Ne pas mentionner une consultation médicale (ne pas mentionner "il est important de consulter un médecin etc acr le but est d avoir une ordonnance rédigée comme un médecin").\n' +
            'La réponse ne contiendra que les medicaments prescrits et les conseils comme titre pas de d\'intro ni de conlusion ni de résumé en fin. ' +
            'La réponse ne dépassera pas 1000 caractères (très important) et réduis l\'espacement entre les interlignes et paragraphes. ' +
            'Substituer la réponse en 3 grands paragraphes: Diagnostic, Médicaments & Posologies et Conseils. Mettre "-" quand une info est absente  '

        const PatientInfos = 'Prendre compte des Infos du patient ci-dessous: '
            + 'nom & prénoms: '+patientSelected.name+'+'
            + 'age: '+patientSelectedAge+'+'
            + 'genre: '+patientSelected.sex+'+'
            + 'groupe sanguin: '+patientSelectedGroupName+' +'
            + 'poids: '+patientSelected.weight+'+'
            + 'taille: '+patientSelected.size+'+cm+'
            + 'pathologie: '+patientSelected.pathology+'+'
            + 'antécédent: '+patientSelected.antecedent+'+'
            + 'profession: '+patientSelected.job+'+'
            + 'température: '+$('[name="temperature"]').val()+'+'

        return basicPrompt + PatientInfos + message
    }

    function updateAiCredits(){
        $.post('{{route('companies.updateAiCredits')}}', {_token : "{{ csrf_token() }}"}, function(rsp){
            $('#ai-credits').text(rsp)
        })
    }

    const isOnlyStandard = "{{ (auth()->user()->subStandard() AND !auth()->user()->subGold()) ? 1 : 0 }}"

    function checkAiCredits(){
        if(isOnlyStandard)
            setTimeout(()=>{
                if($('#ai-credits').text() <= 0){
                    $('#doctor-ai').addClass('disabled')
                }
            }, 1000)
    }

    function triggerPatientSelect(){
        let selectedOption = $('[name="patient_id"]').find('option:selected')
        patientSelected = selectedOption.data('patient')
        patientSelectedAge = selectedOption.data('age')
        patientSelectedGroupName = selectedOption.data('group_name')
    }

    $('[name="patient_id"]').change(function(){
        triggerPatientSelect()
    })
</script>

<script>
    let adviceClick = false
    checkAiCredits()

    function generateAIAdvice() {
        if(!adviceClick){
            $('#doctor-ai-icon').hide()
            $('#doctor-ai-icon-loading').show()

            const AIAdvice = $('#ai-advice')
            $.ajax({
                url: 'https://api.perplexity.ai/chat/completions', // URL de l'API
                type: 'POST',
                contentType: 'application/json',
                headers: {
                    'Authorization': 'Bearer {{env('PPLX_API')}}', // Remplacez par votre clé API
                    'Accept': 'application/json'
                },
                data: JSON.stringify({
                    model: 'llama-3.1-sonar-small-128k-online', // Modèle à utiliser
                    messages: [
                        { role: 'user', content: formatAdvicePrompt() }
                    ]
                }),
                success: function(response) {
                    AIAdvice.html(marked.parse(response.choices[0].message.content))
                    $('#doctor-ai-icon-loading').hide()
                    $('#doctor-ai-icon').show()
                    adviceClick = true
                    updateAiCredits()
                    checkAiCredits()
                },
                error: function(xhr, status, error) {
                    console.error('Erreur:', error);
                    AIAdvice.html('<b style="color: red">Une erreur est survenue. Veuillez réessayer SVP</b>.')
                    $('#doctor-ai-icon-loading').hide()
                    $('#doctor-ai-icon').show()
                }
            });
        }
    }

    function formatAdvicePrompt(){
        const lastConsultation = {!! json_encode($data->lastConsultation()) !!}
        const consultationMessage = lastConsultation ?
            `dernier diagnostic consultation: ${lastConsultation.description}+` +
            `dernière température consultation: ${lastConsultation.temperature}+`
            : ''

        const lastTeleconsultation = {!! json_encode($data->lastTeleconsultation()) !!}
        const teleconsultationMessage = lastTeleconsultation ?
            `dernier diagnostic téléconsultation: ${lastTeleconsultation.description}+` +
            `dernière température téléconsultation: ${lastTeleconsultation.temperature}+`
            : ''

        const lastIntervention = {!! json_encode($data->lastIntervention()) !!}
        const interventionMessage = lastIntervention ?
            'maladie/gêne actuelle: ' + (lastIntervention.trouble ? lastIntervention.trouble.name : '') + '+' +
            'état actuel: ' + (lastIntervention.status ? lastIntervention.status.name : '') + '+' +
            'dernier diagnostic hospitalisation: ' + (lastIntervention ? lastIntervention.description : '') + '+' +
            'dernier température hospitalisation: ' + (lastIntervention ? lastIntervention.temperature : '') + '+'
            : '';

        const finalMessage = 'Donne moi des conseils de soins (pour une prochaine consultation et hospitalisation) pour ce patient dont les infos sont données ci-dessous. nb: limiter les espacements et les interlignes: '
            + 'noms: {{$data->name}}+'
            + 'age: {{$data->age()}}+'
            + 'genre: {{$data->sex}}+'
            + 'groupe sanguin: {{$data->group->name}}+'
            + 'pathologie: {{$data->pathology}}+'
            + 'profession: {{$data->job}}+'
            + 'poids: {{$data->weight}}+'
            + 'taille: {{$data->size}}cm+'
            + 'antécédent: {{$data->antecedent}}+'
            + consultationMessage
            + interventionMessage
            + teleconsultationMessage

        return finalMessage
    }

    function updateAiCredits(){
        $.post('{{route('companies.updateAiCredits')}}', {_token : "{{ csrf_token() }}"}, function(rsp){
            $('#ai-credits').text(rsp)
        })
    }

    const isOnlyStandard = "{{ (auth()->user()->subStandard() AND !auth()->user()->subGold()) ? 1 : 0 }}"

    function checkAiCredits(){
        if(isOnlyStandard)
            setTimeout(()=>{
                if($('#ai-credits').text() <= 0){
                    $('#doctor-ai').addClass('disabled')
                }
            }, 1000)
    }
</script>
