<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script>
    $(document).ready(function() {
        var recognition;
        var countdown;
        var countdownInterval;
        var countdownTime = 3; // Temps en secondes pour le compte à rebours
        var finalTranscript = ''; // Texte final accumulé

        // Fonction pour mettre à jour le minuteur
        function updateCountdown() {
            $('.countdown').text(countdown);
        }

        // Fonction pour démarrer le compte à rebours
        function startCountdown() {
            countdown = countdownTime;
            updateCountdown();
            $('.countdown').show();

            countdownInterval = setInterval(function() {
                countdown--;
                if (countdown >= 1) {
                    updateCountdown();
                } else {
                    clearInterval(countdownInterval);
                    $('.countdown').hide();
                    $('#stop-btn').show();
                    if (recognition) {
                        recognition.start(); // Démarre la reconnaissance vocale après le compte à rebours
                    }
                }
            }, 1000);
        }

        // Fonction déclenchée lors du clic sur le bouton "start"
        $('#start-btn').click(function() {
            // Vérifier la compatibilité de la reconnaissance vocale lors du clic sur "start"
            if ('webkitSpeechRecognition' in window || 'SpeechRecognition' in window) {
                if ('webkitSpeechRecognition' in window) {
                    recognition = new webkitSpeechRecognition();
                } else {
                    recognition = new SpeechRecognition();
                }

                recognition.continuous = true;
                recognition.interimResults = true;
                recognition.lang = 'fr-FR'; // Langue du texte généré

                recognition.onstart = function() {
                    $('#start-btn').hide();
                };

                recognition.onresult = function(event) {
                    var interimTranscript = ''; // Texte temporaire pendant la dictée

                    // Récupérer l'éditeur TinyMCE
                    var description = tinymce.get('description');
                    var reason = tinymce.get('reason');

                    // Parcourir les résultats de la reconnaissance vocale
                    for (var i = event.resultIndex; i < event.results.length; ++i) {
                        if (event.results[i].isFinal) {
                            // Ajouter le texte final à la transcription complète
                            finalTranscript += event.results[i][0].transcript;
                        } else {
                            // Si ce n'est pas finalisé, c'est une transcription intermédiaire
                            interimTranscript += event.results[i][0].transcript;
                        }
                    }

                    // Afficher le texte intermédiaire + final dans l'éditeur
                    if(description)
                        description.setContent(finalTranscript + ' ' + interimTranscript, {format: 'raw'});
                    if(reason)
                        reason.setContent(finalTranscript + ' ' + interimTranscript, {format: 'raw'});
                };

                recognition.onend = function() {
                    $('#start-btn').show();
                    $('#stop-btn').hide();
                };

                $('#start-btn').hide();
                startCountdown(); // Lance le compte à rebours
            } else {
                // Afficher l'erreur uniquement lorsque l'utilisateur clique sur "start"
                alert("La reconnaissance vocale n'est pas prise en charge sur ce navigateur. Veuillez utiliser Google Chrome ou Microsoft Edge.");
            }
        });

        $('#stop-btn').click(function() {
            clearInterval(countdownInterval);
            $('.countdown').hide();
            if (recognition) {
                recognition.stop(); // Arrête la reconnaissance vocale
            }
        });
    });
</script>
<!-- end js include path -->

<script>
    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
        $('[title]').tooltip();
    })

    $('.fa-eye').click(function(){
        $(this).hide()
        $('.fa-eye-slash').show()
        $('#password-input').attr('type', 'text')
    })
    $('.fa-eye-slash').click(function(){
        $(this).hide()
        $('.fa-eye').show()
        $('#password-input').attr('type', 'password')
    })

    $('.btn-save').click(function(){
        $(this).hide()
        $('.btn-loading').show()
    })


    $('#btn-continue').click(function (){
        $('#step1').hide()
        $('#step2').show()
    })

    $('#btn-back').click(function (){
        $('#step2').hide()
        $('#step1').show()
    })

    // Dès que l'utilisateur sélectionne un fichier
    $("#logo-file-input").change(function() {
        var fileInput = $(this)[0];
        var uploadedImage = $("#logo-uploaded-image");

        if (fileInput.files && fileInput.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                // Affiche l'image dans le label
                uploadedImage.attr('src', e.target.result);
                $("#logo-label").css("background-image", "url(" + e.target.result + ")");
                $("#logo-label").addClass("uploaded");
            }

            // Charge le fichier sélectionné en tant que données URL
            reader.readAsDataURL(fileInput.files[0]);
        }
    });

    // Lorsque l'utilisateur clique sur l'image (label), déclenche l'input file
    $("#logo-label").click(function() {
        $("#logo-file-input").click();
    });

    // Dès que l'utilisateur sélectionne un fichier
    $("#signature-file-input").change(function() {
        var fileInput = $(this)[0];
        var uploadedImage = $("#signature-uploaded-image");

        if (fileInput.files && fileInput.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                // Affiche l'image dans le label
                uploadedImage.attr('src', e.target.result);
                $("#signature-label").css("background-image", "url(" + e.target.result + ")");
                $("#signature-label").addClass("uploaded");
            }

            // Charge le fichier sélectionné en tant que données URL
            reader.readAsDataURL(fileInput.files[0]);
        }
    });

    // Lorsque l'utilisateur clique sur l'image (label), déclenche l'input file
    $("#photo-label").click(function() {
        $("#photo-file-input").click();
    });

    // Dès que l'utilisateur sélectionne un fichier
    $("#photo-file-input").change(function() {
        var fileInput = $(this)[0];
        var uploadedImage = $("#photo-uploaded-image");

        if (fileInput.files && fileInput.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                // Affiche l'image dans le label
                uploadedImage.attr('src', e.target.result);
                $("#photo-label").css("background-image", "url(" + e.target.result + ")");
                $("#photo-label").addClass("uploaded");
            }

            // Charge le fichier sélectionné en tant que données URL
            reader.readAsDataURL(fileInput.files[0]);
        }
    });

    // Lorsque l'utilisateur clique sur l'image (label), déclenche l'input file
    $("#photo-label").click(function() {
        $("#photo-file-input").click();
    });

    // toogle condtions inscription
    $('#conditions').change(function(){
        if($(this).is(':checked') ){
            $('.btn-save').removeAttr('disabled')
        }
        else{
            $('.btn-save').attr('disabled', true)
        }
    })

    // controles champs inscription
    $('#step1 input').on('input', function () {
        // Vérifier si tous les champs ne sont pas vides
        var tousLesChampsRemplis = true;
        $('#step1 input').each(function () {
            if ($(this).val() === '') {
                tousLesChampsRemplis = false;
                return false; // Sortir de la boucle each si un champ est vide
            }
        });

        // Activer ou désactiver le bouton de soumission en fonction de l'état des champs
        if (tousLesChampsRemplis) {
            $('#btn-continue').prop('disabled', false);
        } else {
            $('#btn-continue').prop('disabled', true);
        }
    });



    // teleconsultation
    // Récupérer le nom de la salle depuis le lien de l'iframe généré par Laravel
    setTimeout(() => {
        const iframe = document.getElementById('jitsiIframe');
        if (!iframe) {
            console.error("L'iframe Jitsi n'est pas chargé correctement.");
            return;
        }

        const roomName = iframe.src.split('/').pop(); // Extrait le nom de la réunion
        const domain = 'meet.jit.si';

        console.log('Initialisation Jitsi avec roomName :', roomName);

        const api = new JitsiMeetExternalAPI(domain, {
            roomName: roomName,
            parentNode: document.getElementById('live-container')
        });

        api.addEventListener('videoConferenceJoined', () => {
            console.log('L\'API Jitsi a rejoint la conférence.');
            alert('Conférence Jitsi initialisée avec succès !');
        });

        api.executeCommand('toggleVideo');

        // Événement lors du début de la conférence
        api.addEventListener('conferenceJoined', () => {
            const startTime = new Date();
            alert('La réunion a commencé à : ' + startTime);
        });

        // Événement lors de la fin de la conférence
        api.addEventListener('conferenceLeft', () => {
            const endTime = new Date();
            const duration = (endTime - startTime) / 1000; // Durée en secondes
            alert('La réunion a duré : ' + duration + ' secondes');
        });

    }, 5000); // Ajustez le délai si nécessaire



    // Paiement modal scripts

    setTimeout(function(){
        const inputSubscriptionAnnual = $('[name="new_subscription_id"]').val() ? $('#paymentRenewModal input[name="subscription_annual"]') : $('input[name="subscription_annual"]')
        inputSubscriptionAnnual.on('click', function() {

            // Récupérer le prix comme texte depuis #subscription-price-show
            let formattedPrice = formatPrice($('[name="subscription_value"]').val());
            let priceSelectedShow = Array.isArray(formattedPrice) ? formattedPrice[0].toString() : formattedPrice.toString();
            const selectedOption = $(this).val();
            // Convertir le prix s'il est sélectionné comme 'Mensuel'
            let price = selectedOption === '0' ? getMonthlyPrice(priceSelectedShow) : priceSelectedShow;

            // Mettre à jour le prix affiché
            $('#subscription-price-show').text(`${price}`);
            $('#economy-price').text(`${economyPrice(price)}`);
            $('[name="annual"]').val(selectedOption)
        });
    }, 3000)

    function getMonthlyPrice(annualMonthlyPriceString){
        switch (annualMonthlyPriceString.replace(/\s/g, '')){ // Supprimer les espaces
            case '212':
                return '249';
            case '409':
                return '499';
            case '1199':
                return '1 499';
            default:
                return annualMonthlyPriceString;
        }
    }

    function economyPrice(annualMonthlyPriceString){
        switch (annualMonthlyPriceString.replace(/\s/g, '')){ // Supprimer les espaces
            case '212':
                return '37 €';
            case '409':
                return '90 €';
            case '1199':
                return '300 €';
            default:
                return '0 €';
        }
    }

</script>

