@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Ventes ({{ $datas->count() }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('sales.create') }}">Ajouter</a>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab1" data-toggle="tab">Liste</a></li>

                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active fontawesome-demo" id="tab1">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card  card-box">
                                        <div class="card-head">
                                            <header></header>
                                            <div class="tools">
                                                <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                                                <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                                                <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                                            </div>
                                        </div>
                                        <div class="card-body ">

                                            <div class="table-scrollable">
                                                <table class="table table-hover  full-width custom">
                                                    <thead>
                                                    <tr>
                                                        <th> Date </th>
                                                        <th> Vendeur </th>
                                                        <th> Commande </th>
                                                        <th> Total ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}) </th>
                                                        <th> Actions </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($datas as $data)

                                                        <tr>
                                                            <td>{{ $data->datetime->translatedFormat('D d M Y à H:i') }}</td>
                                                            <td>{{ $data->user->name }}</td>
                                                            <td class="center"><a href="#"  data-target="#saleModal" class="commands-link" data-toggle="modal" data-content="{{ $data->commands }}">Voir</a></td>
                                                            <td>{{ number_format($data->total, 0, '', ' ') }}</td>
                                                            <td class="center">
{{--                                                                <a href="{{ route('sales.edit', $data) }}" class="">--}}
{{--                                                                    <i class="hgi-stroke hgi-edit-02 text-dark h3"></i>--}}
{{--                                                                </a>--}}
                                                                @if($data->invoice())
                                                                    <a href="{{ route('invoices.download', [$data->invoice()->custom_id, 'sale']) }}" class="" data-toggle="tooltip" data-placement="top" title="Télécharger la Facture">
                                                                        <i class="hgi-stroke hgi-file-download text-dark h3"></i>
                                                                    </a>
                                                                @endif
                                                                @if(!$data->hasRelatedRecords())
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('sales.delete', $data->custom_id) }}" data-toggle="tooltip" data-placement="top" class="" title="Supprimer">
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3"></i>
                                                                </a>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('.commands-link').click(function () {
            var commands = JSON.parse($(this).attr('data-content'))
            var content = '<table style="margin: auto">';
            let total_qte = 0
            let total_price = 0
            let currency = '{{ auth()->user()->company->currency_symbol }}'
            for(var i in commands){
                total_qte += commands[i].qte
                total_price += commands[i].price
                content += '<tr>' +
                    '<td>' + commands[i].productName + '</td>' +
                    '<td> &nbsp; &nbsp;x' + commands[i].qte + '</td>' +
                    '<td align="right"> &nbsp; &nbsp;' + commands[i].price.toLocaleString('fr-FR') + currency + '</b></td>' +
                    '</tr>'
            }
            content += '<tfoot class="text-dark">' +
                '<tr>' +
                '<td style="padding-top: 20px"><b>TOTAL</b></td>' +
                '<td style="padding-top: 20px"> &nbsp; &nbsp;<b>'+total_qte+'</b></td>' +
                '<td align="right" style="padding-top: 20px"> &nbsp; &nbsp;<b>' + total_price.toLocaleString('fr-FR') + currency + '</b></td>' +
                '</tr>' +
                '</tfoot>'
            content += '</table>'
            $('#saleModal .modal-body').html(content)
        })
    </script>
@endpush
