@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Ajouter une Vente</div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
                        {{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
                        {{--                            data-mdl-for = "panel-button">--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('sales.store') }}" method="POST" id="form_sample_1" class="form-horizontal">
                                @csrf
                                <div class="form-body">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Produits

                                        </label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="product_id[]" style="width: 78%; display: inline-block">
                                                <option value="">Selectionnez</option>
                                                @foreach($products as $product)
                                                    <option value="{{ $product->id }}">{{ $product->name }} ({{$product->selling_price}} F)</option>
                                                @endforeach
                                            </select>
                                            <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                        </div>
                                        <a href="#" data-target="#productModal" data-toggle="modal" class="nav-link btn btn-primary btn-sm insert-product">+</a>
                                    </div>
                                    <div id="command-bloc">
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">
                                        </label>
                                        <div class="col-md-5">
                                            <a href="#" id="btn-command" class="btn btn-outline-primary btn-sm">Ajouter un produit</a>
                                        </div>
                                    </div>

                                    <template id="command">
                                        <div class="form-group row">
                                            <label class="control-label col-md-3"></label>
                                            <div class="col-md-5">
                                                <select class="form-control input-height" name="product_id[]" style="width: 78% ; display: inline-block">
                                                    <option value="">Selectionnez</option>
                                                    @foreach($products as $product)
                                                        <option value="{{ $product->id }}">{{ $product->name }} ({{$product->selling_price}} F)</option>
                                                    @endforeach
                                                </select>
                                                <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                            </div>
                                            <a href="#" class="delete-command nav-link btn btn-danger btn-sm" style="padding: 7px 18px !important; font-size: 20px;">-</a>
                                            <a href="#" data-target="#productModal" data-toggle="modal" class="nav-link btn btn-primary btn-sm ml-3 insert-product">+</a>
                                        </div>
                                    </template>


                                    <div class="form-actions">
                                        <div class="row">
                                            <div class="offset-md-3 col-md-9">
                                                <button type="submit" class="btn btn-primary">Enregistrer</button>
                                                <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('.form-body').on('click', '.delete-command', function(e){
            e.preventDefault()
            $(this).parent().remove()
        })

        $('#confirmCreateModal #submit').click(function(){
            $('#mainForm').submit()
        })
    </script>
@endpush
