@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Chambres ({{ $datas->count() }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('rooms.create') }}">Ajouter</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab1" data-toggle="tab">Liste</a></li>

                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active fontawesome-demo" id="tab1">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card  card-box">
                                        <div class="card-head">
                                            <header></header>
                                            <div class="tools">
                                                <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                                                <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                                                <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                                            </div>
                                        </div>
                                        <div class="card-body ">

                                            <div class="table-scrollable">
                                                <table class="table table-hover  full-width custom">
                                                    <thead>
                                                    <tr>
                                                        <th> Nom </th>
                                                        <th> Département </th>
                                                        <th> Prix {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!} / Jour</th>
                                                        <th> Actions </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($datas as $data)
                                                        <tr>
                                                            <td>{{ $data->name }}</td>
                                                            <td>{{ $data->department?$data->department->name:'' }}</td>
                                                            <td>{{ $data->price }}</td>
                                                            <td class="center">
                                                                <a href="{{ route('rooms.edit', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Modifier">
                                                                    <i class="hgi-stroke hgi-edit-02 text-dark h3"></i>
                                                                </a>
                                                                @if(!$data->hasRelatedRecords())
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('rooms.delete', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Supprimer">
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3"></i>
                                                                </a>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#archiveToggle').change(function(){
            if(this.checked) {
                $('.not-archive').hide()
                $('.archive').show()
            }else{
                $('.archive').hide()
                $('.not-archive').show()
            }
        })
    </script>
@endpush
