@include('helpers.ChiffresEnLettres')

    <!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <style>
        body{
            padding: 0 !important;
            font-size: 11px !important;
        }

        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 0px;
            border: 0px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, .15);
            font-size: 11px;
            line-height: 24px;
            font-family: 'century gothic', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 0px;
            vertical-align: top;
            font-size: 10px !important;
        }

        .invoice-box table tr td:nth-child(2) {
            /*text-align: right;*/
        }

        .invoice-box table tr.top table td {
            padding-bottom: 0px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 12px;
            /*line-height: 45px;*/
            color: #333;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 0px;
        }

        .invoice-box table tr.heading td {
            background: #f5f5f5;
            font-weight: bold;
            padding-bottom: 5px;
        }

        .invoice-box table tr.heading td:nth-child(1) {
            border-radius: 50px 0 0 50px;
            padding-left: 10px
        }

        .invoice-box table tr.heading td:nth-child(4) {
            border-radius:  0 50px 50px 0;
            padding-right: 10px
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td{
            border-bottom: 1px solid #eee;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(4) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        /* Ajoute un style pour la pagination */
        .page-break {
            page-break-after: always;
        }
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 9px;
        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        /** RTL **/
        .rtl {
            direction: rtl;
            font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        }

        .rtl table {
            text-align: right;
        }

        .rtl table tr td:nth-child(1) {
            text-align: left;
        }

        .top-header{
            font-size: 11px
        }

        tr.heading td:nth-child(3), tr.item td:nth-child(3){
            /*text-align: left !important;*/
        }

        tr.heading td:nth-child(4), tr.item td:nth-child(4),
        tr.heading td:nth-child(3), tr.item td:nth-child(3),
        .information td:nth-child(2), .top td:nth-child(2),
        .signature td:nth-child(2)
        {
            text-align: right !important;
        }
    </style>
</head>

<body>
@php $company = auth()->user()->company; @endphp
<div class="invoice-box">
    <table cellpadding="0" cellspacing="0">
        <tr class="top">
            <td colspan="4">
                <table>
                    <tr>
                        <td class="title">
                            @if($company->logo)
                                <img src="{{ public_path(env('APP_URL').'storage/uploads/company/'.$company->logo) }}" style="width:100%; max-width:100px;"><br>
                            @endif
                                <b style="font-size: 11px">{{ $company->name }}</b>
                                <br>{{ $company->tel }}
                                <br>{{ $company->address }}
                        </td>

                        <td>
                            <div class="top-header">
                                <i>{{$company->city ? $company->city : 'Lomé'}}, le {{ $data->date->format('d') }} {{ $data->monthToFr() }} {{ $data->date->format('Y') }}</i><br>
                                <b>Hospitalisation</b>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

{{--        <tr class="information">--}}
{{--            <td colspan="4">--}}
{{--                <table>--}}
{{--                    <tr>--}}
{{--                        <td>--}}
{{--                            <p style="font-size: 11px">--}}
{{--                                <b>Dr. {{ $company->doctor }}</b><br>--}}
{{--                                @if($company->diploma)--}}
{{--                                ({{ $company->diploma }})--}}
{{--                                @endif--}}
{{--                            </p>--}}
{{--                        </td>--}}
{{--                        <td>--}}
{{--                            <p style="font-size: 11px">--}}
{{--                                <b>{{ $data->patient->name }}</b><br>--}}
{{--                                @if($data->patient->email) {{ $data->patient->email }}<br> @endif--}}
{{--                                {{ $data->patient->tel }}--}}
{{--                                {!! $data->patient->address !!}--}}
{{--                                <i>{{ $data->patient->assured ? 'Assuré' : 'Non Assuré' }}</i>--}}
{{--                            </p>--}}
{{--                        </td>--}}
{{--                    </tr>--}}
{{--                </table>--}}
{{--            </td>--}}
{{--        </tr>--}}
        <tr>
            <td colspan="4" style="text-align: center">
                <h2>FACTURE Nº {{ $data->no() }}</h2>
                <h5>Patient : {{ $data->patient->name }}, {{ $data->patient->tel }} &nbsp; | &nbsp; Date des soins :
                    <b>{{ $data->intervention->datetimefrom->format('d') }} {{ $data->monthToFr($data->intervention->datetimefrom) }} @if(!$data->intervention->datetimeto){{ $data->intervention->datetimefrom->format('Y') }}@endif</b>
                    @if($data->intervention->datetimeto)
                    au <b>{{ $data->intervention->datetimeto->format('d') }} {{ $data->monthToFr($data->intervention->datetimeto) }} {{ $data->intervention->datetimeto->format('Y') }}</b>
                    @endif
                </h5>
            </td>
        </tr>

        <tr class="heading">
            <td style="text-align: left !important;">Désignation</td>
            <td style="text-align: center">Quantité</td>
            <td>Prix Unitaire</td>
            <td>Prix Total</td>
        </tr>
        @if($data->intervention->interventionanalyses->count())
        <tr class="item">
            <td style="text-align: left !important;" colspan="4"><b>Analyses</b></td>
            {{--            <td style="text-align: center">1</td>--}}
            {{--            <td>{{ number_format($interventioncare->amount(), 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>--}}
            {{--            <td>{{ number_format($interventioncare->amount(), 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>--}}
        </tr>
        @foreach($data->intervention->interventionanalyses as $interventionanalysis)
            <tr class="item">
                <td style="text-align: left !important;">{{ $interventionanalysis->analysis->name }} = <b>{{ $interventionanalysis->result }}</b></td>
                <td style="text-align: center">1</td>
                <td>{{ number_format($interventionanalysis->analysis->amount, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
                <td>{{ number_format($interventionanalysis->analysis->amount, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
            </tr>
        @endforeach
        @endif
        <tr class="item">
            <td style="text-align: left !important;" colspan="4"><b>Prestations</b></td>
{{--            <td style="text-align: center">1</td>--}}
{{--            <td>{{ number_format($interventioncare->amount(), 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>--}}
{{--            <td>{{ number_format($interventioncare->amount(), 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>--}}
        </tr>
        @foreach($data->intervention->interventioncares as $interventioncare)
            <tr class="item">
                <td style="text-align: left !important;">{{ $interventioncare->care->name }}</td>
                <td style="text-align: center">1</td>
                <td>{{ number_format($interventioncare->price, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
                <td>{{ number_format($interventioncare->price, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
            </tr>
        @endforeach

        @if($data->sale)
            <tr class="item">
            <td style="text-align: left !important;" colspan="4"><b>Pharmacie interne</b></td>
            </tr>
        @foreach($data->sale->commands as $command)
                <tr class="item">
                    <td style="text-align: left !important;">{{ $command->product->name }} </td>
                    <td style="text-align: center">{{ $command->qte }}</td>
                    <td>{{ number_format($command->product->selling_price, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
                    <td>{{ number_format($command->qte * $command->product->selling_price, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
                </tr>
        @endforeach
        @endif
        <tr class="item">
            <td style="text-align: left !important;"><b>Chambre</b></td>
            <td style="text-align: center">{{ $data->intervention->days() }}</td>
            <td>{{ $data->intervention->room->price }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</td>
            <td><b>{{ number_format($data->intervention->room->price * $data->intervention->days(), 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</b></td>
        </tr>
        @if($company->tva)
            <tr class="item">
                <td align="left"><b>Montant TVA</b></td>
                <td></td>
                <td></td>
                <td align="right">
                    <b>{{ number_format($data->tva_amount, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</b>
                </td>
            </tr>
        @endif
        <tr class="item" >
            <td align="left"><b>Total Général</b></td>
            <td></td>
            <td></td>
            <td align="right">
                <b>{{ number_format($data->total, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</b>
            </td>
        </tr>

        @if($data->discount)
            <tr class="item">
                <td align="left"><b>Remise</b></td>
                <td></td>
                <td></td>
                <td align="right">
                    <b>{{ number_format($data->discount, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</b>
                </td>
            </tr>
        @endif
        <tr class="item">
            <td align="left"><b>Total à payer</b></td>
            <td></td>
            <td></td>
            <td align="right">
                <b>{{ number_format($data->total - $data->discount, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}
                    <br>(<b>{{ convertCurrencyToWords($data->total - $data->discount) }} {{ auth()->user()->company->currency }}</b>)</b>
            </td>
        </tr>
    </table>
    <table>
        <tr class="signature" style="font-size: 10px">
            <td>Signature du Patient</td>
            <td>
                Signature
                @if($company->signature)
                    <br>
                    <img src="{{ public_path(env('APP_URL').'storage/uploads/company/'.$company->signature) }}"  style="height:50px;  max-height:50px; text-align: right" alt="">
                @endif
                <br>
                <b>Dr. {{ $company->doctor }}</b>
            </td>
        </tr>
    </table>
    <hr style="border: 1px solid #eee"/>
    <table>
        <tr style="font-size: 9px">
            <td colspan="2" style="font-size: 9px; text-align: left; color: gray">
                <div style="width: 50%">
                    {!! $company->header !!}
                </div>
            </td>
            <td colspan="2" style="font-size: 9px; text-align: right; color: gray">
                <div style="width: 100%">
                    {!! $company->footer !!}
                </div>
            </td>
        </tr>
    </table>
    <!-- Script pour ajouter les numéros de page -->
    <script type="text/php">
        if ( isset($pdf) ) {
            $pdf->page_script('
                if ($PAGE_COUNT > 1) {
                    $font = $fontMetrics->get_font("Arial, Helvetica, sans-serif", "normal");
                    $size = 10;
                    $pageText = "Page " . $PAGE_NUM . " / " . $PAGE_COUNT;
                    $y = 820;  // Position verticale du texte
                    $x = 520;  // Position horizontale du texte
                    $pdf->text($x, $y, $pageText, $font, $size);
                }
            ');
        }
    </script>
</div>


</body>
</html>
