@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Patients ({{ $datas->count() }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('patients.create') }}">Ajouter</a>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab1" data-toggle="tab">Liste</a></li>

                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active fontawesome-demo" id="tab1">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card  card-box">
                                        <div class="card-head">
                                            <header></header>
                                            <div class="tools">
                                                <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                                                <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                                                <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                                            </div>
                                        </div>
                                        <div class="card-body ">
                                            <div class="pull-right m-r-50" style="width: 20%">
                                                <label style="vertical-align: middle; font-size: 12px">Archivés</label><br>
                                                <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                                       for = "archiveToggle">
                                                    <input type = "checkbox" id = "archiveToggle"
                                                           class = "mdl-switch__input">
                                                </label>
                                            </div>
                                            <div class="pull-right " style="width: 20%">
                                                <label style="vertical-align: middle; font-size: 12px">En hospitalisation</label><br>
                                                <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                                       for = "stayToggle">
                                                    <input type = "checkbox" id = "stayToggle"
                                                           class = "mdl-switch__input" checked>
                                                </label>
                                            </div>
                                            <div class="table-scrollable">
                                                <table class="table table-hover full-width custom">
                                                    <thead>
                                                    <tr>
                                                        <th> Chambre </th>
                                                        <th style="width: 20%"> Noms </th>
                                                        <th> Sexe </th>
                                                        <th> Téléphone </th>
                                                        <th>Groupe</th>
                                                        <th>Etat Actuel</th>
                                                        <th> Assuré </th>
                                                        @if(!auth()->user()->isSecretary())
                                                        <th class="text-center"> Prise en charge </th>
                                                        @endif
                                                        <th> Actions </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($datas as $data)
                                                    @if(!$data->archive)
                                                    <tr class="not-archive @if($data->isStay()) stayed @endif">
                                                        <td class="center">{{ $data->lastIntervention() ? $data->lastIntervention()->room->name : '' }} {{ $data->lastIntervention() ? ($data->lastIntervention()->room->department?' - '.$data->lastIntervention()->room->department->name:'') : '' }}</td>
                                                        <td>
                                                            <a href="{{ route('patients.show', $data->custom_id) }}" class="text-primary">
                                                            {{ $data->name }}
                                                            </a>
                                                        </td>
                                                        <td class="center">{{ $data->sex }}</td>
                                                        <td><a href="tel:{{ $data->tel }}" data-toggle="tooltip" data-placement="top" title="Appeler">
                                                                {{ $data->tel }} </a></td>
                                                        <td class="center">{{ $data->group->name }}</td>
                                                        <td class="center">{{ $data->lastIntervention() ? $data->lastIntervention()->status->name : '' }}</td>
                                                        <td class="center">{{ $data->assured ? 'Oui' : 'Non' }}</td>
                                                        @if(!auth()->user()->isSecretary())
                                                        <td class="center small">
                                                            <a href="{{ route('patients.show', $data->custom_id) }}" class="btn btn-light btn-sm m-2">
                                                                <i class="fas fa-eye"></i> Suivi
                                                            </a>
                                                            @if(auth()->user()->subStandard())
{{--                                                            <a href="{{ route('teleconsultations.liveID', $data->custom_id) }}" class="btn btn-light btn-sm m-2">--}}
{{--                                                                <i class="fas fa-laptop-medical"></i> Téléconsulter--}}
{{--                                                            </a>--}}
                                                            @endif
                                                            <a href="{{ route('consultations.createID', $data->custom_id) }}" class="btn btn-light btn-sm m-2">
                                                                <i class="fas fa-notes-medical"></i> Consulter
                                                            </a>
                                                            <a href="{{ route('interventions.createID', $data->custom_id) }}" class="btn btn-light btn-sm m-2">
                                                                <i class="fas fa-ambulance"></i> Hospitaliser
                                                            </a>
                                                        </td>
                                                        @endif
                                                        <td class="center">
{{--                                                            @if(auth()->user()->subGold())--}}
                                                                <a href="{{ route('patients.downloadTicket', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-file-download text-dark h3" data-toggle="tooltip" data-placement="top" title="Télécharger le Ticket"></i>
                                                                </a>
{{--                                                            @endif--}}
                                                            <a href="{{ route('patients.archive', $data->custom_id) }}" class="" >
                                                                <i class="hgi-stroke hgi-archive-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Archiver"></i>
                                                            </a>
                                                            <a href="{{ route('patients.edit', $data->custom_id) }}" class="" >
                                                                <i class="hgi-stroke hgi-edit-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Modifier"></i>
                                                            </a>
                                                            @if(!$data->hasRelatedRecords())
                                                            <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('patients.delete', $data->custom_id) }}" class="">
                                                                <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" data-toggle="tooltip" data-placement="top" title="Supprimer"></i>
                                                            </a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    @else
                                                    <tr class="archive" style="display: none">
                                                        <td class="center">{{ $data->lastIntervention() ? $data->lastIntervention()->room->name : '' }} {{ $data->lastIntervention() ? ($data->lastIntervention()->room->department?' - '.$data->lastIntervention()->room->department->name:'') : '' }}</td>
                                                            <td>{{ $data->name }}</td>
                                                            <td class="center">{{ $data->sex }}</td>
                                                            <td><a href="tel:{{ $data->tel }}" data-toggle="tooltip" data-placement="top" title="Appeler">
                                                                    {{ $data->tel }} </a></td>
                                                            <td class="center">{{ $data->group->name }}</td>
                                                            <td class="center">{{ $data->lastIntervention() ? $data->lastIntervention()->status->name : '' }}</td>
                                                            <td class="center">{{ $data->assured ? 'Oui' : 'Non' }}</td>
                                                            <td class="center">
                                                                <a href="{{ route('consultations.createID', $data->custom_id) }}" class="btn btn-outline-success">
                                                                    <i class="fas fa-notes-medical"></i> Consulter
                                                                </a>
                                                                <a href="{{ route('interventions.createID', $data->custom_id) }}" class="btn btn-outline-danger">
                                                                    <i class="fas fa-ambulance"></i> Hospitaliser
                                                                </a>
                                                            </td>
                                                        <td class="center">
                                                            {{--                                                            @if(auth()->user()->subGold())--}}
                                                            <a href="{{ route('patients.downloadTicket', $data->custom_id) }}" class="" >
                                                                <i class="hgi-stroke hgi-file-download text-dark h3" data-toggle="tooltip" data-placement="top" title="Télécharger le Ticket"></i>
                                                            </a>
                                                            {{--                                                            @endif--}}
                                                            <a href="{{ route('patients.archive', $data->custom_id) }}" class="" >
                                                                <i class="hgi-stroke hgi-arrow-turn-backward text-dark h3" data-toggle="tooltip" data-placement="top" title="Restaurer"></i>
                                                            </a>
                                                            <a href="{{ route('patients.edit', $data->custom_id) }}" class="" >
                                                                <i class="hgi-stroke hgi-edit-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Modifier"></i>
                                                            </a>
                                                            @if(!$data->hasRelatedRecords())
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('patients.delete', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" data-toggle="tooltip" data-placement="top" title="Supprimer"></i>
                                                                </a>
                                                            @endif
                                                        </td>
                                                        </tr>
                                                    @endif
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#archiveToggle').change(function(){
            if(this.checked) {
                $('.not-archive').hide()
                $('.archive').show()
            }else{
                $('.archive').hide()
                $('.not-archive').show()
            }
        })

        $('#stayToggle').change(function(){
            if(this.checked) {
                $('.stayed').show()
            }else{
                $('.stayed').hide()
            }
        })
    </script>
@endpush
