@push('scripts')
    <script>
        // GLOBAL VARIABLES
        let select_product = null

        $('a[data-target="#deleteModal"]').on('click', function(e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#deleteModal #submit').attr('data-href', href); // Stocke l'URL de suppression dans le bouton Oui
        });

        $('#deleteModal #submit').click(function () {
            window.location.href = $(this).attr('data-href')
        })

        $(document).on('click', 'a.insert-product', function() {
            // Récupérer le select le plus proche du lien cliqué
            select_product = $(this).closest('.form-group').find('select[name="product_id[]"]');
        });

        //ADD NEW BY MODALS

        function addNewRecord(form, selectName, label){
            var formData = new FormData(form[0])
            formData.append('_token', "{{ csrf_token() }}")
            formData.append('ajax', "1")
            $.ajax({
                type: "POST",
                url: form.attr('action'),
                data: formData,
                processData: false,
                contentType: false,
                dataType: "json",
                success: function(rsp) {
                    if(selectName === 'product'){
                        selectName = select_product
                        selectName.append('<option value="'+rsp.id+'" selected>'+rsp.name+' ('+rsp.selling_price+' F)</option>').refresh()
                    }else if(label === 'care'){
                        selectName.append('<option value="'+rsp.id+'" selected>'+rsp.name+' ('+rsp.amount+' F)</option>').selectpicker('refresh')
                    }else{
                        selectName.append('<option value="'+rsp.id+'" selected>'+rsp.name+'</option>')
                    }
                },
            })
        }

        function addNewRecord(form, selectName, label){
            var formData = new FormData(form[0])
            formData.append('_token', "{{ csrf_token() }}")
            formData.append('ajax', "1")
            $.ajax({
                type: "POST",
                url: form.attr('action'),
                data: formData,
                processData: false,
                contentType: false,
                dataType: "json",
                success: function(rsp) {
                    if(selectName === 'product'){
                        selectName = select_product
                        selectName.append('<option value="'+rsp.id+'" selected>'+rsp.name+' ('+rsp.selling_price+' F)</option>').refresh()
                    }else if(label === 'care'){
                        selectName.append('<option value="'+rsp.id+'" selected>'+rsp.name+' ('+rsp.amount+' F)</option>').selectpicker('refresh')
                    }else{
                        selectName.append('<option value="'+rsp.id+'" selected>'+rsp.name+'</option>')
                        updatePatientEmail(rsp.email)
                    }
                },
            })
        }

        // Fonction pour ouvrir la modal et pré-remplir les données du patient
        // Lorsque l'utilisateur sélectionne un patient dans le select
        $('#patientSelect').on('change', function() {
            var selectedOption = $(this).find('option:selected');

            // Récupérer les données du patient à partir des attributs data-
            var patientId = selectedOption.data('id');
            var customId = selectedOption.data('custom_id');
            var assured = selectedOption.data('assured');
            var name = selectedOption.data('name');
            var lastname = selectedOption.data('lastname');
            var firstname = selectedOption.data('firstname');
            var email = selectedOption.data('email');
            var birth = selectedOption.data('birth');
            var sex = selectedOption.data('sex');
            var tel = selectedOption.data('tel');
            var job = selectedOption.data('job');
            var antecedent = selectedOption.data('antecedent');
            var pathology = selectedOption.data('pathology');
            var weight = selectedOption.data('weight');
            var size = selectedOption.data('size');
            var group_id = selectedOption.data('group_id');
            var address = selectedOption.data('address');
            var assuredSocialPercent = selectedOption.data('assured_social_percent');
            var assuredCompletedPercent = selectedOption.data('assured_completed_percent');

            // Vérifie et convertis la date de naissance au format 'YYYY-MM-DD'
            if (birth) {
                var birthDate = new Date(birth);
                var formattedBirth = birthDate.toISOString().split('T')[0]; // Convertir en 'YYYY-MM-DD'
                $('#editPatientModal input[name="birth"]').val(formattedBirth);
            }

            // Vérifie si l'email existe et l'affiche, sinon message par défaut
            if (email) {
                $('#patient_email').text(email);
            } else {
                $('#patient_email').text('Pas d\'email disponible');
            }

            if (name) {
                $('#patient_name').text(name);
            }

            if(assured){
                $('.assured-bloc').show()
            }else{
                $('.assured-bloc').hide()
            }

            // Remplir les champs dans la modal
            $('#assuredToggleEdit').prop('checked', assured);
            $('#editPatientModal input[name="lastname"]').val(lastname);
            $('#editPatientModal input[name="firstname"]').val(firstname);
            $('#editPatientModal input[name="email"]').val(email);
            $('#editPatientModal select[name="sex"]').val(sex);
            $('#editPatientModal input[name="tel"]').val(tel);
            $('#editPatientModal input[name="job"]').val(job);
            $('#editPatientModal input[name="antecedent"]').val(antecedent);
            $('#editPatientModal input[name="pathology"]').val(pathology);
            $('#editPatientModal input[name="weight"]').val(weight);
            $('#editPatientModal input[name="size"]').val(size);
            $('#editPatientModal select[name="group_id"]').val(group_id);
            $('#editPatientModal textarea[name="address"]').val(address);
            $('#editPatientModal input[name="id"]').val(patientId);
            $('#editPatientModal input[name="custom_id"]').val(customId);
            $('#editPatientModal input[name="assured_social_percent"]').val(assuredSocialPercent);
            $('#editPatientModal input[name="assured_completed_percent"]').val(assuredCompletedPercent);

            // Sauvegarder l'ID du patient pour la mise à jour
            $('#editPatientForm').data('id', patientId);
        });

        // Lorsqu'on clique sur le bouton pour ouvrir la modal
        $('#openEditModal').on('click', function() {
            var patientId = $('#patientSelect').val(); // Récupérer l'ID du patient sélectionné
            if (patientId) {
                // Ouvrir la modal avec les données déjà pré-remplies par le changement du select
                $('#editPatientModal').modal('show');
            } else {
                alert('Veuillez d\'abord sélectionner un patient.');
            }
        });

        // Gestion de la soumission du formulaire de mise à jour (identique au script précédent)
        $('#editPatientForm').on('submit', function(e) {
            e.preventDefault();

            var patientId = $(this).data('id'); // Récupérer l'ID du patient
            var customId = $('input[name="custom_id"]').val(); // Récupérer le CustomID du patient
            var formData = {
                id: $('#editPatientModal input[name="id"]').val(),
                custom_id: $('#editPatientModal input[name="custom_id"]').val(),
                assured: $('#editPatientModal #assuredToggleEdit').is(':checked') ? 1 : 0,
                lastname: $('#editPatientModal input[name="lastname"]').val(),
                firstname: $('#editPatientModal input[name="firstname"]').val(),
                email: $('#editPatientModal input[name="email"]').val(),
                birth: $('#editPatientModal input[name="birth"]').val(),
                sex: $('#editPatientModal select[name="sex"]').val(),
                tel: $('#editPatientModal input[name="tel"]').val(),
                job: $('#editPatientModal input[name="job"]').val(),
                antecedent: $('#editPatientModal input[name="antecedent"]').val(),
                pathology: $('#editPatientModal input[name="pathology"]').val(),
                weight: $('#editPatientModal input[name="weight"]').val(),
                size: $('#editPatientModal input[name="size"]').val(),
                group_id: $('#editPatientModal select[name="group_id"]').val(),
                address: $('#editPatientModal textarea[name="address"]').val(),
                assured_social_percent: $('#editPatientModal input[name="assured_social_percent"]').val(),
                assured_completed_percent: $('#editPatientModal input[name="assured_completed_percent"]').val(),
                _token: "{{ csrf_token() }}",
                ajax: 1
            };
            {{--formData.append('_token', "{{ csrf_token() }}")--}}
            {{--formData.append('ajax', "1")--}}

            $.ajax({
                url: '/admin/patients/' + customId, // URL de mise à jour du patient
                type: 'PUT',
                data: formData,
                success: function(response) {
                    // Fermer la modal et afficher un message de succès
                    $('#editPatientModal').modal('hide');
                    // Mise à jour du sélecteur des patients avec les nouvelles données
                    updatePatientSelect(patientId, formData, response);
                },
                error: function(xhr, status, error) {
                    // Gérer les erreurs
                    alert('Erreur lors de la mise à jour du patient. Veuillez réessayer.');
                }
            });
        });

        // Fonction pour mettre à jour l'option du patient sélectionné après mise à jour
        function updatePatientSelect(patientId, formData, response) {
            var patientOption = $('#patientSelect option[value="' + patientId + '"]');
            patientOption.text(response.name);
            updatePatientData(response)
        }

        // Exemple de mise à jour de l'email lors de la modification ou ajout d'un patient
        function updatePatientData(patient) {
            var selectedOption = $('#patientSelect').find('option:selected');
            selectedOption.data('email', patient.email)
            $('#patient_email').text(patient.email);
            $('#patient_name').text(patient.name);
        }

        // Fonction pour copier l'email
        $('#copyEmailBtn').on('click', function(e) {
            e.preventDefault(); // Empêche le comportement par défaut du lien

            var email = $('#patient_email').text();

            // Crée un élément temporaire pour stocker l'email à copier
            var tempInput = $('<input>');
            $('body').append(tempInput);
            tempInput.val(email).select();
            document.execCommand('copy');
            tempInput.remove(); // Supprime l'élément temporaire

            // Change l'icône de copie en coche
            $('#copyIcon').removeClass('fa-copy').addClass('fa-check');

            // Réinitialise l'icône après 2 secondes
            setTimeout(function() {
                $('#copyIcon').removeClass('fa-check').addClass('fa-copy');
            }, 2000); // 2 secondes d'attente avant de remettre l'icône de copie
        });

        // actualiser le contenu de l'email dès le chargement de la page
        setTimeout(()=>{
            $('#patientSelect').trigger('change')
        }, 1000)

        setTimeout(function(){
            $('#assuredToggle, #assuredToggleEdit').change(function(){
                if(this.checked){
                    $('.assured-bloc').show()
                }else{
                    $('.assured-bloc').hide()
                }
            })
        }, 2000)

        // discount
        $('#btn-discount').on('click', function(e) {
            $('#discountModal #total-invoice').text($(this).data('total'))
            $('#discountModal [name="discount"]').val($(this).data('discount'))
            $('#discountModal [name="id"]').val($(this).data('id'))
        })

        function setDiscount(id, discount){
            $.ajax({
                url: '/admin/setdiscount/' + parseInt(id) + '/' + parseFloat(discount),
                type: 'PUT',
                data: {_token: "{{ csrf_token() }}"},
                success: function(response) {
                    // Fermer la modal et afficher un message de succès
                    $('#discountModal').modal('hide');
                    $('#discount-price-' + id).text(parseFloat(discount))
                },
                error: function(xhr, status, error) {
                    // Gérer les erreurs
                    alert('Erreur. Veuillez réessayer.');
                }
            });
        }

    </script>
@endpush
