@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">@if(auth()->user()->isTraitant()) Mes @endif Hospitalisations ({{ $datas->count() }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('interventions.create') }}">Ajouter</a>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab1" data-toggle="tab">Liste</a></li>

                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active fontawesome-demo" id="tab1">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card  card-box">
                                        <div class="card-head">
                                            <header></header>
                                            <div class="tools">
                                                <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                                                <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                                                <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                                            </div>
                                        </div>
                                        <div class="card-body ">
                                            <div class="pull-right" style="width: 10%">
                                                <label style="vertical-align: middle; font-size: 12px">En cours</label><br>
                                                <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                                       for = "stayToggle">
                                                    <input type = "checkbox" id = "stayToggle"
                                                           class = "mdl-switch__input" checked>
                                                </label>
                                            </div>
                                            <div class="table-scrollable">
                                                <table class="table table-hover full-width custom">
                                                    <thead>
                                                    <tr>
                                                        <th> Durée </th>
                                                        <th> Chambre </th>
                                                        <th> Patient </th>
                                                        <th> Professionnel en charge</th>
{{--                                                        <th> Pathologie </th>--}}
                                                        <th> Diagnostic </th>
                                                        <th> Fichiers </th>
                                                        <th> Type </th>
                                                        <th>Maladie / Gène</th>
                                                        <th>Temperature</th>
                                                        <th>Tension</th>
                                                        <th>Etat Actuel</th>
                                                        <th>Total Facture</th>
{{--                                                        <th>Verdict</th>--}}
                                                        <th style="width: 15%"> Actions </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>

                                                    @foreach($datas as $data)
                                                        @if(!$data->datetimeto)
                                                            <tr class="current">
                                                                <td class="center">{{ $data->datetimefrom->translatedFormat('D d M Y à H:i') }}</td>
                                                                <td class="center">{{ $data->room->name }} {{ $data->room->department?' - '.$data->room->department->name:'' }}</td>
                                                                <td><a href="{{ route('patients.show', $data->patient->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Consulter le suivi">{{ $data->patient->name }}</a></td>
                                                                <td class="center">{{ $data->user->name }}</td>
{{--                                                                <td class="center">{{ $data->patient->pathology }}</td>--}}
                                                                <td class="center"><a href="#"  data-target="#descModal" class="desc-link" data-toggle="modal" data-content="{{ $data->description }}">Voir</a></td>
                                                                <td class="center"><a href="#" data-target="#filesModal" class="files-link" data-toggle="modal" data-content="{{ $data->files }}">Voir</a></td>
                                                                <td class="center">{{ $data->typeintervention->name }}</td>
                                                                <td class="center">{{ $data->trouble->name }}</td>
                                                                <td class="center">{{ $data->temperature }} C</td>
                                                                <td class="center">{{ $data->tension }} mmHg</td>
                                                                <td class="center font-weight-bold text-uppercase">{{ $data->status->name }}</td>
{{--                                                                <td class="center">{{ $data->verdict->name }}</td>--}}
                                                                <td class="center" align="center">
                                                                    @if($data->invoice())
                                                                    <b>{{ number_format($data->invoice()->total, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</b>
                                                                    <br>
                                                                    <a href="#" data-target="#discountModal" data-discount="{{ $data->invoice()->discount }}" data-id="{{ $data->invoice()->id }}" data-total="{{ number_format($data->invoice()->total, 0, '', ' ') }}" id="btn-discount" class="btn btn-outline-primary small btn-sm" data-toggle="modal" data-content="{{ $data->files }}">remise -<span id="discount-price-{{ $data->invoice()->id }}">{{ $data->invoice()->discount }}</span> {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}
                                                                    </a>
                                                                    @endif
                                                                </td>
                                                                <td class="center">
                                                                    @if($data->invoice())
                                                                        <a href="{{ route('invoices.download', [$data->invoice()->custom_id, 'intervention']) }}" class="" >
                                                                            <i class="hgi-stroke hgi-file-download text-dark h3" data-toggle="tooltip" data-placement="top" title="Télécharger la Facture"></i>
                                                                        </a>
                                                                    @endif
                                                                    <a href="{{ route('interventions.edit', $data->custom_id) }}" class="" >
                                                                        <i class="hgi-stroke hgi-edit-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Modifier"></i>
                                                                    </a>
                                                                    <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('interventions.delete', $data->custom_id) }}" class="" >
                                                                        <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" data-toggle="tooltip" data-placement="top" title="Supprimer"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        @else
                                                            <tr class="not-current" style="display: none">
                                                                <td class="center">{{ $data->datetimefrom->translatedFormat('D d M Y à H:i') }} à {{ $data->datetimeto->translatedFormat('D d M Y à H:i') }}</td>
                                                                <td class="center">{{ $data->room->name }} {{ $data->room->department?' - '.$data->room->department->name:'' }}</td>
                                                                <td><a href="{{ route('patients.show', $data->patient->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Consulter le suivi">{{ $data->patient->name }}</a></td>
                                                                <td class="center">{{ $data->user->name }}</td>
{{--                                                                <td class="center">{{ $data->patient->pathology }}</td>--}}
                                                                <td class="center"><a href="#" data-target="#descModal" cla
                                                                                      ss="desc-link" data-toggle="modal" data-content="{{ $data->description }}">Voir</a></td>
                                                                <td class="center"><a href="#" data-target="#filesModal" class="files-link" data-toggle="modal" data-content="{{ $data->files }}">Voir</a></td>
                                                                <td class="center">{{ $data->typeintervention->name }}</td>
                                                                <td class="center">{{ $data->trouble->name }}</td>
                                                                <td class="center">{{ $data->temperature }} C</td>
                                                                <td class="center">{{ $data->tension }} mmHg</td>
                                                                <td class="center font-weight-bold text-uppercase">{{ $data->status->name }}</td>
{{--                                                                <td class="center">{{ $data->verdict->name }}</td>--}}
                                                                @if($data->invoice())
                                                                    <td class="center" align="center">
                                                                        <b>{{ number_format($data->invoice()->total, 0, '', ' ') }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</b>
                                                                        <br>
                                                                        <a href="#" data-target="#discountModal" data-discount="{{ $data->invoice()->discount }}" data-id="{{ $data->invoice()->id }}" data-total="{{ number_format($data->invoice()->total, 0, '', ' ') }}" id="btn-discount" class="btn btn-outline-primary small btn-sm" data-toggle="modal" data-content="{{ $data->files }}">remise -<span id="discount-price-{{ $data->invoice()->id }}">{{ $data->invoice()->discount }}</span> {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}
                                                                        </a>
                                                                    </td>
                                                                @endif
                                                                <td class="center">
                                                                    @if($data->invoice())
                                                                        <a href="{{ route('invoices.download', [$data->invoice()->custom_id, 'intervention']) }}" >
                                                                            <i class="hgi-stroke hgi-file-download text-dark h3" data-toggle="tooltip" data-placement="top" class="" title="Télécharger la Facture"></i>
                                                                        </a>
                                                                    @endif
                                                                    <a href="{{ route('interventions.edit', $data->custom_id) }}" class="" >
                                                                        <i class="hgi-stroke hgi-edit-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Modifier"></i>
                                                                    </a>
                                                                    <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('interventions.delete', $data->custom_id) }}" class="" >
                                                                        <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" data-toggle="tooltip" data-placement="top"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        @endif
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#stayToggle').change(function(){
            if(this.checked) {
                $('.not-current').hide()
                $('.current').show()
            }else{
                $('.current').hide()
                $('.not-current').show()
            }
        })

        $('.desc-link').click(function(){
            $('#descModal .modal-body').html($(this).attr('data-content'))
        })

        $('.files-link').click(function(){
            var content = $(this).attr('data-content').split(';')
            var formatFile = ''
            for (var i in content){
                formatFile += '<a href={{ asset(env('APP_URL').'storage/uploads/interventions/') }}/'+content[i]+' target=_blank>'+content[i]+'</a><br>'
            }
            $('#filesModal .modal-body').html(formatFile)
        })

        // var checking = setInterval(function(){
        //     if (!jQuery.contains(document, $('.table-hover th:first'))) {
        //         triggerClickTh()
        //         if($('.table-hover th:first').hasClass('sorting_desc'))
        //             clearInterval(checking)
        //     }
        // }, 200)
    </script>
@endpush
