@extends('layout.app')

@section('content')
<div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Ajouter une Hospitalisation</div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
{{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
{{--                            data-mdl-for = "panel-button">--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
{{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('interventions.store') }}" id="mainForm" method="POST" id="form_sample_1" class="form-horizontal" enctype="multipart/form-data">
                            @csrf
                            <div class="form-body">
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Patient
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="patient_id">
                                            @foreach($patients as $patient)
                                                <option value="{{ $patient->id }}" @if(isset($patientX) AND $patientX->id == $patient->id) selected @endif>{{ $patient->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#patientModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
{{--                                @if(!auth()->user()->isDoctor())--}}
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Professionnel en charge
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="user_id">
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" @if(auth()->user()->id == $user->id) selected @endif>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
{{--                                @endif--}}
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Chambre
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="room_id">
                                            @foreach($rooms as $room)
                                                <option value="{{ $room->id }}">{{ $room->name }} {{ $room->department?' - '.$room->department->name:'' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#roomModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Type Hospitalisation
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="typeintervention_id">
                                            @foreach($typeinterventions as $typeintervention)
                                                <option value="{{ $typeintervention->id }}" @if($typeintervention->name == 'Hospitalisation médicale générale') selected @endif>{{ $typeintervention->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
{{--                                    <a href="#" data-target="#typeinterventionModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>--}}
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Maladie / Gêne
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="trouble_id">
                                            @foreach($troubles as $trouble)
                                                <option value="{{ $trouble->id }}">{{ $trouble->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#troubleModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Etat actuel
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="status_id">
                                            @foreach($statuses as $status)
                                                <option value="{{ $status->id }}" @if($status->name == 'Stable') selected @endif>{{ $status->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Température (C)
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="temperature" data-required="1" placeholder="39" class="form-control input-height" /> </div>
                                    </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Tension (mmHg)
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="tension" data-required="1" placeholder="12" class="form-control input-height" /> </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Date & Heure Début
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Indiquez la date et l'heure du début de l'hospitalisation"></i>
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <div class="input-group date form_date ">
                                            <input class="form-control input-height" name="datetimefrom" size="16" placeholder="date of Birth" type="datetime-local" value="" required>
                                        </div>
                                    </div>
                                </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Date & Heure Fin
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Si la date et l'heure de fin ne sont pas précisées, cela signifie que l'hospitalisation est toujours en cours"></i>
                                        </label>
                                        <div class="col-md-5">
                                            <div class="input-group date form_date ">
                                                <input class="form-control input-height" name="datetimeto" size="16" placeholder="date of Birth" type="datetime-local" value="">
                                            </div>
                                        </div>
                                    </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Diagnostic de l'hospitalisation
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Vous pouvez y préciser le diagnostic, l'ordonnance, le verdict, des éléments clés, etc"></i>
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <textarea name="description"class="form-control-textarea" id="description" cols="30" rows="10"></textarea>
                                    </div>
                                   @if(auth()->user()->subGold())
                                        <div>
                                            <span class="nav-link btn btn-light btn-sm font-weight-bolder font-size-20 countdown" style="display: none"></span>
                                            <i class="fa fa-microphone btn btn-light btn-sm" id="start-btn"></i>
                                            <i class="fa fa-microphone fa-beat btn btn-light btn-sm text-danger" id="stop-btn" style="display: none"></i>
                                        </div>
                                        @endif
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Fichiers (photos, vidéos, audios, etc)
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Uploader les fichiers de l'état du malade (accidenté, dégats physiques, etc )"></i>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="file" name="files[]" multiple>
                                    </div>
                                </div>

{{--                                <div class="form-group row">--}}
{{--                                    <label class="control-label col-md-3">Verdict--}}
{{--                                        <span class="required"> * </span>--}}
{{--                                    </label>--}}
{{--                                    <div class="col-md-5">--}}
{{--                                        <select class="form-control input-height" name="verdict_id">--}}
{{--                                            @foreach($verdicts as $verdict)--}}
{{--                                                <option value="{{ $verdict->id }}" @if($verdict->name == 'Malade') selected @endif>{{ $verdict->name }}</option>--}}
{{--                                            @endforeach--}}
{{--                                        </select>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Analyses
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" id="analysis_id" name="analysis_id[]" style="width: 78% !important; display: inline-block">
                                            <option value="">Selectionnez</option>
                                            @foreach($analyses as $analysis)
                                                <option value="{{ $analysis->id }}">{{ $analysis->name }} ({{ $analysis->amount }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control input-height" name="result[]" value="" placeholder="25"  style="width: 20%;  display: inline-block">
                                    </div>
                                    <a href="#" data-target="#analysisModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div id="analysis-bloc">
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">
                                    </label>
                                    <div class="col-md-5">
                                        <a href="#" id="btn-analysis" class="btn btn-light btn-sm">Ajouter une analyse</a>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Soins
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Un honoraire est une rémunération ou une compensation financière accordée en échange de services fournis. Ce terme est souvent associé aux professions libérales, notamment dans le domaine médical"></i>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" id="care_id" name="care_id[]" style="width: 78%; display: inline-block">
                                            <option value="">Selectionnez</option>
                                            @foreach($cares as $care)
                                                <option value="{{ $care->id }}">{{ $care->name }}</option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control input-height" name="price[]" value="" placeholder="15000 {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}"  style="width: 20%;  display: inline-block">
                                    </div>
                                    <a href="#" data-target="#careModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div id="care-bloc">
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">
                                    </label>
                                    <div class="col-md-5">
                                        <a href="#" id="btn-care" class="btn btn-light btn-sm">Ajouter un soin</a>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Produits

                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="product_id[]" style="width: 78%; display: inline-block">
                                            <option value="">Selectionnez</option>
                                            @foreach($products as $product)
                                                <option value="{{ $product->id }}">{{ $product->name }} ({{ $product->selling_price }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                    </div>
                                    <a href="#" data-target="#productModal" data-toggle="modal" class="nav-link btn btn-light btn-sm insert-product">+</a>
                                </div>
                                <div id="command-bloc">
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">
                                    </label>
                                    <div class="col-md-5">
                                        <a href="#" id="btn-command" class="btn btn-light btn-sm">Ajouter un produit</a>
                                    </div>
                                </div>

                                <template id="command">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3"></label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="product_id[]" style="width: 78% ; display: inline-block">
                                                <option value="">Selectionnez</option>
                                                @foreach($products as $product)
                                                <option value="{{ $product->id }}">{{ $product->name }} ({{$product->selling_price}} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</option>
                                                @endforeach
                                            </select>
                                            <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                        </div>
                                        <a href="#" class="delete-command nav-link btn btn-light btn-sm" style="padding: 7px 18px !important; font-weight: bold">-</a>
                                        <a href="#" data-target="#productModal" data-toggle="modal" class="nav-link btn btn-light btn-sm ml-3 insert-product">+</a>
                                    </div>
                                </template>

                                <template id="care">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3"></label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" id="care_id" name="care_id[]" style="width: 78%; display: inline-block">
                                                <option value="">Selectionnez</option>
                                                @foreach($cares as $care)
                                                    <option value="{{ $care->id }}">{{ $care->name }}</option>
                                                @endforeach
                                            </select>
                                            <input type="number" class="form-control input-height" name="price[]" value="" placeholder="15000 {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}"  style="width: 20%;  display: inline-block">
                                        </div>
                                        <a href="#" class="delete-care nav-link btn btn-light btn-sm" style="padding: 7px 18px !important; font-weight: bold">-</a>
                                        <a href="#" data-target="#careModal" data-toggle="modal" class="nav-link btn btn-light btn-sm ml-3 insert-care">+</a>
                                    </div>
                                </template>

                                <template id="analysis">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3"></label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" id="analysis_id" name="analysis_id[]" style="width: 78%; display: inline-block">
                                                <option value="">Selectionnez</option>
                                                @foreach($analyses as $analysis)
                                                    <option value="{{ $analysis->id }}">{{ $analysis->name }}</option>
                                                @endforeach
                                            </select>
                                            <input type="number" class="form-control input-height" name="result[]" value="" placeholder="25"  style="width: 20%;  display: inline-block">
                                        </div>
                                        <a href="#" class="delete-analysis nav-link btn btn-light btn-sm" style="padding: 7px 18px !important; font-weight: bold">-</a>
                                        <a href="#" data-target="#analysisModal" data-toggle="modal" class="nav-link btn btn-light btn-sm ml-3 insert-analysis">+</a>
                                    </div>
                                </template>

                                <input type="hidden" name="enableInvoice" value="0">

                                <div class="form-actions">
                                    <div class="row">
                                        <div class="offset-md-3 col-md-9">
                                            <button type="submit" data-toggle="modal" data-target="#confirmCreateModal" id="save" onclick="return false;" class="btn btn-primary">Enregistrer</button>
                                            <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('#btn-care').click(function(e){
            e.preventDefault()
            $('#care-bloc').append($('#care').html())
        })

        $('#btn-analysis').click(function(e){
            e.preventDefault()
            $('#analysis-bloc').append($('#analysis').html())
        })

        $('.form-body').on('click', '.delete-command', function(e){
            e.preventDefault()
            $(this).parent().remove()
        })

        $('#confirmCreateModal #no').click(function(){
            $('#mainForm').submit()
        })

        $('#confirmCreateModal #yes').click(function(){
            $('[name="enableInvoice"]').val(1)
            $('#mainForm').submit()
        })

        $('.filter-option-inner-inner').html('Selectionnez')
    </script>
@endpush
