<?php

if (!function_exists('convertNumberToWords')) {
    function convertNumberToWords($number)
    {
        $units = [
            0 => '',
            1 => 'un',
            2 => 'deux',
            3 => 'trois',
            4 => 'quatre',
            5 => 'cinq',
            6 => 'six',
            7 => 'sept',
            8 => 'huit',
            9 => 'neuf',
            10 => 'dix',
            11 => 'onze',
            12 => 'douze',
            13 => 'treize',
            14 => 'quatorze',
            15 => 'quinze',
            16 => 'seize',
            17 => 'dix-sept',
            18 => 'dix-huit',
            19 => 'dix-neuf'
        ];

        $tens = [
            0 => '',
            1 => 'dix',
            2 => 'vingt',
            3 => 'trente',
            4 => 'quarante',
            5 => 'cinquante',
            6 => 'soixante',
            7 => 'soixante-dix',
            8 => 'quatre-vingt',
            9 => 'quatre-vingt-dix'
        ];

        if ($number < 20) {
            return $units[$number];
        } elseif ($number < 100) {
            if ($number % 10 == 0) {
                return $tens[$number / 10];
            } elseif ($number < 70) {
                return $tens[$number / 10] . '-' . $units[$number % 10];
            } elseif ($number < 80) {
                return 'soixante-' . $units[$number % 20];
            } else {
                return 'quatre-vingt-' . $units[$number % 20];
            }
        } elseif ($number < 1000) {
            if ($number == 100) {
                return 'cent';
            } elseif ($number % 100 == 0) {
                return $units[$number / 100] . ' cent';
            } else {
                return $units[$number / 100] . ' cent ' . convertNumberToWords($number % 100);
            }
        } elseif ($number < 1000000) {
            if ($number == 1000) {
                return 'mille';
            } elseif ($number < 2000) {
                return 'mille ' . convertNumberToWords($number % 1000);
            } else {
                return convertNumberToWords($number / 1000) . ' mille ' . convertNumberToWords($number % 1000);
            }
        } elseif ($number < 1000000000) {
            if ($number == 1000000) {
                return 'un million';
            } else {
                return convertNumberToWords($number / 1000000) . ' million ' . convertNumberToWords($number % 1000000);
            }
        }
    }
}

if (!function_exists('convertCurrencyToWords')) {
    function convertCurrencyToWords($number)
    {
        // Diviser le nombre total en parties entières et décimales
        $wholeNumber = floor($number);
        $decimalPart = round(($number - $wholeNumber) * 100);

        // Conversion de la partie entière en lettres
        $words = convertNumberToWords($wholeNumber);

        // Accord correct pour FCFA
//    if ($wholeNumber > 1) {
//        $currency = 'FCFA';
//    } else {
//        $currency = 'FCFA';
//    }

        // Générer la phrase complète
//    return ucfirst($words) . " " . $currency;
        return ucfirst($words);
    }
}

