@extends('layout.app')

@section('content')
@php use App\Models\Dashboard; @endphp
<style>
  .info-box-text{
      font-size: 12px !important;
  }
  .card-dashboard{
      border-radius: 3rem;
      /*border: 1px solid black;*/
      color: #000;
      background: rgb(239,242,255) radial-gradient(circle, rgba(239,242,255,1) 0%, rgba(255,255,255,1) 50%, rgba(238,241,255,1) 100%); !important;
  }
  .card-dashboard .row{
      height: 130px;
  }
  .card-dashboard i{
      font-size: 3.5rem
  }
  .card-dashboard .col{
      width: auto
  }
</style>
<div class="page-content">
    <div class="page-bar">
        <div class="page-title-breadcrumb">
            <div class=" pull-left">
                <div class="page-title">Tableau de Bord du <b>{{ $dateStart }}</b> au <b>{{ $dateEnd }}</b></div>
                <form action="{{ route('index') }}" method="POST">
                    @csrf
                    <div class="form-group" style="display: inline-block">
                        <label for="" class="small">Date Début</label>
                        <input type="date" name="datestart" class="form-control">
                    </div>
                    <div class="form-group" style="display: inline-block">
                        <label for="" class="small">Date Fin</label>
                        <input type="date" name="dateend" class="form-control">
                    </div>
                    <div class="form-group" style="display: inline-block">
                        <label for=""></label>
                        <button type="submit" class="btn btn-primary small">Appliquer</button>
                    </div>
                </form>
                <br>
            </div>
        </div>
    </div>
    <!-- start widget -->
    <div class="state-overview">
        @if(auth()->user()->isAdmin())
            <div class="row ">
                <div class="col-xl-3 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">accessible</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Nouveaux Patients</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 3rem">{{ $patients }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">assignment</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Consultations</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 3rem">{{ $consultations }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">vaccines</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Hospitalisations</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 3rem">{{ $interventions }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">account_balance</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Recette</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 1.2rem">{{ $recipe }} {{ $currency_symbol }}</span>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        @else
            <div class="row">
                <div class="col-xl-4 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">accessible</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Nouveaux Patients</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 3rem">{{ $patients }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">assignment</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Consultations</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 3rem">{{ $consultations }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-12 ">
                    <div class="container text-black card-dashboard">
                        <div class="row justify-content-center">
                            <div class="col align-self-center">
                                <div class="align-self-start">
                                    <i class="material-icons">vaccines</i>
                                </div>
                                <div class="align-self-end">
                                    <span class="small">Hospitalisations</span>
                                </div>
                            </div>
                            <div class="col align-self-center text-right">
                                <span class="bold" style="font-size: 3rem">{{ $interventions }}</span>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        @endif
    </div>
    <!-- end widget -->
    <br><br>
    <div class="row">
        <div class="col-md-12">
            <div class="card card-box">
                <div class="card-head">
                    <header>Hospital Survey</header>

                    <div class="tools">
                        <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                        <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                        <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                    </div>
                </div>
                <div class="card-body no-padding height-9">
                    <div class="page-title">Statistique Générale</div>
                    @if(auth()->user()->isAdmin())
                    <div class="row text-center">

                        <div class="col-sm-3 col-6">
                            @php
                                $dashboard = new \App\Models\Dashboard([
                                                    'dateStart' => date('Y-m-d 00:00'),
                                                    'dateEnd' => date('Y-m-d H:i'),
                                                ]);
                            @endphp
                            <p class="text-muted"> Recette du Jour</p>
                            <h4 class="margin-0 bold">{{ $dashboard->recipe() }} {{ $currency_symbol }}</h4>
                        </div>

                        <div class="col-sm-3 col-6">
                            @php
                                $dashboard = new \App\Models\Dashboard([
                                                    'dateStart' => date("Y-m-d", strtotime('monday this week')),
                                                    'dateEnd' => date('Y-m-d H:i'),
                                                ]);
                            @endphp
                            <p class="text-muted"> Recette de la Semaine</p>
                            <h4 class="margin-0 bold">{{ $dashboard->recipe() }} {{ $currency_symbol }}</h4>
                        </div>
                        <div class="col-sm-3 col-6">
                            @php
                                $dashboard = new \App\Models\Dashboard([
                                                    'dateStart' => date('Y-m-01 00:00'),
                                                    'dateEnd' => date('Y-m-d H:i'),
                                                ]);
                            @endphp
                            <p class="text-muted"> Recette du Mois</p>
                            <h4 class="margin-0 bold">{{ $dashboard->recipe() }} {{ $currency_symbol }}</h4>
                        </div>
                        <div class="col-sm-3 col-6">
                            @php
                                $dashboard = new \App\Models\Dashboard([
                                                    'dateStart' => date('Y-01-01 00:00'),
                                                    'dateEnd' => date('Y-m-d H:i'),
                                                ]);
                            @endphp
                            <p class="text-muted"> Recette de l'Année</p>
                            <h4 class="margin-0 bold">{{ $dashboard->recipe() }} {{ $currency_symbol }}</h4>
                        </div>
                    </div>
                    @endif
                    <br>
                    <div class="row">
                        <div id="my_chart" class="full-width morris-default-style"></div>
                    </div>
{{--                    {{ \App\Models\Dashboard::monthsPassed() }}--}}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <script>
        var months = []
        @foreach(\App\Models\Dashboard::monthsPassed() as $key => $month)
            months.push("{{$month}}")
        @endforeach
            // console.log(months)
        // var months = ["Jan", "Fév", "Mars", "Avril", "Mai", "Juin", "Jui", "Août", "Sep", "Oct", "Nov", "Dec"];
        jQuery(document).ready(function() {
            Morris.Area({
                element: 'my_chart',
                data: [
                    @foreach(\App\Models\Dashboard::monthsPassed() as $key => $month)
                        {
                        period: new Date().getFullYear() + "-{{ $key }}",
                        cured: "{{ $dashboard->charts('Guéri / Rémission', $key) }}",
                        transfered: "{{ $dashboard->charts('Transféré', $key) }}",
                        coma: "{{ $dashboard->charts('Coma', $key) }}",
                        dead: "{{ $dashboard->charts('Décédé', $key) }}",
                        },
                    @endforeach
                ],
                xkey: 'period',
                ykeys: ['cured', 'transfered', 'coma', 'dead'],
                labels: ['Guéris', 'Transférés', 'Coma', 'Décédés'],
                xLabelFormat: function(x) { // <--- x.getMonth() returns valid index
                    return months[x.getMonth()];
                },
                pointSize: 3,
                fillOpacity: 0.5,
                pointStrokeColors: ['green', 'red', '#999', '#000'],
                behaveLikeLine: true,
                gridLineColor: '#e0e0e0',
                lineWidth: 0,
                hideHover: 'auto',
                lineColors: ['green', 'red', '#999', '#000'],
                resize: true
            });

        });
    </script>
@endpush
