@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">@if(auth()->user()->isTraitant()) Mes @endif Consultations ({{ $datas->count() }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('consultations.create') }}">Ajouter</a>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab1" data-toggle="tab">Liste</a></li>

                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active fontawesome-demo" id="tab1">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card  card-box">
                                        <div class="card-head">
                                            <header></header>
                                            <div class="tools">
                                                <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                                                <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                                                <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                                            </div>
                                        </div>
                                        <div class="card-body ">
                                            <div class="table-scrollable">
                                                <table class="table table-hover full-width custom">
                                                    <thead>
                                                    <tr>
                                                        <th> Date </th>
                                                        <th> Professionnel en charge</th>
                                                        <th style="width: 20%"> Patient </th>
                                                        <th>Temperature</th>
                                                        <th>Tension</th>
                                                        <th> Diagnostic </th>
                                                        <th> Ordonnance </th>
                                                        <th> Actions </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>

                                                    @foreach($datas as $data)
                                                        <tr class="current">
                                                            <td class="center">{{ $data->datetime->translatedFormat('D d M Y à H:i') }}</td>
                                                            <td class="center">{{ $data->user->name }}</td>
                                                            <td><a href="{{ route('patients.show', $data->patient->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Consulter le suivi">{{ $data->patient->name }}</a></td>
                                                            <td class="center">{{ $data->temperature }} C</td>
                                                            <td class="center">{{ $data->tension }} mmHg</td>
                                                            <td class="center"><a href="#"  data-target="#descModal" class="desc-link" data-toggle="modal" data-content="{{ $data->description }}">Voir</a></td>
                                                            <td class="center"><a href="#"  data-target="#prescModal" class="presc-link" data-toggle="modal" data-content="{{ $data->prescription }}" data-download-link="{{ route('invoices.download', [$data->invoice()->custom_id, 'prescription']) }}">Voir</a></td>
                                                            <td class="center">
                                                                @if($data->invoice())
                                                                    <a href="{{ route('invoices.download', [$data->invoice()->custom_id, 'consultation']) }}" class="" >
                                                                        <i class="hgi-stroke hgi-file-download text-dark h3" data-toggle="tooltip" data-placement="top" title="Télécharger la Facture"></i>
                                                                    </a>
                                                                @endif
                                                                <a href="{{ route('consultations.edit', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-edit-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Modifier"></i>
                                                                </a>
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('consultations.delete', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" data-toggle="tooltip" data-placement="top" title="Supprimer"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

        $('.desc-link').click(function(){
            $('#descModal .modal-body').html($(this).attr('data-content'))
        })

        $('.presc-link').click(function(){
            $('#prescModal .modal-body').html($(this).attr('data-content'))
            $('#prescModal #download-prescription').attr('href', $(this).data('download-link'))
        })

        // function triggerClickTh(){
        //     $('.table-hover th:first').trigger('click')
        // }

        // var checking = setInterval(function(){
        //     if (!jQuery.contains(document, $('.table-hover th:first'))) {
        //         triggerClickTh()
        //         if($('.table-hover th:first').hasClass('sorting_desc'))
        //             clearInterval(checking)
        //     }
        // }, 200)


    </script>
@endpush
