@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Ajouter une Consultation</div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
                        {{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
                        {{--                            data-mdl-for = "panel-button">--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('consultations.store') }}" id="mainForm" method="POST" id="form_sample_1" class="form-horizontal" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body">
                                    {{--                                @if(!auth()->user()->isDoctor())--}}
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Professionnel en charge
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="user_id">
                                                @foreach($users as $user)
                                                    <option value="{{ $user->id }}" @if(auth()->user()->id == $user->id) selected @endif>{{ $user->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    {{--                                @endif--}}
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Patient
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="patient_id">
                                                @foreach($patients as $patient)
                                                    <option value="{{ $patient->id }}" @if(isset($patientX) AND $patientX->id == $patient->id) selected @endif
                                                            data-patient="{{ $patient }}"
                                                            data-age="{{ $patient->age() }}"
                                                            data-group_name="{{ $patient->group->name }}"
                                                    >{{ $patient->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <a href="#" data-target="#patientModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                    </div>



                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Température (C)

                                        </label>
                                        <div class="col-md-5">
                                            <input type="text" name="temperature" data-required="1" placeholder="39" class="form-control input-height" /> </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Tension (mmHg)
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input type="text" name="tension" data-required="1" placeholder="12" class="form-control input-height" /> </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Date & Heure
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <div class="input-group date form_date ">
                                                <input class="form-control input-height" name="datetime" size="16" placeholder="date of Birth" type="datetime-local" value="" required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Montant Principal ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})

                                        </label>
                                        <div class="col-md-5">
                                            <input type="text" name="amount" data-required="1" placeholder="3500" class="form-control input-height" /> </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Diagnostic
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Vous pouvez y préciser le diagnostic, le verdict, des éléments clés, etc"></i>
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <textarea name="description" class="form-control-textarea" id="description" cols="30" rows="10"></textarea>
                                        </div>
                                        @if(auth()->user()->subGold())
                                        <div>
                                            <span class="nav-link btn btn-light btn-sm font-weight-bolder font-size-20 countdown" style="display: none"></span>
                                            <i class="fa fa-microphone btn btn-light btn-sm" id="start-btn"></i>
                                            <i class="fa fa-microphone fa-beat btn btn-light btn-sm text-danger" id="stop-btn" style="display: none"></i>
                                        </div>
                                        @endif
                                   </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Ordonnance
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Décrivez en détails l'ordonnance du patient"></i>
                                        </label>
                                        <div class="col-md-5">
                                            <textarea name="prescription" class="form-control-textarea" id="prescription" cols="30" rows="10"></textarea>
                                        </div>
                                        <br><br>
                                        <div>
                                            <a href="javascript:void(0)" class="btn ai btn-light" id="generate-prescription">
                                                <i class="fa fa-user-nurse" style="font-size: 18px"></i>
                                                @if(auth()->user()->subStandard() AND !auth()->user()->subGold())(<span id="ai-credits">{{auth()->user()->company->ai_credits}}</span> crédits restants)@endif
{{--                                                @if(auth()->user()->subStandard())(<span id="ai-credits">{{auth()->user()->company->ai_credits}}</span> crédits restants)@endif--}}
                                            </a>
                                            <a href="javascript:void(0)" class="btn btn-light ai disabled" style="display: none; " id="generate-prescription-loading" disabled>
                                                <i class="fa-solid fa-circle-notch fa-spin"></i>
                                                Réflexion de Docteur IA
                                            </a>
                                            <br><br>
                                            <p class="text-danger pt-10 mt-20 small" id="generate-error">

                                            </p>
                                        </div>

                                        {{--                                    <span class="text-primary font-weight-bolder font-size-20 countdown"></span>--}}
                                        {{--                                    <a href="javascript:void(0)" id="start-btn"><i class="fa fa-microphone text-warning"></i></a>--}}
                                        {{--                                    <a href="javascript:void(0)" id="stop-btn" class="display-none"><i class="fa fa-microphone text-danger fa-beat"></i></a>--}}
                                    </div>

                                    {{--                                <div class="form-group row">--}}
                                    {{--                                    <label class="control-label col-md-3">Produits--}}

                                    {{--                                    </label>--}}
                                    {{--                                    <div class="col-md-5">--}}
                                    {{--                                        <select class="form-control input-height" name="product_id[]" style="width: 78%; display: inline-block">--}}
                                    {{--                                            <option value="">Selectionnez</option>--}}
                                    {{--                                            @foreach($products as $product)--}}
                                    {{--                                                <option value="{{ $product->id }}">{{ $product->name }}</option>--}}
                                    {{--                                            @endforeach--}}
                                    {{--                                        </select>--}}
                                    {{--                                        <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">--}}
                                    {{--                                    </div>--}}
                                    {{--                                    <a href="#" id="btn-command" class="nav-link btn btn-light btn-sm">+</a>--}}
                                    {{--                                </div>--}}
                                    <div id="command-bloc">

                                    </div>
                                    <template id="command">
                                        <div class="form-group row">
                                            <label class="control-label col-md-3"></label>
                                            <div class="col-md-5">
                                                <select class="form-control input-height" name="product_id[]" style="width: 78% ; display: inline-block">
                                                    <option value="">Selectionnez</option>
                                                    @foreach($products as $product)
                                                        <option value="{{ $product->id }}">{{ $product->name }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                            </div>
                                            <a href="#" class="delete-command nav-link btn btn-primary btn-sm" style="padding: 7px 18px !important; font-size: 20px;">-</a>
                                        </div>
                                    </template>

                                    <div class="form-actions">
                                        <div class="row">
                                            <div class="offset-md-3 col-md-9">
                                                <button type="submit" id="save" class="btn btn-primary">Enregistrer</button>
                                                <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                   </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

        let patientSelected = null
        let patientSelectedAge = null
        let patientSelectedGroupName = null
        let subStandardOnly = {!! json_encode(auth()->user()->subStandard() && !auth()->user()->subGold()) !!}

        setTimeout(function(){
            triggerPatientSelect()
        }, 3000)

        if(subStandardOnly)
            checkAiCredits()

        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('.form-body').on('click', '.delete-command', function(e){
            e.preventDefault()
            $(this).parent().remove()
        })

        $('#confirmCreateModal #submit').click(function(){
            $('#mainForm').submit()
        })


        $('#generate-prescription').click(async function() {
            const description = tinymce.get('description').getContent()
            const prescription = tinymce.get('prescription')
            const pplxId = await getPPLXID();


            if(!description)
                return alert('Veuillez renseigner d\'abord le diagnostic du patient')
                // return $('#generate-error').text('Veuillez renseigner d\'abord le diagnostic du patient')
            else
                $('#generate-error').text('')

            $('#generate-prescription').hide()
            $('#generate-prescription-loading').show()

            $.ajax({
                url: 'https://api.perplexity.ai/chat/completions', // URL de l'API
                type: 'POST',
                contentType: 'application/json',
                headers: {
                    'Authorization': 'Bearer ' + pplxId, // Remplacez par votre clé API
                    'Accept': 'application/json'
                },
                data: JSON.stringify({
                    model: 'llama-3.1-sonar-small-128k-online', // Modèle à utiliser
                    messages: [
                        { role: 'user', content: formatDescription('Diagnostic: ' + description) }
                    ]
                }),
                success: function(response) {
                    // Traitez la réponse ici
                    prescription.setContent(marked.parse(response.choices[0].message.content))
                    $('#generate-prescription-loading').hide()
                    $('#generate-prescription').show()
                    if(subStandardOnly){
                        updateAiCredits()
                        checkAiCredits()
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Erreur:', error);
                    $('#response').text('Une erreur est survenue.');
                    $('#generate-prescription-loading').hide()
                    $('#generate-prescription').show()
                }
            });
        })

        function formatDescription(message){
            const basicPrompt = 'Ordonnance médicale rédigée comme par un médecin pour un diagnostic que je vais décrire en dessous.\n' +
                'Je veux liste de médicaments (avec leur posologie respectifs) et de conseils.\n' +
                'Ne pas mentionner une consultation médicale (ne pas mentionner "il est important de consulter un médecin etc acr le but est d avoir une ordonnance rédigée comme un médecin").\n' +
                'La réponse ne contiendra que les medicaments prescrits et les conseils comme titre pas de d\'intro ni de conlusion ni de résumé en fin. ' +
                'La réponse ne dépassera pas 1000 caractères (très important) et réduis l\'espacement entre les interlignes et paragraphes. ' +
                'Substituer la réponse en 3 grands paragraphes: Diagnostic, Médicaments & Posologies et Conseils. Mettre "-" quand une info est absente  '

            const PatientInfos = 'Prendre compte des Infos du patient ci-dessous: '
                + 'nom & prénoms: '+patientSelected.name+'+'
                + 'age: '+patientSelectedAge+'+'
                + 'genre: '+patientSelected.sex+'+'
                + 'groupe sanguin: '+patientSelectedGroupName+' +'
                + 'poids: '+patientSelected.weight+'+'
                + 'taille: '+patientSelected.size+'+cm+'
                + 'pathologie: '+patientSelected.pathology+'+'
                + 'antécédent: '+patientSelected.antecedent+'+'
                + 'profession: '+patientSelected.job+'+'
                + 'température: '+$('[name="temperature"]').val()+'+'

            return basicPrompt + PatientInfos + message
        }

        function updateAiCredits(){
            $.post('{{route('companies.updateAiCredits')}}', {_token : "{{ csrf_token() }}"}, function(rsp){
                $('#ai-credits').text(rsp)
            })
        }

        function checkAiCredits(){
            if(subStandardOnly)
                setTimeout(()=>{
                    if($('#ai-credits').text() <= 0){
                        $('#doctor-ai').addClass('disabled')
                    }
                }, 1000)
        }

        function triggerPatientSelect(){
            // Récupère l'option sélectionnée
            let selectedOption = $('[name="patient_id"]').find('option:selected')
            patientSelected = selectedOption.data('patient')
            patientSelectedAge = selectedOption.data('age')
            patientSelectedGroupName = selectedOption.data('group_name')
        }

        $('[name="patient_id"]').change(function(){
            triggerPatientSelect()
        })


        async function getPPLXID() {
            try {
                const response = await fetch('/admin/pplx-id');

                if (!response.ok) {
                    console.error('Erreur dans la réponse:', response.status);
                    return null;
                }

                const data = await response.json();

                if (data.pplx_id) {
                    return data.pplx_id;
                } else {
                    console.error('PPLX ID introuvable.');
                    return null;
                }

            } catch (error) {
                console.error('Erreur lors de la requête:', error);
                return null;
            }
        }





    </script>
@endpush
