@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Modifier @if(auth()->user()->custom_id != $data->custom_id) un Membre @else votre profil @endif</div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
{{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
{{--                            data-mdl-for = "panel-button">--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
{{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('users.update', $data->custom_id) }}" method="POST" id="form_sample_1" class="form-horizontal" enctype="multipart/form-data">
                            @csrf
                            {{ method_field('put') }}
                            <div class="form-body">
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Photo

                                    </label>
                                    <div class="col-md-5">
                                        <label for="photo-file-input"  id="photo-label" data-toggle="tooltip" data-title="Cliquez pour modifier">
                                            @if($data->photo)
                                                <img id="photo-uploaded-image" class="uploaded-image" src="{{ asset(env('APP_URL').'storage/uploads/users/'.$data->photo) }}" alt="Photo">
                                            @else
                                                <img id="photo-uploaded-image" class="uploaded-image" src="#" alt="Photo">
                                            @endif
                                        </label>
                                        <input type="file" name="photo" data-required="1" class="form-control input-height" id="photo-file-input" accept="image/*">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Nom
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input value="{{ $data->lastname() }}" type="text" name="lastname" data-required="1" placeholder="Abalo" class="form-control input-height" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Prénoms
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input value="{{ $data->firstname() }}" type="text" name="firstname" data-required="1" placeholder="Abalo" class="form-control input-height" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Email
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input value="{{ $data->email }}" type="email" name="email" data-required="1" placeholder="user@gmail.com" class="form-control input-height" />
                                        @if(auth()->user()->custom_id != $data->custom_id)
                                            <span class="small text-info"><b>Important</b> : L'utilisateur se connectera avec cet email et son prenom exact (tout en petits caractères) comme mot de passe. <br>Ex: Pour un prénom <b>Kylian</b>, le mot de passe = <b>kylian</b>. <br> Il pourra changer son mot de passe une fois connecté en éditant son profil.</span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Genre
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="sex">
                                            <option @if($data->sex == 'Homme') selected @endif>Homme</option>
                                            <option @if($data->sex == 'Femme') selected @endif>Femme</option>
                                            <option @if($data->sex == 'Autre') selected @endif>Autre</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Téléphone
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input value="{{ $data->tel }}" type="text" name="tel" data-required="1" placeholder="94949494" class="form-control input-height" />
                                    </div>
                                </div>
                                @if(auth()->user()->custom_id == $data->custom_id)
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Mot de passe actuel

                                    </label>
                                    <div class="col-md-5">
                                        <input  type="password" name="old_password" data-required="1" placeholder="******" class="form-control input-height" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Nouveau Mot de passe

                                    </label>
                                    <div class="col-md-5">
                                        <input  type="password" name="password" data-required="1" placeholder="******" class="form-control input-height" />
                                    </div>
                                </div>
                                @endif

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Spécialité

                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="specialty_id">
                                            <option value="">Selectionner</option>
                                            @foreach($specialties as $specialty)
                                                <option value="{{ $specialty->id }}" @if($data->specialty_id == $specialty->id) selected @endif>{{ $specialty->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#specialtyModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>

                                @if(auth()->user()->isAdmin())

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Fonction
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="role">
                                            <option @if($data->role == 'Médecin') selected @endif>Médecin</option>
                                            <option @if($data->role == 'Infirmier') selected @endif>Infirmier</option>
                                            <option @if($data->role == 'Sage-Femme') selected @endif>Sage-Femme</option>
                                            <option @if($data->role == 'Sécretaire') selected @endif>Sécretaire</option>
                                            <option @if($data->role == 'Pharmacien') selected @endif>Pharmacien</option>
                                            <option @if($data->role == 'Autre') selected @endif>Autre</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Profil
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Le profil admin donne accès à tous les droits de l'application. Le profil traitant est plus conseillé pour les médécins / infirmiers. Le profil secrétaire est destiné aux executants de bureautique "></i>

                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="profil" @if($data->profil == 'super admin') disabled @endif>
                                            @if($data->profil == 'super admin')<option  selected>super admin</option>@endif
                                            <option @if($data->profil == 'admin') selected @endif>admin</option>
                                            <option @if($data->profil == 'traitant') selected @endif>traitant</option>
                                            <option @if($data->profil == 'secretaire') selected @endif>secretaire</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Poste
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input value="{{ $data->position }}" type="text" name="position" data-required="1" placeholder="Adjoint" class="form-control input-height" />
                                    </div>
                                </div>

                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Docteur

                                        </label>
                                        <div class="col-md-5">
                                            <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                                   for = "doctorToggle">
                                                <input type = "checkbox" id="doctorToggle"
                                                       class = "mdl-switch__input" name="is_doctor" @if($data->is_doctor) checked @endif>
                                            </label>
                                        </div>
                                    </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Actif
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Si cette option est désactivée, l'utilisateur ne pourra pas s'authentifier. En d'autres termes, il est bloqué d'accès à l'application"></i>
                                    </label>
                                    <div class="col-md-5">
                                        <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                               for = "stayToggle">
                                            <input type = "checkbox" id="stayToggle"
                                                   class = "mdl-switch__input" name="active" @if($data->active) checked @endif @if($data->profil == 'super admin') disabled @endif>
                                        </label>
                                    </div>
                                </div>

                                @endif

                                <div class="form-actions">
                                    <div class="row">
                                        <div class="offset-md-3 col-md-9">
                                            <button type="submit" id="save" class="btn btn-primary">Enregistrer</button>
                                            <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('[name="old_password"]').keyup(function(){
            var self = $(this)
            var password = self.val()
            $.post("{{ route('users.checkPassword', $data) }}", { _token : "{{ csrf_token() }}", password : password }, function(rsp){
                if(rsp == true){
                    self.css({"border": "1px solid green"})
                    $('#save').removeAttr('disabled')
                }else{
                    self.css({"border": "1px solid red"})
                    $('#save').attr('disabled', 'disabled')
                }
            })
        })
    </script>
@endpush
