@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Ajouter un Membre</div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
                        {{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
                        {{--                            data-mdl-for = "panel-button">--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('users.store') }}" id="mainForm" method="POST" id="form_sample_1" class="form-horizontal" enctype="multipart/form-data">
                            @csrf
                            <div class="form-body">
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Photo

                                    </label>
                                    <div class="col-md-5">
                                        <label for="photo-file-input" id="photo-label"  data-toggle="tooltip" data-title="Cliquez pour modifier">
                                            <img id="photo-uploaded-image" class="uploaded-image" src="#" alt="Photo">
                                        </label>
                                        <input type="file" name="photo" data-required="1" class="form-control input-height" id="photo-file-input" accept="image/*">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Nom
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="lastname" data-required="1" placeholder="Abalo" class="form-control input-height" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Prénoms
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="firstname" data-required="1" placeholder="Abalo" class="form-control input-height" />
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Email
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="email" name="email" data-required="1" placeholder="user@gmail.com" class="form-control input-height" />
                                        <span class="small text-info"><b>Important</b> : L'utilisateur se connectera avec cet email et son prenom exact (tout en petits caractères) comme mot de passe. <br>Ex: Pour un prénom <b>Kylian</b>, le mot de passe = <b>kylian</b>. <br> Il pourra changer son mot de passe une fois connecté en éditant son profil.</span>

                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Genre
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="sex">
                                            <option selected>Homme</option>
                                            <option>Femme</option>
                                            <option>Autre</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Téléphone
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="tel" data-required="1" placeholder="94949494" class="form-control input-height" />
                                    </div>
                                </div>



                                <div class="form-group row">
                                    <label class="control-label col-md-3">Spécialité


                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="specialty_id">
                                            <option value="">Selectionner</option>
                                            @foreach($specialties as $specialty)
                                                <option value="{{ $specialty->id }}">{{ $specialty->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#specialtyModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Fonction
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="role">
                                            <option>Médecin</option>
                                            <option>Infirmier</option>
                                            <option>Sage-Femme</option>
                                            <option>Sécretaire</option>
                                            <option>Pharmacien</option>
                                            <option>Autre</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Profil
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Le profil admin donne accès à tous les droits de l'application. Le profil traitant est plus conseillé pour les médécins / infirmiers. Le profil secrétaire est destiné aux executants de bureautique "></i>
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="profil">
                                            <option>admin</option>
                                            <option>traitant</option>
                                            <option>secretaire</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Poste
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="position" data-required="1" placeholder="Adjoint" class="form-control input-height" />
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Docteur

                                    </label>
                                    <div class="col-md-5">
                                        <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                               for = "doctorToggle">
                                            <input type = "checkbox" id="doctorToggle"
                                                   class = "mdl-switch__input" name="is_doctor">
                                        </label>
                                    </div>
                                </div>


                                <div class="form-group row">
                                    <label class="control-label col-md-3">Actif
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Si cette option est désactivée, l'utilisateur ne pourra pas s'authentifier. En d'autres termes, il est bloqué d'accès à l'application"></i>
                                    </label>
                                    <div class="col-md-5">
                                        <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                               for = "stayToggle">
                                            <input type = "checkbox" id="stayToggle"
                                                   class = "mdl-switch__input" name="active" checked>
                                        </label>
                                    </div>
                                </div>


                                <div class="form-actions">
                                    <div class="row">
                                        <div class="offset-md-3 col-md-9">
                                            <button type="submit" id="save" class="btn btn-primary">Enregistrer</button>
                                            <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('#confirmCreateModal #submit').click(function(){
            $('#mainForm').submit()
        })
    </script>
@endpush
