<script async>
    // SUPPORT
    var formatPrice = function(price){
        price = parseFloat(price);
        // Séparer la partie entière et la partie décimale
        var parts = price.toFixed(2).split('.');

        // Formater la partie entière avec des espaces
        var wholePart = parseInt(parts[0]).toLocaleString('fr-FR');

        // Partie décimale
        var decimalPart = ',' + parts[1];

        return [wholePart, decimalPart]
        // Afficher les parties séparées
    }


    var getPaypalPlanID = async function(subscription_id, subscription_annual, subscription_type) {
        let response = null
        let data = {
            subscription_id: subscription_id,
            subscription_annual: subscription_annual,
            subscription_type: subscription_type,
        }
        await $.post('/get_pp_id', {data: data, _token : "{{ csrf_token() }}"}, function(rsp){
            response = rsp
        })
        return response
    }


    // START PRICING MODAL

    var lastSubscriptionInvoice = null;
    var paymentInfosSup = '';

    $('#btn-open-payment-modal, #test-modal').click(function(){
        $('#offer-name').text($('[name="subscription_name"]').val().toUpperCase())
        $('#subscription-price').text($('[name="subscription_value"]').val())
        $('#subscription-price-show, #annual-monthly-price-show').text(formatPrice($('[name="subscription_value"]').val())[0])
        $('#monthly-price-show').text(getMonthlyPrice(formatPrice($('[name="subscription_value"]').val())[0]))
        $('#economy-price').text(economyPrice(formatPrice($('[name="subscription_value"]').val())[0]))
        $('#card-name').val($('#register-form').find('[name="name"]').val())

    })
    $('.btn-open-payment-renew-modal').click(function(){
        $('#offer-name').text($(this).data('subscription-name').toUpperCase())
        $('#subscription-price').text($(this).data('subscription-price'))
        $('[name="subscription_value"]').val($(this).data('subscription-price'))
        $('#subscription-price-show').text(formatPrice($(this).data('subscription-price'))[0])
        $('#card-name').val($('[name="card-name"]').val())
        $('[name="new_subscription_id"]').val($(this).data('subscription-id'))
        $('[name="subscription_annual"][value="1"]').prop('checked', true);
        $('#economy-price').text(economyPrice(formatPrice($('[name="subscription_value"]').val())[0]))
        $('[name="annual"]').val(1)

        lastSubscriptionInvoice = JSON.parse($('[name="last-subscription-invoice"]').val())
        // Sélectionner par défaut le contenu de Stripe
        if(lastSubscriptionInvoice.mode === 'tmoney'){
            $('#menu-tmoney').click();
            $('[name="tmoney"]').val(lastSubscriptionInvoice.tel)
        }else if(lastSubscriptionInvoice.mode === 'flooz'){
            $('#menu-flooz').click();
            $('[name="flooz"]').val(lastSubscriptionInvoice.tel)
        }else{
            // $('#stripeContent').show();
            $('#menu-stripe').click();
        }
    })
    // Script pour gérer le changement de contenu en fonction du clic sur le menu de paiement
    $(document).ready(function() {
        $('.payment-method').click(function() {
            $('.payment-method').removeClass('active'); // Supprime la classe active de tous les éléments
            $(this).addClass('active'); // Ajoute la classe active à l'élément cliqué

            var target = $(this).data('target'); // Récupère l'ID du contenu cible
            $('.payment-content').hide(); // Cache tous les contenus de paiement
            $(target).show(); // Affiche le contenu cible
        });

    });

    // END PRICING MODAL

    // START STRIPE
    // Setup CSRF token for AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': '{{csrf_token()}}'
        }
    });
    // Create a Stripe instance with your publishable API key

    // START PAYPAL

    function loadPayPalSDK(clientId) {
        const script = document.createElement('script');
        script.src = `https://www.paypal.com/sdk/js?client-id=${clientId}&vault=true&intent=subscription`;
        script.onload = initPayPal;
        document.head.appendChild(script);
    }

    fetch('/paypal-client-id')
        .then(response => response.json())
        .then(data => {
            if (data.client_id) {
                loadPayPalSDK(data.client_id);  // Charger le SDK avec le client-id
            } else {
                console.error('Client ID PayPal introuvable.');
            }
        })
        .catch(error => console.error('Erreur:', error));
    // Initialiser le bouton PayPal après le chargement du SDK
    async function initPayPal() {
        // Charger le script SDK PayPal de manière asynchrone
        // Récupérer le token d’accès depuis Laravel
        const response = await fetch('/paypal-access-token');
        const dataToken = await response.json();
        if (typeof paypal !== 'undefined') {
            const accessToken = dataToken.access_token;
            console.log('paypal SDK')
            console.log(paypal)
            paypal.Buttons({
                style: {
                    shape: 'pill',
                    color: 'blue',
                    layout: 'vertical',
                    label: 'subscribe'
                },
                createSubscription: async function(data, actions) {
                    let subscriptionId = $('[name="new_subscription_id"]').val() ? $('[name="new_subscription_id"]').val() : $('[name="subscription_id"]').val()
                    let subscriptionAnnual = $('[name="annual"]').val()
                    let subscriptionType = $('#type-payment').val()
                    let planID = await getPaypalPlanID(subscriptionId, subscriptionAnnual, subscriptionType)
                    return actions.subscription.create({
                        'plan_id': planID
                    });
                },
                onApprove: async function(data, actions) {
                    let paypal_given_name = $('[name=name]').val()
                    let paypal_email = $('[name=email]').val()
                    let subscriptionId = $('[name="new_subscription_id"]') ? $('[name="new_subscription_id"]').val() : $('[name="subscription_id"]').val()
                    let subscriptionAnnual = $('[name="annual"]').val()
                    let subscriptionType = $('#type-payment').val()
                    let planID = await getPaypalPlanID(subscriptionId, subscriptionAnnual, subscriptionType)
                    $.ajax({
                        url: "{{ route('paypal.subscription.create') }}",
                        method: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}",
                            subscriptionID: data.subscriptionID,
                            planID: planID,
                            given_name: paypal_given_name,
                            email: paypal_email,
                        },
                        success: function(response) {
                            paymentInfosSup = JSON.stringify({
                                email: paypal_email,
                                name: paypal_given_name,
                                tel: "",
                                paypal_id: data.subscriptionID,
                            })
                            if($('#type-payment').val() === 'trial'){
                                // Convertir les informations de paiement en JSON et les encoder
                                // Mettre à jour la valeur de payment_infos_sup dans le formulaire
                                $('[name=subscription_mode]').val('paypal')
                                $('[name=payment_infos_sup]').val(paymentInfosSup)
                                $('#register-form').submit()
                            }else{
                                let companyId = $('[name="company_id"]').val()
                                let subscriptionId = $('[name="new_subscription_id"]').val()
                                let type = 'renew'
                                let mode = 'paypal'
                                let annual = $('[name="subscription_annual"]').val()
                                // let paypalId = data.subscriptionID

                                // Construire l'URL avec tous les paramètres nécessaires
                                let href = `/paiement_renew/${companyId}/${subscriptionId}/${type}/${annual}/${mode}/${paymentInfosSup}`;

                                window.location.href = href
                            }
                            // alert('ok')
                            {{--window.location.href = "{{ route('paypal.subscription.success') }}";--}}
                        }
                    });
                },
                onCancel: function(data) {
                    console.log(data)
                    $('#paypal-errors').show().text('Echec de paiement. Veuillez réessayer SVP');
                    {{--window.location.href = "{{ route('paypal.subscription.cancel') }}";--}}
                }
            }).render('#paypal-button-container');
        }
        else {
            alert('PayPal');
        }
    }
    initPayPal()

    // END PAYPAL
</script>
