<script>
    // PAYMENTS

    // SUPPORT

    var formatPrice = function (price) {
        price = parseFloat(price);
// Séparer la partie entière et la partie décimale
        var parts = price.toFixed(2).split('.');

// Formater la partie entière avec des espaces
        var wholePart = parseInt(parts[0]).toLocaleString('fr-FR');

// Partie décimale
        var decimalPart = ',' + parts[1];

        return [wholePart, decimalPart];
    }

    var getStripePriceID = function (subscription_id, subscription_annual) {
        if (subscription_id == undefined)
            return null;
        switch (subscription_id) {
            case '1':
                return subscription_annual ? 'price_1QDmC4GKHfaav9hRBeV6mW0G' : 'price_1PYViBGKHfaav9hR8uYFMrcv';
            case '2':
                return subscription_annual ? 'price_1QDmNXGKHfaav9hRqMgUFGxX' : 'price_1PYVgrGKHfaav9hRovLv0f1Y';
            case '3':
                return subscription_annual ? 'price_1QDmLcGKHfaav9hRjlnnuu4E' : 'price_1PXoY3GKHfaav9hRSvsF3I9e';
        }
    }

    var getPaypalPlanID = function (subscription_id, subscription_annual, subscription_type) {
        if (subscription_id == undefined)
            return null;
        if (subscription_type === 'trial') {
            switch (subscription_id) {
                case '1':
                    return parseInt(subscription_annual) ? 'P-71M81872TK168692KM4N3LGI' : 'P-3U058892MF440380BM4N3LUY';
                case '2':
                    return parseInt(subscription_annual) ? 'P-0BW717678R9933528M4N3GCQ' : 'P-7D034451NW303101GM4N3GXQ';
                case '3':
                    return parseInt(subscription_annual) ? 'P-0YV7634911943281BM4N27JI' : 'P-34L16848A4742200SM3ZUUOY';
            }
        } else {
            switch (subscription_id) {
                case '1':
                    return parseInt(subscription_annual) ? 'P-8R6730820C011103TM4PJHTQ' : 'P-4SY18101UJ352825NM4PJBCI';
                case '2':
                    return parseInt(subscription_annual) ? 'P-6G7268707S643943FM4PJJPI' : 'P-4H8469630R8006457M4PJEHA';
                case '3':
                    return parseInt(subscription_annual) ? 'P-04511543LH027535CM4PJJ5A' : 'P-964667370V9778138M4PJE5I';
            }
        }
    }

    // START STRIPE
    // Setup CSRF token for AJAX requests
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': '{{csrf_token()}}'
        }
    });

    // Create a Stripe instance with your publishable API key
    var stripe = Stripe('{{env('STRIPE_PK_TEST')}}');

    // Create an instance of Elements
    var elements = stripe.elements();

    // Create a card Element and mount it to the card-element div
    var cardElement = elements.create('card');
    cardElement.mount('#card-element');

    // Handle form submission
    $('#stripe-checkout-button').on('click', function (event) {
        event.preventDefault();
        $('#stripe-checkout-button').hide();
        $('.btn-modal-loading').show();
        var cardHolderName = $('[name="card_name"]').val();
        var email = lastSubscriptionInvoice ? lastSubscriptionInvoice.card_email : $('#register-form').find('[name="email"]').val();
        var price_id = getStripePriceID($('[name="subscription_id"]').val());

        $('[name="subscription_mode"]').val('stripe');
        stripe.createPaymentMethod({
            type: 'card',
            card: cardElement,
            billing_details: {
                name: cardHolderName,
            },
        }).then(function (result) {
            if (result.error) {
                $('#card-errors').show().text(result.error.message);
                $('.btn-modal-loading').hide();
                $('#stripe-checkout-button').show();
            } else {
                $.post('/create-subscription', {
                    payment_method: result.paymentMethod.id,
                    email: email,
                    name: cardHolderName,
                    price_id: price_id
                }, function (data) {
                    console.log('stripe data');
                    console.log(data);
                    if (data.error) {
                        $('#card-errors').show().text(data.error);
                    } else {
                        paymentInfosSup = JSON.stringify({
                            email: email,
                            name: cardHolderName,
                            tel: "",
                            stripe_id: data.subscription.id,
                        });
                        if ($('#type-payment').val() === 'trial') {
// Convertir les informations de paiement en JSON et les encoder
// Mettre à jour la valeur de payment_infos_sup dans le formulaire
                            $('[name="payment_infos_sup"]').val(paymentInfosSup);
                            $('#register-form').submit();
                        } else {
                            let companyId = $('[name="company_id"]').val();
                            let subscriptionId = $('[name="new_subscription_id"]').val();
                            let type = 'renew';
                            let mode = 'stripe';

// Construire l'URL avec tous les paramètres nécessaires
                            let href = `/paiement_renew/${companyId}/${subscriptionId}/${type}/${mode}/${paymentInfosSup}`;
                            window.location.href = href;
                        }
                    }
                });
            }
        });
    });

    // END STRIPE

    // START PAYPAL
    // Charger le script SDK PayPal de manière asynchrone
    paypal.Buttons({
        style: {
            shape: 'pill',
            color: 'blue',
            layout: 'vertical',
            label: 'subscribe'
        },
        createSubscription: function (data, actions) {
            let subscriptionId = $('[name="new_subscription_id"]').val() ? $('[name="new_subscription_id"]').val() : $('[name="subscription_id"]').val();
            let subscriptionAnnual = $('[name="annual"]').val();
            let subscriptionType = $('#type-payment').val();
            let planID = getPaypalPlanID(subscriptionId, subscriptionAnnual, subscriptionType);
            return actions.subscription.create({
                'plan_id': planID // Votre plan ID PayPal
            });
        },
        onApprove: function (data, actions) {
            let paypal_given_name = $('[name=name]').val();
            let paypal_email = $('[name=email]').val();
            let subscriptionId = $('[name="new_subscription_id"]') ? $('[name="new_subscription_id"]').val() : $('[name="subscription_id"]').val();
// Reste du code ici...
        }
    });
</script>
