@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Modifier une Chambre</div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
                        {{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
                        {{--                            data-mdl-for = "panel-button">--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('rooms.update', $data->custom_id) }}" method="POST" id="form_sample_1" class="form-horizontal">
                                @csrf
                                {{ method_field('put') }}
                                <div class="form-body">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Nom
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->name }}" type="text" name="name" data-required="1" placeholder="AB+" class="form-control input-height" required/> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Département
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <select name="department_id" id="" class="form-control input-height">
                                                <option value=""></option>
                                                @foreach($departments as $department)
                                                    <option value="{{ $department->id }}" @if($department->id == $data->department_id) selected @endif>{{ $department->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <a href="#" data-target="#departmentModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Prix {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!} / Jour
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->price }}" type="text" name="price" data-required="1" placeholder="3000" class="form-control input-height" />
                                        </div>
                                    </div>

                                    <div class="form-actions">
                                        <div class="row">
                                            <div class="offset-md-3 col-md-9">
                                                <button type="submit" class="btn btn-primary">Enregistrer</button>
                                                <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

    </script>
@endpush
