@extends('layout.app')

@section('content')
    <style>
        .fa-check, .fa-clock, .clock{
            font-size: 18px;
            position: absolute;
            top: 0;
            left: 0
        }
        .fa-check, .clock{
            cursor: pointer;
        }
        .fa-check{
            color: lime;
        }
        .options{
            position: absolute;
            top: 0;
            right: -10px
        }
        .options a{
            margin-bottom: 5px
        }
    </style>
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">@if(auth()->user()->isTraitant()) Mes @endif Rendez-vous ({{ $total }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('rdvs.create') }}">Ajouter</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link"
                                                        href="#tab1" data-toggle="tab">Passés</a></li>
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab2" data-toggle="tab">Aujourd'hui</a></li>
                        <li class="nav-item tab-all"><a class="nav-link"
                                                        href="#tab3" data-toggle="tab">À venir</a></li>

                    </ul>

                    <div class="tab-content">
                        @php $i = 1;  @endphp
                        <div class="tab-pane" id="tab1">
                            @foreach($pasts as $data)
                                @if($i == 1 OR ($i - 1) % 3 == 0)<div class="row">@endif
                                    <div class="col-md-4">
                                        <div class="card card-box">
                                            <div class="card-body no-padding ">
                                                <div class="doctor-profile">
                                                    <div class="profile-usertitle" style="position: relative">
                                                        @if(!$data->done)
                                                            @if($data->datePast())
                                                                <i class="far fa-clock clock" data-toggle="tooltip" data-placement="top" title="Effectuée ?" data-route="{{ route('rdvs.toggleDone', $data->custom_id) }}" style="cursor: pointer" ></i>
                                                            @else
                                                                <i class="far fa-clock"></i>
                                                            @endif
                                                        @else
                                                            <i class="fas fa-check" data-route="{{ route('rdvs.toggleDone', $data->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Pas encore effectuée ?" style="cursor: pointer"></i>
                                                        @endif
                                                        <div class="doctor-name">{{ $data->title }}</div>
                                                        <div class="options">
                                                            <a href="{{ route('rdvs.edit', $data->custom_id) }}" class="" >
                                                                <i class="hgi-stroke hgi-edit-02 text-dark h3" data-toggle="tooltip" data-placement="top" title="Modifier"></i>
                                                            </a><br>
                                                            @if(!$data->hasRelatedRecords())
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('rdvs.delete', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" data-toggle="tooltip" data-placement="top" title="Supprimer"></i>
                                                                </a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div>
                                                        {!! $data->reason !!} <br />
                                                    </div>
                                                    <div><p style="font-size: 12px; font-style: italic">{{ $data->datetime->translatedFormat('D d F Y') }}</p> </div>
                                                    <div>
                                                        @if(auth()->user()->subStandard() AND $data->type == 'Téléconsultation')
                                                            <a href="{{ route('teleconsultations.liveID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-laptop-medical"></i> Téléconsulter</a>
                                                        @elseif($data->type == 'Consultation')
                                                            <a href="{{ route('consultations.createID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-notes-medical"></i> Consulter</a>
                                                        @elseif($data->type == 'Hospitalisation')
                                                            <a href="{{ route('interventions.createID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-ambulance"></i> Hospitaliser</a>
                                                        @endif
                                                    </div>
                                                    <div class="profile-userbuttons" style="font-size: 11px">
                                                        <span class="pull-left" style="float: left">Patient : <a href="{{ route('patients.show', $data->patient->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Consulter le suivi">{{ $data->patient->name }}</a></span>
                                                        <span class="pull-right">@if(auth()->user()->role == 'Docteur') Dr. @endif <a href="{{ asset(env('APP_URL').'storage/uploads/users/'.$data->user->photo) }}" data-toggle="tooltip" data-placement="top" title="Voir la photo" target="_blank">{{ $data->user->name }}</a></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @if($i % 3 == 0 OR $loop->last)</div>@endif
                                @php $i++; @endphp
                            @endforeach
                        </div>

                        @php $i = 1;  @endphp
                        <div class="tab-pane active" id="tab2">
                            @foreach($todays as $data)
                                @if($i == 1 OR ($i - 1) % 3 == 0)<div class="row">@endif
                                    <div class="col-md-4">
                                        <div class="card card-box">
                                            <div class="card-body no-padding ">
                                                <div class="doctor-profile">
                                                    <div class="profile-usertitle" style="position: relative">
                                                        <div class="options">
                                                            <a href="{{ route('rdvs.edit', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Modifier">
                                                                <i class="hgi-stroke hgi-edit-02 text-dark h3"></i>
                                                            </a><br>
                                                            @if(!$data->hasRelatedRecords())
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('rdvs.delete', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Supprimer">
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3"></i>
                                                                </a>
                                                            @endif
                                                        </div>
                                                        <div class="doctor-name">{{ $data->title }}</div>
                                                        @if(!$data->done)
                                                            @if($data->datePast())
                                                                <i class="far fa-clock clock" data-toggle="tooltip" data-placement="top" title="Effectuée ?" data-route="{{ route('rdvs.toggleDone', $data->custom_id) }}" ></i>
                                                            @else
                                                                <i class="far fa-clock"></i>
                                                            @endif
                                                        @else
                                                            <i class="fas fa-check" data-route="{{ route('rdvs.toggleDone', $data->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Pas encore effectuée ?" style=""></i>
                                                        @endif
                                                    </div>
                                                    <div>
                                                        {!! $data->reason !!} <br />
                                                    </div>
                                                    <div><p style="font-size: 12px; font-style: italic">{{ $data->datetime->translatedFormat('D d F Y') }}</p> </div>
                                                    <div>
                                                        @if(auth()->user()->subStandard() AND $data->type == 'Téléconsultation')
                                                            <a href="{{ route('teleconsultations.liveID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-laptop-medical"></i> Téléconsulter</a>
                                                        @elseif($data->type == 'Consultation')
                                                            <a href="{{ route('consultations.createID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-notes-medical"></i> Consulter</a>
                                                        @elseif($data->type == 'Hospitalisation')
                                                            <a href="{{ route('interventions.createID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-ambulance"></i> Hospitaliser</a>
                                                        @endif
                                                    </div>
                                                    <div class="profile-userbuttons" style="font-size: 11px">
                                                        <span class="pull-left" style="float: left">Patient : <a href="{{ route('patients.show', $data->patient->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Consulter le suivi">{{ $data->patient->name }}</a></span>
                                                        <span class="pull-right">@if(auth()->user()->role == 'Docteur') Dr. @endif <a href="{{ asset(env('APP_URL').'storage/uploads/users/'.$data->user->photo) }}" data-toggle="tooltip" data-placement="top" title="Voir la photo" target="_blank">{{ $data->user->name }}</a></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @if($i % 3 == 0 OR $loop->last)</div>@endif
                                @php $i++; @endphp
                            @endforeach
                        </div>

                        @php $i = 1;  @endphp
                        <div class="tab-pane" id="tab3">
                            @foreach($comings as $data)
                                @if($i == 1 OR ($i - 1) % 3 == 0)<div class="row">@endif
                                    <div class="col-md-4">
                                        <div class="card card-box">
                                            <div class="card-body no-padding ">
                                                <div class="doctor-profile">
                                                    <div class="profile-usertitle" style="position: relative">
                                                        <div class="options">
                                                            <a href="{{ route('rdvs.edit', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Modifier">
                                                                <i class="hgi-stroke hgi-edit-02 text-dark h3"></i>
                                                            </a><br>
                                                            @if(!$data->hasRelatedRecords())
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('rdvs.delete', $data->custom_id) }}" class="" data-toggle="tooltip" data-placement="top" title="Supprimer">
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3"></i>
                                                                </a>
                                                            @endif
                                                        </div>
                                                        <div class="doctor-name">{{ $data->title }}</div>
                                                        @if(!$data->done)
                                                            @if($data->datePast())
                                                                <i class="far fa-clock clock" data-toggle="tooltip" data-placement="top" title="Effectuée ?" data-route="{{ route('rdvs.toggleDone', $data->custom_id) }}" ></i>
                                                            @else
                                                                <i class="far fa-clock"></i>
                                                            @endif
                                                        @else
                                                            <i class="fas fa-check" data-route="{{ route('rdvs.toggleDone', $data->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Pas encore effectuée ?" style=""></i>
                                                        @endif
                                                    </div>
                                                    <div>
                                                        {!! $data->reason !!} <br />
                                                    </div>
                                                    <div><p style="font-size: 12px; font-style: italic">{{ $data->datetime->translatedFormat('D d F Y') }}</p> </div>
                                                    <div>
                                                        @if(auth()->user()->subStandard() AND $data->type == 'Téléconsultation')
                                                            <a href="{{ route('teleconsultations.liveID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-laptop-medical"></i> Téléconsulter</a>
                                                        @elseif($data->type == 'Consultation')
                                                            <a href="{{ route('consultations.createID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-notes-medical"></i> Consulter</a>
                                                        @elseif($data->type == 'Hospitalisation')
                                                            <a href="{{ route('interventions.createID', $data->patient->custom_id) }}" class="btn btn-light btn-sm"><i class="fas fa-ambulance"></i> Hospitaliser</a>
                                                        @endif
                                                    </div>
                                                    <div class="profile-userbuttons" style="font-size: 11px">
                                                        <span class="pull-left" style="float: left">Patient : <a href="{{ route('patients.show', $data->patient->custom_id) }}" data-toggle="tooltip" data-placement="top" title="Consulter le suivi">{{ $data->patient->name }}</a></span>
                                                        <span class="pull-right">@if(auth()->user()->role == 'Docteur') Dr. @endif <a href="{{ asset(env('APP_URL').'storage/uploads/users/'.$data->user->photo) }}" data-toggle="tooltip" data-placement="top" title="Voir la photo" target="_blank">{{ $data->user->name }}</a></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @if($i % 3 == 0 OR $loop->last)</div>@endif
                                @php $i++; @endphp
                            @endforeach
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

        $('.desc-link').click(function(){
            $('#descModal .modal-body').html($(this).attr('data-content'))
        })

        $('.clock, .fa-check').click(function(){
            $.post($(this).attr('data-route'), {_token : "{{ csrf_token() }}"}, function(rsp){
                window.location = window.location.href
            })
        })

    </script>
@endpush
