@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Modifier un Rendez-vous</div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
{{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
{{--                            data-mdl-for = "panel-button">--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
{{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('rdvs.update', $data->custom_id) }}" method="POST" id="form_sample_1" class="form-horizontal">
                            @csrf
                            {{ method_field('put') }}
                            <div class="form-body">
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Professionnel en charge
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="user_id">
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" @if(auth()->user()->id == $user->id) selected @endif>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Patient
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="patient_id">
                                            @foreach($patients as $patient)
                                                <option value="{{ $patient->id }}" @if($patient->id == $data->patient_id) selected @endif>{{ $patient->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#patientModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Titre
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input value="{{ $data->title }}" type="text" name="title" data-required="1" placeholder="Covid Test" class="form-control input-height" /> </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Type
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="type">
                                            @if(auth()->user()->subStandard())
                                            <option @if($data->type == "Téléconsultation") selected  @endif>Téléconsultation</option>
                                            @endif
                                            <option @if($data->type == "Consultation") selected  @endif>Consultation</option>
                                            <option @if($data->type == "Hospitalisation") selected  @endif>Hospitalisation</option>
                                            <option @if($data->type == "") selected  @endif>Autre</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Motif
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <textarea name="reason" id="reason" cols="30" rows="10" class=" form-control-textarea">{{ $data->reason }}</textarea>
                                    </div>
                                   @if(auth()->user()->subGold())
                                        <div>
                                            <span class="nav-link btn btn-light btn-sm font-weight-bolder font-size-20 countdown" style="display: none"></span>
                                            <i class="fa fa-microphone btn btn-light btn-sm" id="start-btn"></i>
                                            <i class="fa fa-microphone fa-beat btn btn-light btn-sm text-danger" id="stop-btn" style="display: none"></i>
                                        </div>
                                        @endif
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Date & Heure
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <div class="input-group date form_date ">
                                            <input class="form-control input-height" value="{{ $data->datetime }}" name="datetime" size="16" placeholder="date of Birth" type="datetime-local">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-actions">
                                    <div class="row">
                                        <div class="offset-md-3 col-md-9">
                                            <button type="submit" class="btn btn-primary">Enregistrer</button>
                                            <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })
    </script>
@endpush
