@include('helpers.ChiffresEnLettres')
<!doctype html>
<html>
<head>
    <meta charset="utf-8">

    <style>
        @page {
            margin: 1cm; /* Adjust as needed */
        }

        body{
            padding: 0 !important;
        }

        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 0px;
            border: 0px solid #eee;
            box-shadow: 0 0 10px rgba(0, 0, 0, .15);
            font-size: 11px;
            line-height: 24px;
            font-family: 'century gothic', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(2) {
            /*text-align: right;*/
        }

        .invoice-box table tr.top table td {
            padding-bottom: 0px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 16px;
            /*line-height: 45px;*/
            color: #333;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 0px;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            font-weight: bold;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td{
            border-bottom: 1px solid #eee;
            page-break-inside: avoid;
            vertical-align: top;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(4) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }

        /** RTL **/
        .rtl {
            direction: rtl;
            font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
        }

        .rtl table {
            text-align: right;
        }

        .rtl table tr td:nth-child(1) {
            text-align: left;
        }

        .top-header{
            font-size: 11px
        }

        tr.heading td:nth-child(3), tr.item td:nth-child(3){
            text-align: left !important;
        }

        tr.heading td:nth-child(4), tr.item td:nth-child(4),
        tr.heading td:nth-child(5), tr.item td:nth-child(5),
        .information td:nth-child(2), .top td:nth-child(2),
        .signature td:nth-child(2)
        {
            text-align: right !important;
        }
    </style>
</head>

<body>
@php $company = auth()->user()->company; @endphp
<div class="invoice-box">
    <table cellpadding="0" cellspacing="0">
        <tr class="top">
            <td colspan="5">
                <table>
                    <tr>
                        <td class="title">
                            @if($company->logo)
                                <img src="{{ public_path(env('APP_URL').'storage/uploads/company/'.$company->logo) }}" style="width:100%; max-width:50px;"><br>
                            @endif
                                <b style="font-size: 11px">{{ $company->name }}</b>
                        </td>

                        <td>
                            <div class="top-header">
                                <i>{{$company->city ? $company->city : 'Lomé'}}, le {{ $data->date->format('d') }} {{ $data->monthToFr() }} {{ $data->date->format('Y') }}</i><br>
                                <b>{{$data->consultation_id ? 'Consultation' : 'Téléconsultation'}}</b>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <tr class="information">
            <td colspan="5">
                <table>
                    <tr>
                        <td>
                            <p style="font-size: 11px">
                                <b>Dr. {{ $company->doctor }}</b><br>
                                @if($company->diploma)
                                    ({{ $company->diploma }})<br>
                                @endif
                                <B style="font-size: 9px !important;">
                                    {!! $company->header !!}
                                </B>
                            </p>
                        </td>
                        <td>
                            <p style="font-size: 11px">
                                <b>{{ $data->patient->name }}</b><br>
                                @if($data->patient->email) {{ $data->patient->email }}<br> @endif
                                {{ $data->patient->tel }}<br>
                                {!! $data->patient->address !!}<br>
                                <i>{{ $data->patient->assured ? 'Assuré' : 'Non Assuré' }}</i>
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td colspan="5" style="text-align: center">
                <h2>ORDONNANCE MÉDICALE</h2>
            </td>
        </tr>
        <tr class="item">
            <td colspan="5">
                <p style="font-size: 9px !important; margin: 0; padding: 0">
                    {!! $data->consultation->prescription !!}
                </p>
            </td>
        </tr>
    </table>
    <br>
    <table>
        <tr class="signature" style="font-size: 10px">
            <td>Signature du Patient</td>
            <td>
                    Signature
                    <br>
                    @if($company->signature)
                        <br>
                        <img src="{{ public_path(env('APP_URL').'storage/uploads/company/'.$company->signature) }}"  style="height:50px;  max-height:50px; text-align: right" alt="">
                    @endif
                    <br>
                    <b>Le Directeur Général</b>
            </td>
        </tr>
    </table>
    <hr style="border: 1px solid #ddd"/>
    <div style="text-align: center !important;">
        <p class="footer">
            {!! $company->footer !!}
        </p>
    </div>
</div>
</body>
</html>
