@extends('layout.app')

@section('content')
    <style>
        .user-btm-box, .profile-row th, .profile-row td{
            font-size: 11px !important;
        }
        .white-box .cardbox{
            background: rgb(239,242,255) radial-gradient(circle, rgba(239,242,255,1) 0%, rgba(255,255,255,1) 50%, rgba(238,241,255,1) 100%); !important;
            box-shadow: none !important;
        }
        .card-header{
            background: none !important;
            border: none !important;
        }
    </style>
<div class="page-content">
    <div class="page-bar">
        <div class="page-title-breadcrumb">
            <div class=" pull-left">
                <div class="page-title">Suivi du Patient
                    &nbsp;
                    <a href="{{ route('patients.edit', $data->custom_id) }}" class="btn btn-light btn-sm">
                        <i class="hgi-stroke hgi-edit-02"></i> Modifier
                    </a>
                    @if(auth()->user()->subStandard())
{{--                    <a href="{{ route('teleconsultations.liveID', $data->custom_id) }}" class="btn btn-light btn-sm">--}}
{{--                        <i class="fas fa-laptop-medical"></i> Téléconsulter--}}
{{--                    </a>--}}
                    @endif
                    <a href="{{ route('consultations.createID', $data->custom_id) }}" class="btn btn-light btn-sm">
                        <i class="fas fa-notes-medical"></i> Consulter
                    </a>
                    <a href="{{ route('interventions.createID', $data->custom_id) }}" class="btn btn-light btn-sm">
                        <i class="fas fa-ambulance"></i> Hospitaliser
                    </a>
                    @if(auth()->user()->subStandard())
                    <a href="javascript:void(0)" class="btn btn-light btn-sm" data-toggle="modal" data-target="#doctorAIAdvice" id="doctor-ai" onclick="generateAIAdvice()">
                        <i class="fas fa-user-nurse"></i>
                        Conseils Docteur IA @if(auth()->user()->subStandard() AND !auth()->user()->subGold())( <span id="ai-credits">{{auth()->user()->company->ai_credits}}</span> crédits restants )@endif
                    </a>
                    @endif
                </div>

            </div>

        </div>
    </div>
    <div class="row profile-row">
        <div class="col-md-12 col-xs-12">
            <div class="white-box">
{{--                <div class=" cardbox patient-profile">--}}
{{--                    <img src="../assets/img/patient1.jpg" class="img-responsive" alt="">--}}
{{--                </div>--}}

                <div class="cardbox">
                    <div class="body">
                        <div class="user-btm-box">
                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Noms
                                    <p class="bold">{{ $data->name }}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12">Age
                                    <p class="bold">{{ $data->age() }} ans</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Genre
                                    <p class="bold">{{ $data->sex }}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12">Groupe
                                    <p class="bold">{{ $data->group->name }}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Pathologie
                                    <p class="bold">{{ $data->pathology }}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12">Profession
                                    <p class="bold">{{ $data->job }}</p>
                                </div>
                            </div>
                            <!-- /.row -->

                            <!-- .row -->
                            <div class="row text-center m-t-10">
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Poids
                                    <p class="bold">{{ $data->weight }} Kg</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12">Taille
                                    <p class="bold">{{ $data->size }} cm</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Téléphone
                                    <p class="bold">{{ $data->tel }}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Adresse
                                    <p class="bold small">{!! $data->address !!}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Antécédent
                                    <p class="bold">{{ $data->antecedent }}</p>
                                </div>
                                <div class="col-lg-2 col-md-12 col-sm-6 col-xs-12 b-r">Assuré
                                    <p class="bold">{{ $data->assured ? 'Oui' : 'Non' }}
                                    @if($data->assured)<br><span class="text-sm-center small bold">Sécurité Sociale {{$data->assured_social_percent}}% <br> Complémentaire {{$data->assured_completed_percent}}%</span>@endif
                                    </p>
                                </div>
                            </div>
                            <!-- /.row -->

                        </div>
                    </div>
                </div>
                <hr>
                @if($data->isStay())
                    <div class="container">
                        <div class="row">
                            <div class="col-sm">
                                <span class="small text-muted">En hospitalisation depuis le </span><br>
                                <span class="bold">{{ $data->lastIntervention()->datetimefrom->translatedFormat('D d F Y') }}</span>
                            </div>
                            <div class="col-sm">
                                <span class="small text-muted">Chambre</span><br>
                                <span class="bold">{{ $data->lastIntervention() ? $data->lastIntervention()->room->name : '' }} {{ $data->lastIntervention() ? ($data->lastIntervention()->room->department?' - '.$data->lastIntervention()->room->department->name:'') : '' }}</span>
                            </div>
                            <div class="col-sm">
                                <span class="small text-muted">Maladie ou Gêne actuel</span><br>
                                <span class="bold">{{ $data->lastIntervention()->trouble->name }}</span>
                            </div>
                            <div class="col-sm">
                                <span class="small text-muted">Etat actuel</span><br>
                                <span class="bold text-{{ $data->lastIntervention()->status->color }}">{{ $data->lastIntervention()->status->name }}</span>
                            </div>
                        </div>

                        {{--                        <div class="post-box">--}}
                        {{--                            <h4 class="font-bold">General Report</h4>--}}
                        {{--                            <hr>--}}
                        {{--                            <h5>Heart Beat <span class="pull-right">85</span></h5>--}}
                        {{--                            <div class="progress">--}}
                        {{--                                <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%"> <span class="sr-only">40% Complete (success)</span> </div>--}}
                        {{--                            </div>--}}
                        {{--                            <h5>Blood Pressure<span class="pull-right">93</span></h5>--}}
                        {{--                            <div class="progress">--}}
                        {{--                                <div class="progress-bar progress-bar-warning progress-bar-striped active" role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100" style="width:90%;"> <span class="sr-only">50% Complete</span> </div>--}}
                        {{--                            </div>--}}
                        {{--                            <h5>Sugar<span class="pull-right">55</span></h5>--}}
                        {{--                            <div class="progress">--}}
                        {{--                                <div class="progress-bar progress-bar-primary progress-bar-striped active" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width:50%;"> <span class="sr-only">50% Complete</span> </div>--}}
                        {{--                            </div>--}}
                        {{--                            <h5>Haemoglobin<span class="pull-right">78%</span></h5>--}}
                        {{--                            <div class="progress">--}}
                        {{--                                <div class="progress-bar progress-bar-danger progress-bar-striped active" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:70%;"> <span class="sr-only">50% Complete</span> </div>--}}
                        {{--                            </div>--}}
                        {{--                        </div>--}}
                    </div>
                @endif
            </div>
        </div>
        <div class="col-md-6 col-xs-12">
            <div class="body">

{{--                        <div class="post-box">--}}
{{--                            <h4 class="font-bold">General Report</h4>--}}
{{--                            <hr>--}}
{{--                            <h5>Heart Beat <span class="pull-right">85</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 40%"> <span class="sr-only">40% Complete (success)</span> </div>--}}
{{--                            </div>--}}
{{--                            <h5>Blood Pressure<span class="pull-right">93</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-warning progress-bar-striped active" role="progressbar" aria-valuenow="90" aria-valuemin="0" aria-valuemax="100" style="width:90%;"> <span class="sr-only">50% Complete</span> </div>--}}
{{--                            </div>--}}
{{--                            <h5>Sugar<span class="pull-right">55</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-primary progress-bar-striped active" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width:50%;"> <span class="sr-only">50% Complete</span> </div>--}}
{{--                            </div>--}}
{{--                            <h5>Haemoglobin<span class="pull-right">78%</span></h5>--}}
{{--                            <div class="progress">--}}
{{--                                <div class="progress-bar progress-bar-danger progress-bar-striped active" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100" style="width:70%;"> <span class="sr-only">50% Complete</span> </div>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12">
                                    @if($data->teleconsultations)
                                        <div class="card card-box">
                                            <div class="card-header">
                                                <header class="page-title">Dernières Téléconsultations</header>
                                            </div>
                                            <div class="card-body ">
                                                <div class="table-responsive">
                                                    <table class="table full-width custom custom-table table-hover">
                                                        <thead>
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Durée</th>
                                                            <th>Professionnel en charge</th>
                                                            <th> Diagnostic </th>
                                                            <th> Ordonnance </th>
                                                            {{--                                                        <th>Charges ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</th>--}}
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        @foreach($data->teleconsultations as $teleconsultation)
                                                            <tr>
                                                                <td>{{ $teleconsultation->created_at->translatedFormat('D d M Y') }}</td>
                                                                <td class="center">{{ gmdate('H:i:s', $teleconsultation->duration) }}</td>
                                                                <td>{{ $teleconsultation->user->name }}</td>
                                                                <td><a href="#"  data-target="#descModal" class="desc-link" data-toggle="modal" data-content="{{ $teleconsultation->description }}">Voir</a></td>
                                                                {{--                                                        <td>14$</td>--}}
                                                                <td><a href="#"  data-target="#prescModal" class="presc-link" data-toggle="modal" data-content="{{ $teleconsultation->prescription }}" data-download-link="{{ route('invoices.download', [$teleconsultation->invoice()->custom_id, 'prescription']) }}">Voir</a></td>
                                                            </tr>
                                                        @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <div class="card card-box">
                                            <div class="card-header">
                                                <header class="page-title">Dernières Consultations</header>
                                            </div>
                                            <div class="card-body ">
                                                <div class="table-responsive">
                                                    <table class="table full-width custom custom-table table-hover">
                                                        <thead>
                                                        <tr>
                                                            <th>Date</th>
                                                            <th>Professionnel en charge</th>
                                                            <th> Diagnostic </th>
                                                            <th> Ordonnance </th>
                                                            {{--                                                        <th>Charges ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</th>--}}
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        @foreach($data->consultations as $consultation)
                                                            <tr>
                                                                <td>{{ $consultation->created_at->translatedFormat('D d M Y') }}</td>
                                                                <td>{{ $consultation->user->name }}</td>
                                                                <td><a href="#"  data-target="#descModal" class="desc-link" data-toggle="modal" data-content="{{ $consultation->description }}">Voir</a></td>
                                                                {{--                                                        <td>14$</td>--}}
                                                                <td><a href="#"  data-target="#prescModal" class="presc-link" data-toggle="modal" data-content="{{ $consultation->prescription }}" data-download-link="{{ route('invoices.download', [$consultation->invoice()->custom_id, 'prescription']) }}">Voir</a></td>
                                                            </tr>
                                                        @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
        </div>
        <div class="col-md-6 col-xs-12">
            <div class="body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card card-box">
                                    <div class="card-header">
                                        <header  class="page-title">Dernières Hospitalisations</header>
                                    </div>
                                    <div class="card-body ">
                                        <div class="table-responsive">
                                            <table class="table full-width custom custom-table table-hover">
                                                <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Professionnel en charge</th>
                                                    <th>Diagnostic</th>
                                                    <th>Soins</th>
                                                    <th>Produits</th>
                                                    {{--                                                        <th>Charges ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</th>--}}
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($data->interventions as $intervention)
                                                    <tr>
                                                        <td>{{ $intervention->datetimefrom->translatedFormat('D d M Y') }} @if($intervention->datetimeto) à {{ $intervention->datetimeto->translatedFormat('D d F Y') }} @endif</td>
                                                        <td>{{ $intervention->user->name }}</td>
                                                        <td><a href="#"  data-target="#descModal" class="desc-link" data-toggle="modal" data-content="{{ $intervention->description }}">Voir</a></td>
                                                        <td>
                                                            @foreach($intervention->cares as $care)
                                                                <li>{{ $care->name }}</li>
                                                            @endforeach
                                                        </td>
                                                        <td>
                                                            @if($intervention->sale)
                                                                @foreach($intervention->sale->commands as $command)
                                                                    <li>{{ $command->product->name }} (x{{ $command->qte }})</li>
                                                                @endforeach
                                                            @endif
                                                        </td>
                                                        {{--                                                        <td>14$</td>--}}
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
    <script>
        $('.desc-link').click(function(){
            $('#descModal .modal-body').html($(this).attr('data-content'))
        })

        $('.presc-link').click(function(){
            $('#prescModal .modal-body').html($(this).attr('data-content'))
            $('#prescModal #download-prescription').attr('href', $(this).data('download-link'))
        })

        let adviceClick = false
        checkAiCredits()

        function generateAIAdvice() {
            if(!adviceClick){
                $('#doctor-ai-icon').hide()
                $('#doctor-ai-icon-loading').show()

                const AIAdvice = $('#ai-advice')
                $.ajax({
                    url: 'https://api.perplexity.ai/chat/completions', // URL de l'API
                    type: 'POST',
                    contentType: 'application/json',
                    headers: {
                        'Authorization': 'Bearer {{env('PPLX_API')}}', // Remplacez par votre clé API
                        'Accept': 'application/json'
                    },
                    data: JSON.stringify({
                        model: 'llama-3.1-sonar-small-128k-online', // Modèle à utiliser
                        messages: [
                            { role: 'user', content: formatAdvicePrompt() }
                        ]
                    }),
                    success: function(response) {
                        // Traitez la réponse ici
                        // console.log(marked.parse(response.choices[0].message.content))
                        AIAdvice.html(marked.parse(response.choices[0].message.content))
                        $('#doctor-ai-icon-loading').hide()
                        $('#doctor-ai-icon').show()
                        adviceClick = true
                        updateAiCredits()
                        checkAiCredits()
                    },
                    error: function(xhr, status, error) {
                        console.error('Erreur:', error);
                        AIAdvice.html('<b style="color: red">Une erreur est survenue. Veuillez réessayer SVP</b>.')
                        $('#doctor-ai-icon-loading').hide()
                        $('#doctor-ai-icon').show()
                    }
                });
            }
        }

        function formatAdvicePrompt(){
            const lastConsultation = {!! json_encode($data->lastConsultation()) !!}
            const consultationMessage = lastConsultation ?
                `dernier diagnostic consultation: ${lastConsultation.description}+` +
                `dernière température consultation: ${lastConsultation.temperature}+`
                : ''

            const lastTeleconsultation = {!! json_encode($data->lastTeleconsultation()) !!}
            const teleconsultationMessage = lastTeleconsultation ?
                `dernier diagnostic téléconsultation: ${lastTeleconsultation.description}+` +
                `dernière température téléconsultation: ${lastTeleconsultation.temperature}+`
                : ''

            const lastIntervention = {!! json_encode($data->lastIntervention()) !!}
            const interventionMessage = lastIntervention ?
                'maladie/gêne actuelle: ' + (lastIntervention.trouble ? lastIntervention.trouble.name : '') + '+' +
                'état actuel: ' + (lastIntervention.status ? lastIntervention.status.name : '') + '+' +
                'dernier diagnostic hospitalisation: ' + (lastIntervention ? lastIntervention.description : '') + '+' +
                'dernier température hospitalisation: ' + (lastIntervention ? lastIntervention.temperature : '') + '+'
                : '';

            const finalMessage = 'Donne moi des conseils de soins (pour une prochaine consultation et hospitalisation) pour ce patient dont les infos sont données ci-dessous. nb: limiter les espacements et les interlignes: '
                + 'noms: {{$data->name}}+'
                + 'age: {{$data->age()}}+'
                + 'genre: {{$data->sex}}+'
                + 'groupe sanguin: {{$data->group->name}}+'
                + 'pathologie: {{$data->pathology}}+'
                + 'profession: {{$data->job}}+'
                + 'poids: {{$data->weight}}+'
                + 'taille: {{$data->size}}cm+'
                + 'antécédent: {{$data->antecedent}}+'
                + consultationMessage
                + interventionMessage
                + teleconsultationMessage

            return finalMessage
        }

        function updateAiCredits(){
            $.post('{{route('companies.updateAiCredits')}}', {_token : "{{ csrf_token() }}"}, function(rsp){
                $('#ai-credits').text(rsp)
            })
        }

        const isOnlyStandard = "{{ (auth()->user()->subStandard() AND !auth()->user()->subGold()) ? 1 : 0 }}"

        function checkAiCredits(){
            if(isOnlyStandard)
                setTimeout(()=>{
                    if($('#ai-credits').text() <= 0){
                        $('#doctor-ai').addClass('disabled')
                    }
                }, 1000)
        }
    </script>
@endpush
