@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Modifier un Patient</div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
{{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
{{--                            data-mdl-for = "panel-button">--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
{{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('patients.update', $data->custom_id) }}" method="POST" id="form_sample_1" class="form-horizontal">
                                @csrf
                                {{ method_field('put') }}
                                <div class="form-body">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Nom
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->lastname() }}" type="text" name="lastname" data-required="1" placeholder="Dosseh" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Prénoms
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->firstname() }}" type="text" name="firstname" data-required="1" placeholder="Koffi" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Date de naissance
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <div class="input-group date form_date ">
                                                <input class="form-control input-height" name="birth" size="16" placeholder="date of Birth" type="date">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Genre
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="sex">
                                                <option @if($data->sex == 'Homme') selected @endif>Homme</option>
                                                <option @if($data->sex == 'Femme') selected @endif>Femme</option>
                                                <option @if($data->sex == 'Autre') selected @endif>Autre</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Téléphone
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->tel }}" name="tel" type="text" placeholder="90909090" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Profession
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->job }}" name="job" type="text" placeholder="Garagiste" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Antécédent

                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->antecedent }}" name="antecedent" type="text" placeholder="Fracture de l'avant-bras" class="form-control input-height" /> </div>
                                    </div>
{{--                                    <div class="form-group row">--}}
{{--                                        <label class="control-label col-md-3">Pathologie--}}

{{--                                        </label>--}}
{{--                                        <div class="col-md-5">--}}
{{--                                            <input value="{{ $data->pathology }}" name="pathology" type="text" placeholder="Diabète" class="form-control input-height" /> </div>--}}
{{--                                    </div>--}}
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Poids (Kg)

                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->weight }}" name="weight" type="text" placeholder="65" class="form-control input-height" /></div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Taille (cm)
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Ex 1m70 : mettez 170"></i>

                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->size }}" name="size" type="text" placeholder="170" class="form-control input-height" /></div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Groupe Sanguin
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="group_id">
                                                @foreach($groups as $group)
                                                    <option value="{{ $group->id }}" @if($data->group_id == $group->id) selected @endif>{{ $group->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Adresse
                                        </label>
                                        <div class="col-md-5">
                                            <textarea name="address" placeholder="" class="form-control-textarea" rows="5" >{{ $data->address }}</textarea>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Assuré

                                        </label>
                                        <div class="col-md-5">
                                            <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                                   for = "stayToggle">
                                                <input type = "checkbox" id="stayToggle"
                                                       class = "mdl-switch__input" name="assured" @if($data->assured) checked @endif>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="assured-bloc @if(!$data->assured) display-none @endif">
                                        <div class="form-group row">
                                            <label class="control-label col-md-3">Sécurité Sociale (%)
                                            </label>
                                            <div class="col-md-5">
                                                <input type="text" name="assured_social_percent" data-required="1" placeholder="70" class="form-control input-height" /> </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="control-label col-md-3">Complémentaire (%)
                                            </label>
                                            <div class="col-md-5">
                                                <input type="text" name="assured_completed_percent" data-required="1" placeholder="100" class="form-control input-height" /> </div>
                                        </div>
                                    </div>


                                    <div class="form-actions">
                                        <div class="row">
                                            <div class="offset-md-3 col-md-9">
                                                <button type="submit" class="btn btn-primary">Enregistrer</button>
                                                <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('input[type="date"]').val('{{ $data->birth->format('Y-m-d') }}')

        setTimeout(function(){
            $('#stayToggle').change(function(){
                if(this.checked){
                    $('.assured-bloc').show()
                }else{
                    $('.assured-bloc').hide()
                }
            })
        }, 2000)
    </script>
@endpush
