@php
    $groups = \App\Models\Group::all();
    $departments = \App\Models\Department::where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
    $currency_symbol = auth()->user()->company->currency_symbol;
@endphp


<!-- Delete -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Suppression</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Etes-vous sûr ?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Non</button>
                <button type="button" class="btn btn-primary" id="submit" data-href="">Oui</button>
            </div>
        </div>
    </div>
</div>

<!-- Confirm Create Intervention -->
<div class="modal fade" id="confirmCreateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Générer une facture ?</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Cette facture ne sera plus éditable.
                <br>
                Vous avez aussi la possibilité de la générer plus tard dans votre liste d'hospitalisation
                <br><br>
                Voulez-vous continuer ?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="no" data-dismiss="modal">Non</button>
                <button type="button" class="btn btn-primary" id="yes" data-href="">Oui</button>
            </div>
        </div>
    </div>
</div>

<!-- Description -->
<div class="modal fade" id="descModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Diagnostic</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- Prescription -->
<div class="modal fade" id="prescModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ordonnance Médicale</h4>
                <span class="ml-3" style="margin-top: 14px">
                    <a href="#" class="text-success small h5" data-toggle="tooltip" data-placement="top" title="Télécharger" id="download-prescription">
                        <span><i class="hgi-stroke hgi-file-download "></i></span>
                        <span>Télécharger</span>
                    </a>
                </span>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>


<!-- Sale Commands -->
<div class="modal fade" id="saleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Commande</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>


<!-- Files -->
<div class="modal fade" id="filesModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Fichiers</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>


<!-- New Patient -->
<div class="modal fade" id="patientModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter un Patient</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('patients.store') }}" method="POST" id="patientform" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="lastname" data-required="1" placeholder="Dosseh" class="form-control input-height" /> </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Prénoms
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="firstname" data-required="1" placeholder="Koffi" class="form-control input-height" /> </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Email
                            </label>
                            <div class="col-md-9">
                                <input type="email" name="email" data-required="1" placeholder="jean@exemple.com" class="form-control input-height" /> </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Date de naissance
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <div class="input-group date form_date ">
                                    <input class="form-control input-height" name="birth" size="16" placeholder="date of Birth" type="date" value="">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Genre
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <select class="form-control input-height" name="sex">
                                    <option>Homme</option>
                                    <option>Femme</option>
                                    <option>Autre</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Téléphone
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input name="tel" type="text" placeholder="90909090" class="form-control input-height" /> </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Profession </label>
                            <div class="col-md-9">
                                <input name="job" type="text" placeholder="Garagiste" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Antécédent

                            </label>
                            <div class="col-md-9">
                                <input name="antecedent" type="text" placeholder="Fracture de l'avant-bras" class="form-control input-height" /> </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Pathologie

                            </label>
                            <div class="col-md-9">
                                <input name="pathology" type="text" placeholder="Diabète" class="form-control input-height" /> </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Poids (Kg)

                            </label>
                            <div class="col-md-9">
                                <input name="weight" type="text" placeholder="65" class="form-control input-height" /></div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Taille (cm)

                            </label>
                            <div class="col-md-9">
                                <input name="size" type="text" placeholder="170" class="form-control input-height" /></div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Groupe Sanguin
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <select class="form-control input-height" name="group_id">
                                    @foreach($groups as $group)
                                        <option value="{{ $group->id }}" @if($group->name == 'O+') selected @endif>{{ $group->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Adresse

                            </label>
                            <div class="col-md-9">
                                <textarea name="address" placeholder="" class="form-control-textarea" rows="5" ></textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Assuré

                            </label>
                            <div class="col-md-9">
                                <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                       for = "assuredToggle">
                                    <input type = "checkbox" id="assuredToggle"
                                           class = "mdl-switch__input" name="assured">
                                </label>
                            </div>
                        </div>
                        <div class="assured-bloc display-none">
                            <div class="form-group row">
                                <label class="control-label col-md-3">Sécurité Sociale (%)
                                </label>
                                <div class="col-md-9">
                                    <input type="text" name="assured_social_percent" data-required="1" placeholder="70" class="form-control input-height" /> </div>
                            </div>
                            <div class="form-group row">
                                <label class="control-label col-md-3">Complémentaire (%)
                                </label>
                                <div class="col-md-9">
                                    <input type="text" name="assured_completed_percent" data-required="1" placeholder="100" class="form-control input-height" /> </div>
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#patientModal form'), $('[name=patient_id]'))">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- Edit Patient -->
<!-- Modal de modification du patient -->
<div class="modal fade" id="editPatientModal" tabindex="-1" role="dialog" aria-labelledby="editPatientModalTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form id="editPatientForm" class="form-horizontal">
                <div class="modal-header">
                    <h4 class="modal-title" id="editPatientModalTitle">Modifier le Patient</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id">
                    <input type="hidden" name="custom_id">


                        <!-- Champ Nom -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom <span class="required"> * </span></label>
                            <div class="col-md-9">
                                <input type="text" name="lastname" placeholder="Dosseh" class="form-control input-height" required />
                            </div>
                        </div>

                        <!-- Champ Prénoms -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Prénoms <span class="required"> * </span></label>
                            <div class="col-md-9">
                                <input type="text" name="firstname" placeholder="Koffi" class="form-control input-height" required />
                            </div>
                        </div>

                        <!-- Champ Email -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Email</label>
                            <div class="col-md-9">
                                <input type="email" name="email" placeholder="jean@exemple.com" class="form-control input-height" />
                            </div>
                        </div>


                        <!-- Champ Date de naissance -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Date de naissance <span class="required"> * </span></label>
                            <div class="col-md-9">
                                <input class="form-control input-height" name="birth" type="date" required />
                            </div>
                        </div>

                        <!-- Champ Genre -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Genre <span class="required"> * </span></label>
                            <div class="col-md-9">
                                <select class="form-control input-height" name="sex" required>
                                    <option>Homme</option>
                                    <option>Femme</option>
                                    <option>Autre</option>
                                </select>
                            </div>
                        </div>

                        <!-- Champ Téléphone -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Téléphone <span class="required"> * </span></label>
                            <div class="col-md-9">
                                <input name="tel" type="text" placeholder="90909090" class="form-control input-height" required />
                            </div>
                        </div>

                        <!-- Champ Téléphone -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Profession </label>
                            <div class="col-md-9">
                                <input name="job" type="text" placeholder="Garagiste" class="form-control input-height" />
                            </div>
                        </div>

                        <!-- Champ Antecedent -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Antécédent

                            </label>
                            <div class="col-md-9">
                                <input name="antecedent" type="text" placeholder="Fracture de l'avant-bras" class="form-control input-height" /> </div>
                        </div>

                        <!-- Champ Pathologie -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Pathologie</label>
                            <div class="col-md-9">
                                <input name="pathology" type="text" placeholder="Diabète" class="form-control input-height" />
                            </div>
                        </div>

                        <!-- Champ Poids -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Poids (Kg)</label>
                            <div class="col-md-9">
                                <input name="weight" type="text" placeholder="65" class="form-control input-height" />
                            </div>
                        </div>

                        <!-- Champ Taille -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Taille (cm)</label>
                            <div class="col-md-9">
                                <input name="size" type="text" placeholder="170" class="form-control input-height" />
                            </div>
                        </div>

                        <!-- Champ Groupe Sanguin -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Groupe Sanguin <span class="required"> * </span></label>
                            <div class="col-md-9">
                                <select class="form-control input-height" name="group_id" required>
                                    @foreach($groups as $group)
                                        <option value="{{ $group->id }}" @if($group->name == 'O+') selected @endif>{{ $group->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Champ Adresse -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Adresse </label>
                            <div class="col-md-9">
                                <textarea name="address" class="form-control-textarea" rows="5"></textarea>
                            </div>
                        </div>

                        <!-- Champ Assuré (checkbox) -->
                        <div class="form-group row">
                            <label class="control-label col-md-3">Assuré</label>
                            <div class="col-md-9">
                                <label class="mdl-switch mdl-js-switch mdl-js-ripple-effect" for="assuredToggleEdit">
                                    <input type="checkbox" id="assuredToggleEdit" class="mdl-switch__input" name="assured">
                                </label>
                            </div>
                        </div>

                        <div class="assured-bloc display-none">
                            <div class="form-group row">
                                <label class="control-label col-md-3">Sécurité Sociale (%)
                                </label>
                                <div class="col-md-9">
                                    <input type="text" name="assured_social_percent" data-required="1" placeholder="70" class="form-control input-height" /> </div>
                            </div>
                            <div class="form-group row">
                                <label class="control-label col-md-3">Complémentaire (%)
                                </label>
                                <div class="col-md-9">
                                    <input type="text" name="assured_completed_percent" data-required="1" placeholder="100" class="form-control input-height" /> </div>
                            </div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- New Department -->
<div class="modal fade" id="departmentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="z-index: 999999">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter un Département</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('departments.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="Radiologie" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#departmentModal form'), $('[name=department_id]'))">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- New Room -->
<div class="modal fade" id="roomModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter une Chambre</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('rooms.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="103" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Département
                            </label>
                            <div class="col-md-9">
                                <select name="department_id" id="" class="form-control input-height">
                                    <option value=""></option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}">{{ $department->name }}</option>
                                    @endforeach
                                </select>
                            </div>
{{--                            <a href="#" data-target="#departmentModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>--}}
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Prix {{ $currency_symbol }} / Jour
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="price" data-required="1" placeholder="3000" class="form-control input-height" />
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#roomModal form'), $('[name=room_id]'))">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- New Type Intervention -->
<div class="modal fade" id="typeinterventionModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter un Type d'Hospitalisation</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('typeinterventions.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="Opération" class="form-control input-height" />
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#typeinterventionModal form'), $('[name=typeintervention_id]'))">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- New Trouble -->
<div class="modal fade" id="troubleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter une Maladie / Gêne</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('troubles.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="Malaria" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Gravité
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <select name="seriousness" id="" class="form-control input-height">
                                    <option>Grave</option>
                                    <option>Moyen</option>
                                    <option>Légère</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#troubleModal form'), $('[name=trouble_id]'))">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- New Product -->
<div class="modal fade" id="productModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter un Produit</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('products.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="Paracétamol" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Prix d'achat total ({{ $currency_symbol }})
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="buying_price" data-required="1" placeholder="35000" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Prix de Vente en détail ({{ $currency_symbol }})
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="selling_price" data-required="1" placeholder="4000" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Quantité Restante
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="qte" data-required="1" placeholder="10" class="form-control input-height" />
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#productModal form'), 'product', 'product')">Enregistrer</button>
                                    <button type="button" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- New Care -->
<div class="modal fade" id="careModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter un Soin</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('cares.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="Piqûre" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Montant ({{ $currency_symbol }})
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="number" name="amount" data-required="1" placeholder="8500" class="form-control input-height" />
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#careModal form'), $('#care_id'), 'care')">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- New Specialty -->
<div class="modal fade" id="specialtyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="z-index: 999999">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter une Spécialité</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('specialties.store') }}" method="POST" id="form" class="form-horizontal">
                    @csrf
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-5">
                                <input type="text" name="name" data-required="1" placeholder="Chirurgie" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#specialtyModal form'), $('[name=specialty_id]'))">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>

            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- Docteur IA -->
<div class="modal fade" id="docteurIAModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered text-center" role="document">
        <div class="modal-content">
            <div class="modal-body text-center">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <i class="fa fa-user-nurse text-primary" style="font-size:5rem"></i>
                <br><br>
                <p style="color: #555">
                    Bonjour cher collègue,
                    <br><br>
                    Je suis <b>Docteur IA</b>, votre partenaire intelligent dans le domaine médical.
                    <br><br>Mon objectif est d'assister les médecins en fournissant des analyses de données, des recommandations de traitement et des informations sur les dernières avancées médicales.
                    <br><br>Toutefois, il est important de noter que je ne remplace pas le jugement clinique d'un professionnel de santé.
                    <br><br> Les médecins conservent le libre arbitre dans leurs décisions, et mes suggestions doivent toujours être évaluées dans le cadre de leur expertise.
                </p>
                <br>
                <a href="#" class="btn text-primary text-center" style="margin: auto" data-dismiss="modal">
                    Ok, compris
                </a>
            </div>

        </div>
    </div>
</div>

<!-- Docteur IA Advice -->
<div class="modal fade" id="doctorAIAdvice" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Conseils Docteur IA</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="text-center p-4">
                <i id="doctor-ai-icon" class="fa fa-user-nurse text-primary" style="font-size:5rem"></i>
                <i id="doctor-ai-icon-loading" class="fa fa-circle-notch fa-spin text-primary" style="font-size:5rem"></i>
            </div>
            <div class="modal-body small" id="ai-advice" style="font-size: 12px !important;">

            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>

<!-- Google Meet -->
{{--open in modal--}}
<div class="modal fade" id="meetModal" tabindex="-1" aria-labelledby="meetModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="meetModalLabel">Téléconsultation avec Google Meet</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="meetIframe" src="" frameborder="0" allow="camera; microphone" style="width: 100%; height: 500px;"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

{{--open new tab--}}
{{--<div class="modal fade" id="googleMeetModal" tabindex="-1" role="dialog" aria-labelledby="googleMeetModalLabel" aria-hidden="true">--}}
{{--    <div class="modal-dialog" role="document">--}}
{{--        <div class="modal-content">--}}
{{--            <div class="modal-header">--}}
{{--                <h5 class="modal-title" id="googleMeetModalLabel">Téléconsultation avec Google Meet</h5>--}}
{{--                <button type="button" class="close" data-dismiss="modal" aria-label="Close">--}}
{{--                    <span aria-hidden="true">&times;</span>--}}
{{--                </button>--}}
{{--            </div>--}}
{{--            <div class="modal-body">--}}
{{--                <p>Votre réunion est prête. Cliquez sur le bouton ci-dessous pour accéder à la réunion :</p>--}}
{{--                <a id="googleMeetLink" href="#" target="_blank" class="btn btn-primary">Rejoindre la réunion</a>--}}
{{--            </div>--}}
{{--            <div class="modal-footer">--}}
{{--                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </div>--}}
{{--</div>--}}

<div class="modal fade" id="jitsiModal" tabindex="-1" role="dialog" aria-labelledby="jitsiModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jitsiModalLabel">Téléconsultation KONDY via Jitsi Meet</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- L'iframe Jitsi -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Ne pas sauvegarder et Fermer</button>
                <button type="button" class="btn btn-primary" data-dismiss="modal">Sauvegarder et Fermer</button>
            </div>
        </div>
    </div>
</div>

<!-- Confirmation -->
<div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Confirmation</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Confirmez-vous ces enregistrements ? Car cette action est irréversible
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Non</button>
                <button type="button" class="btn btn-primary" id="submit" data-href="">Oui</button>
            </div>
        </div>
    </div>
</div>

<!-- Discount -->
<div class="modal fade" id="discountModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Total <span id="total-invoice"></span> {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Remise
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-6">
                                <input type="number" name="discount" data-required="1" placeholder="" class="form-control input-height" />
                            </div>
                            <input type="hidden" name="id">
                        </div>
                        <div class="form-actions">
                        <div class="row">
                            <div class="offset-md-3 col-md-9">
                                <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return setDiscount($('#discountModal [name=id]').val(), $('#discountModal [name=discount]').val())">Enregistrer</button>
                                <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                            </div>
                        </div>
                    </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

<!-- New Analysis -->
<div class="modal fade" id="analysisModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Ajouter une analyse</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('analyses.store') }}" method="POST" id="form" class="form-horizontal">
                    <div class="form-body">
                        <div class="form-group row">
                            <label class="control-label col-md-3">Nom
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="text" name="name" data-required="1" placeholder="Glycémie" class="form-control input-height" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="control-label col-md-3">Montant ({{ $currency_symbol }})
                                <span class="required"> * </span>
                            </label>
                            <div class="col-md-9">
                                <input type="number" name="amount" data-required="1" placeholder="8500" class="form-control input-height" />
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="offset-md-3 col-md-9">
                                    <button type="submit" data-dismiss="modal" class="btn btn-primary" id="save" onclick="return addNewRecord($('#analysisModal form'), $('#analysis_id'), 'analysis')">Enregistrer</button>
                                    <button type="reset" data-dismiss="modal" class="btn btn-default">Annuler</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">

            </div>
        </div>
    </div>
</div>



@include('modal-scripts')


