@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Modifier une Hospitalisation</div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
{{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
{{--                            data-mdl-for = "panel-button">--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
{{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
{{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('interventions.update', $data->custom_id) }}" method="POST" id="mainForm" class="form-horizontal">
                            @csrf
                            {{ method_field('put') }}
                            <div class="form-body">
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Patient
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="patient_id">
                                            @foreach($patients as $patient)
                                                <option value="{{ $patient->id }}" @if($patient->id == $data->patient_id) selected @endif>{{ $patient->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#patientModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                @if(!auth()->user()->isDoctor())
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Professionnel en charge
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="user_id">
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" @if($user->id == $data->user_id) selected @endif>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                @endif
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Chambre
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="room_id">
                                            @foreach($rooms as $room)
                                                <option value="{{ $room->id }}" @if($room->id == $data->room_id) selected @endif>{{ $room->name }} {{ $room->department?' - '.$room->department->name:'' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#roomModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Type Hospitalisation
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="typeintervention_id">
                                            @foreach($typeinterventions as $typeintervention)
                                                <option value="{{ $typeintervention->id }}" @if($typeintervention->id == $data->typeintervention_id) selected @endif>{{ $typeintervention->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#typeinterventionModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Diagnostic de l'hospitalisation
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Vous pouvez y préciser le diagnostic, l'ordonnance, le verdict, des éléments clés, etc"></i>
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <textarea name="description" class="form-control-textarea" id="description" cols="30" rows="10">{{ $data->description }}</textarea>
                                    </div>
                                   @if(auth()->user()->subGold())
                                        <div>
                                            <span class="nav-link btn btn-light btn-sm font-weight-bolder font-size-20 countdown" style="display: none"></span>
                                            <i class="fa fa-microphone btn btn-light btn-sm" id="start-btn"></i>
                                            <i class="fa fa-microphone fa-beat btn btn-light btn-sm text-danger" id="stop-btn" style="display: none"></i>
                                        </div>
                                        @endif
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Maladie / Gêne
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="trouble_id">
                                            @foreach($troubles as $trouble)
                                                <option value="{{ $trouble->id }}" @if($trouble->id == $data->trouble_id) selected @endif>{{ $trouble->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <a href="#" data-target="#troubleModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Etat
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="status_id">
                                            @foreach($statuses as $status)
                                                <option value="{{ $status->id }}" @if($status->id == $data->status_id) selected @endif>{{ $status->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Température (C)
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" value="{{ $data->temperature }}" name="temperature" data-required="1" placeholder="39" class="form-control input-height" /> </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Tension (mmHg)
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="text" name="{{ $data->tension }}" data-required="1" placeholder="12" class="form-control input-height" /> </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Date & Heure Debut
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Indiquez la date et l'heure du début de l'hospitalisation"></i>
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <div class="input-group date form_date ">
                                            <input class="form-control input-height" value="{{ $data->datetimefrom }}" name="datetimefrom" size="16" placeholder="date of Birth" type="datetime-local">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Date & Heure Fin
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Si la date et l'heure de fin ne sont pas précisées, cela signifie que l'hospitalisation est toujours en cours"></i>
                                    </label>
                                    <div class="col-md-5">
                                        <div class="input-group date form_date ">
                                            <input class="form-control input-height" value="{{ $data->datetimeto }}" name="datetimeto" size="16" placeholder="date of Birth" type="datetime-local">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Fichiers (photos, vidéos, audios, docs)
                                        <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Uploader les fichiers de l'état du malade (accidenté, dégats physiques, etc )"></i>
                                    </label>
                                    <div class="col-md-5">
                                        <input type="file" name="files[]" multiple>
                                    </div>
                                </div>

{{--                                <div class="form-group row">--}}
{{--                                    <label class="control-label col-md-3">Verdict--}}
{{--                                        <span class="required"> * </span>--}}
{{--                                    </label>--}}
{{--                                    <div class="col-md-5">--}}
{{--                                        <select class="form-control input-height" name="verdict_id">--}}
{{--                                            @foreach($verdicts as $verdict)--}}
{{--                                                <option value="{{ $verdict->id }}" @if($verdict->id == $data->verdict_id) selected @endif>{{ $verdict->name }}</option>--}}
{{--                                            @endforeach--}}
{{--                                        </select>--}}
{{--                                    </div>--}}
{{--                                </div>--}}

                                @if(!$data->invoice())
                                <div class="form-group row">
                                    <label class="control-label col-md-3">Analyses
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" id="analysis_id" name="analysis_id[]" style="width: 78% !important; display: inline-block">
                                            <option value="">Selectionnez</option>
                                            @foreach($analyses as $analysis)
                                                <option value="{{ $analysis->id }}">{{ $analysis->name }} ({{ $analysis->amount }} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control input-height" name="result[]" value="" placeholder="25"  style="width: 20%;  display: inline-block">
                                    </div>
                                    <a href="#" data-target="#analysisModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                <div id="analysis-bloc">
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">
                                    </label>
                                    <div class="col-md-5">
                                        <a href="#" id="btn-analysis" class="btn btn-light btn-sm">Ajouter une analyse</a>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="control-label col-md-3">Soins
                                        <span class="required"> * </span>
                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control multiple" id="care_id" name="care_id[]" multiple>
                                            @foreach($cares as $care)
                                                @php $selected = [] @endphp
                                                @foreach($data->interventioncares as $interventioncare)
                                                    @php
                                                     $selected[] = $interventioncare->care_id;
                                                     @endphp
                                                @endforeach
                                                <option value="{{ $care->id }}" @if(in_array($care->id, $selected)) selected @endif>{{ $care->name }}</option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control input-height" name="price[]" value="" placeholder="15000 {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}"  style="width: 20%;  display: inline-block">
                                    </div>
                                    <a href="#" data-target="#careModal" data-toggle="modal" class="nav-link btn btn-light btn-sm">+</a>
                                </div>
                                @if($data->sale)
                                @foreach($data->sale->commands as $command)
                                <div class="form-group row">

                                    <label class="control-label col-md-3">@if($loop->first) Produits @endif

                                    </label>
                                    <div class="col-md-5">
                                        <select class="form-control input-height" name="product_id[]" style="width: 78%; display: inline-block">
                                            <option value="">Selectionnez</option>
                                            @foreach($products as $product)
                                                <option value="{{ $product->id }}" @if($command->product_id == $product->id) selected @endif>{{ $product->name }} ({{ $product->selling_price }} F)</option>
                                            @endforeach
                                        </select>
                                        <input type="number" class="form-control input-height" name="qte[]" value="{{ $command->qte }}"  style="width: 20%;  display: inline-block">
                                    </div>
                                    @if(!$loop->first) <a href="#" class="delete-command nav-link btn btn-danger btn-sm" style="padding: 7px 18px !important; font-size: 20px;">-</a>@endif
                                    <a href="#" data-target="#productModal" data-toggle="modal" class="nav-link btn btn-primary btn-sm ml-3 insert-product">+</a>

{{--                                        @if($loop->first) <a href="#" id="btn-command" class="nav-link btn btn-light btn-sm">+</a> @endif--}}
                                </div>
                                @endforeach
                                @endif



                                <div id="command-bloc">
                                </div>
                                <div class="form-group row">
                                    <label class="control-label col-md-3">
                                    </label>
                                    <div class="col-md-5">
                                        <a href="#" id="btn-command" class="btn btn-outline-primary btn-sm">Ajouter un produit</a>
                                    </div>
                                </div>

                                    <template id="command">
                                        <div class="form-group row">
                                            <label class="control-label col-md-3"></label>
                                            <div class="col-md-5">
                                                <select class="form-control input-height" name="product_id[]" style="width: 78% ; display: inline-block">
                                                    <option value="">Selectionnez</option>
                                                    @foreach($products as $product)
                                                        <option value="{{ $product->id }}">{{ $product->name }} ({{$product->selling_price}} {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})</option>
                                                    @endforeach
                                                </select>
                                                <input type="number" class="form-control input-height" name="qte[]" value="1"  style="width: 20%;  display: inline-block">
                                            </div>
                                            <a href="#" class="delete-command nav-link btn btn-light btn-sm" style="padding: 7px 18px !important; font-weight: bold">-</a>
                                            <a href="#" data-target="#productModal" data-toggle="modal" class="nav-link btn btn-light btn-sm ml-3 insert-product">+</a>
                                        </div>
                                    </template>

                                    <template id="care">
                                        <div class="form-group row">
                                            <label class="control-label col-md-3"></label>
                                            <div class="col-md-5">
                                                <select class="form-control input-height" id="care_id" name="care_id[]" style="width: 78%; display: inline-block">
                                                    <option value="">Selectionnez</option>
                                                    @foreach($cares as $care)
                                                        <option value="{{ $care->id }}">{{ $care->name }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="number" class="form-control input-height" name="price[]" value="" placeholder="15000 {!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!}"  style="width: 20%;  display: inline-block">
                                            </div>
                                            <a href="#" class="delete-care nav-link btn btn-light btn-sm" style="padding: 7px 18px !important; font-weight: bold">-</a>
                                            <a href="#" data-target="#careModal" data-toggle="modal" class="nav-link btn btn-light btn-sm ml-3 insert-care">+</a>
                                        </div>
                                    </template>

                                    <template id="analysis">
                                        <div class="form-group row">
                                            <label class="control-label col-md-3"></label>
                                            <div class="col-md-5">
                                                <select class="form-control input-height" id="analysis_id" name="analysis_id[]" style="width: 78%; display: inline-block">
                                                    <option value="">Selectionnez</option>
                                                    @foreach($analyses as $analysis)
                                                        <option value="{{ $analysis->id }}">{{ $analysis->name }}</option>
                                                    @endforeach
                                                </select>
                                                <input type="number" class="form-control input-height" name="result[]" value="" placeholder="25"  style="width: 20%;  display: inline-block">
                                            </div>
                                            <a href="#" class="delete-analysis nav-link btn btn-light btn-sm" style="padding: 7px 18px !important; font-weight: bold">-</a>
                                            <a href="#" data-target="#analysisModal" data-toggle="modal" class="nav-link btn btn-light btn-sm ml-3 insert-analysis">+</a>
                                        </div>
                                    </template>
                                @endif

                                    <input type="hidden" name="enableInvoice" value="0">

                                    <div class="form-actions">
                                    <div class="row">
                                        <div class="offset-md-3 col-md-9">
                                            @if($data->invoice())
                                            <button type="submit" id="save" class="btn btn-primary">Enregistrer</button>
                                            @else
                                            <button type="submit" data-toggle="modal" data-target="#confirmCreateModal" id="save" onclick="return false;" class="btn btn-primary">Enregistrer</button>
                                            @endif
                                            <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#btn-command').click(function(e){
            e.preventDefault()
            $('#command-bloc').append($('#command').html())
        })

        $('.form-body').on('click', '.delete-command', function(e){
            e.preventDefault()
            $(this).parent().remove()
        })

        $('#confirmCreateModal #no').click(function(){
            $('#mainForm').submit()
        })

        $('#confirmCreateModal #yes').click(function(){
            $('[name="enableInvoice"]').val(1)
            $('#mainForm').submit()
        })

        // $('.filter-option-inner-inner').html('Selectionnez')
    </script>
@endpush
