@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Groupes sanguin ({{ $datas->count() }})  &nbsp;
                        <a class="btn btn-primary" href="{{ route('groups.create') }}">Ajouter</a>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tabbable-line">
                    <ul class="nav nav-pills nav-pills-rose">
                        <li class="nav-item tab-all"><a class="nav-link active"
                                                        href="#tab1" data-toggle="tab">Liste</a></li>

                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active fontawesome-demo" id="tab1">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card  card-box">
                                        <div class="card-head">
                                            <header></header>
                                            <div class="tools">
                                                <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                                                <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                                                <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                                            </div>
                                        </div>
                                        <div class="card-body ">

                                            <div class="table-scrollable">
                                                <table class="table table-hover full-width custom">
                                                    <thead>
                                                    <tr>
                                                        <th> Nom </th>
                                                        <th> Actions </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($datas as $data)
                                                        <tr>
                                                            <td>{{ $data->name }}</td>
                                                            <td class="center">
                                                                <a href="{{ route('groups.edit', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-edit-02 text-dark h3" title="Modifier"></i>
                                                                </a>
                                                                <a href="#" data-target="#deleteModal" data-toggle="modal" data-href="{{ route('groups.delete', $data->custom_id) }}" class="" >
                                                                    <i class="hgi-stroke hgi-sharp hgi-waste text-dark h3" title="Supprimer"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('#archiveToggle').change(function(){
            if(this.checked) {
                $('.not-archive').hide()
                $('.archive').show()
            }else{
                $('.archive').hide()
                $('.not-archive').show()
            }
        })
    </script>
@endpush
