@extends('emails.layout')
@section('body')
    <table style="font-family:Poppins,sans-serif;" role="presentation" cellpadding="0" cellspacing="0" width="100%" border="0">
        <tbody>
        <tr>
            <td style="overflow-wrap:break-word;word-break:break-word;padding:10px;font-family:Poppins,sans-serif;" align="left">

                <div style="line-height: 200%; text-align: center; word-wrap: break-word; font-size: 14px">
                    <h2>Rapport de Téléconsultation</h2>
                    <p>
                        Bonjour {{ $data['patient']->name }},
                    </p>
                    <p>
                        Le centre médical <b>{{$data['company']->name}}</b> vous présente le rapport de la téléconsultation avec le médécin <b>{{ $data['user']->proName() }}</b> du {{ $data['teleconsultation']->created_at->translatedFormat('D d M Y à H:i') }}:
                    </p>
                    <ul style="text-align: left">
                        <li>
                            <h4>Diagnostic et ordonnance</h4>
                            <p>
                                {!! $data['teleconsultation']->prescription ? $data['teleconsultation']->prescription : $data['teleconsultation']->description !!}</p>
                        </li>
                        <li>
                            <h4>Durée de la téléconsultation</h4>
                            <p>{{ gmdate('H:i:s', $data['teleconsultation']->duration) }}</p>
                        </li>
                        <li>
                            <h4>Montant (HT)</h4>
                            <p>{{ $data['teleconsultation']->amount }} {{ $data['company']->currency_symbol }}</p>
                        </li>
                    </ul>
                    <p>
                        Prenez soin de vous.
                    </p>
                    <p>Merci,</p>
                    <p>L'équipe KONDY</p>
                </div>

            </td>
        </tr>
        </tbody>
    </table>
    <table style="font-family:Poppins,sans-serif;" role="presentation" cellpadding="0" cellspacing="0" width="100%" border="0">
        <tbody>
        <tr>
            <td style="overflow-wrap:break-word;word-break:break-word;padding:10px;font-family:Poppins,sans-serif;" align="left">
            </td>
        </tr>
        </tbody>
    </table>
@endsection


