@extends('emails.layout')
@section('body')
    <table style="font-family:Poppins,sans-serif;" role="presentation" cellpadding="0" cellspacing="0" width="100%" border="0">
        <tbody>
        <tr>
            <td style="overflow-wrap:break-word;word-break:break-word;padding:10px;font-family:Poppins,sans-serif;" align="left">
                <div style="line-height: 200%; text-align: center; word-wrap: break-word; font-size: 14px">
                    <h2>Statistiques du Mois de {{$data['lastMonth']}}</h2>
                    <p>
                        Bonjour {{ $data['user']->proName() }},
                    </p>
                    <p>
                        Voici un aperçu des statistiques de l'activité de votre centre médical <b>{{ $data['company']->name }}</b> pour le mois de {{$data['lastMonth']}} :
                    </p>
                    <ul style="text-align: left">
                        <li>Nouveaux Patients: <b>{{ $data['stats']->patients() }}</b></li>
                        <li>Consultations : <b>{{ $data['stats']->consultations() }}</b></li>
                        <li>Hospitalisations : <b>{{ $data['stats']->interventions() }}</b></li>
                        <li>Opérations : <b>{{ $data['stats']->operations() }}</b></li>
                        <li>Guéris / Remis : <b>{{ $data['stats']->charts('Guéri / Rémission', $data['lastMonthKey']) }}</b></li>
                        <li>Coma : <b>{{ $data['stats']->charts('Coma', $data['lastMonthKey']) }}</b></li>
                        <li>Transférés : <b>{{ $data['stats']->charts('Transféré', $data['lastMonthKey']) }}</b></li>
                        <li>Décédés : <b>{{ $data['stats']->charts('Décédé', $data['lastMonthKey']) }}</b></li>
                        <li>Recette : <b>{{ $data['stats']->recipe() }} {{ $data['company']->currency_symbol }}</b></li>
                    </ul>
                    <p>
                        Continuez à optimiser vos performances pour de meilleurs résultats !
                    </p>
                    <p>
                        KONDY vous souhaite un excellent début de mois.
                    </p>
                    <p>Merci,</p>
                    <p>L'équipe KONDY</p>
                </div>
            </td>
        </tr>
        </tbody>
    </table>
    <table style="font-family:Poppins,sans-serif;" role="presentation" cellpadding="0" cellspacing="0" width="100%" border="0">
        <tbody>
        <tr>
            <td style="overflow-wrap:break-word;word-break:break-word;padding:10px;font-family:Poppins,sans-serif;" align="left">

                <div align="center">
                    <!--[if mso]><table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-spacing: 0; border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt;font-family:Poppins,sans-serif;"><tr><td style="font-family:Poppins,sans-serif;" align="center"><v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="" style="height:37px; v-text-anchor:middle; width:112px;" arcsize="11%" stroke="f" fillcolor="#1bc5bd"><w:anchorlock/><center style="color:#FFFFFF;font-family:Poppins,sans-serif;"><![endif]-->
                    <a href="{{route('index')}}" target="_blank" style="box-sizing: border-box;display: inline-block;font-family:Poppins,sans-serif;text-decoration: none;-webkit-text-size-adjust: none;text-align: center;color: #FFFFFF;
                                                    background-color: #3f51b5;
                                                    border-radius: 50px; width:auto; max-width:100%; overflow-wrap: break-word; word-break: break-word; word-wrap:break-word; mso-border-alt: none;">
                        <span style="display:block;padding:10px 20px;line-height:120%;"><span style="font-size: 15px; line-height: 16.8px; font-weight: bold">Accéder aux Stats</span></span>
                    </a>
                    <!--[if mso]></center></v:roundrect></td></tr></table><![endif]-->
                </div>

            </td>
        </tr>
        </tbody>
    </table>
@endsection






