@extends('layout.app')

@section('content')
    <div class="page-content">
        <div class="page-bar">
            <div class="page-title-breadcrumb">
                <div class=" pull-left">
                    <div class="page-title">Modifier les infos générales</div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="card card-box">
                    <div class="card-head">
                        <button id = "panel-button"
                                class = "mdl-button mdl-js-button mdl-button--icon pull-right"
                                data-upgraded = ",MaterialButton">
                            <i class = "material-icons">more_vert</i>
                        </button>
                        {{--                        <ul class = "mdl-menu mdl-menu--bottom-right mdl-js-menu mdl-js-ripple-effect"--}}
                        {{--                            data-mdl-for = "panel-button">--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">assistant_photo</i>Action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">print</i>Another action</li>--}}
                        {{--                            <li class = "mdl-menu__item"><i class="material-icons">favorite</i>Something else here</li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <div class="card-body row" id="bar-parent">
                        <div class="col">
                            <form action="{{ route('company.update', $data->custom_id) }}" method="POST" id="form_sample_1" class="form-horizontal" enctype="multipart/form-data">
                                @csrf
                                {{ method_field('put') }}
                                <div class="form-body">
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Logo
                                        </label>
                                        <div class="col-md-5">
                                            <label for="logo-file-input" id="logo-label">
                                                @if($data->logo)
                                                    <img id="logo-uploaded-image" class="uploaded-image" src="{{ asset(env('APP_URL').'storage/uploads/company/'.$data->logo) }}" alt="Image">
                                                @else
                                                    <img id="logo-uploaded-image" class="uploaded-image" src="#" alt="Image">
                                                @endif
                                            </label>
                                            <input type="file" name="logo" data-required="1" class="form-control input-height" id="logo-file-input" accept="image/*">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Signature du Directeur Général
                                        </label>
                                        <div class="col-md-5">
                                            <label for="signature-file-input" id="signature-label">
                                                @if($data->signature)
                                                    <img id="signature-uploaded-image" class="uploaded-image" src="{{ asset(env('APP_URL').'storage/uploads/company/'.$data->signature) }}" alt="Image">
                                                @else
                                                    <img id="signature-uploaded-image" class="uploaded-image" src="#" alt="Image">
                                                @endif
                                            </label>
                                            <input type="file" name="signature" data-required="1" class="form-control input-height" id="signature-file-input" accept="image/*">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Nom de la Clinique / Hôpital / Centre
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->name }}" type="text" name="name" data-required="1" placeholder="" class="form-control input-height" required/> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Docteur
                                            <span class="required"> * </span>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->doctor }}" type="text" name="doctor" data-required="1" placeholder="" class="form-control input-height" required/> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Diplomé à
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Cet élément se situe au coin supérieur gauche, juste en dessous de l'en-tête de la facture"></i>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->diploma }}" type="text" name="diploma" data-required="1" placeholder="" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Montant ticket pour patient ({!! htmlentities(auth()->user()->company->currency_symbol, ENT_NOQUOTES, 'UTF-8') !!})
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Equivalent au prix de carnet"></i>
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->ticket_amount }}" type="text" name="ticket_amount" data-required="1" placeholder="" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">TVA ({{ $data->tva_value }}%) sur vos factures ?

                                        </label>
                                        <div class="col-md-5">
                                            <label class = "mdl-switch mdl-js-switch mdl-js-ripple-effect"
                                                   for = "tva">
                                                <input type = "checkbox" id="tva"
                                                       class = "mdl-switch__input" name="tva" @if($data->tva) checked @endif>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Pays
                                        </label>
                                        <div class="col-md-5">
                                            <select class="form-control input-height" name="country" id="">
                                                <option @if($data->country == 'Algérie') selected @endif>Algérie</option>
                                                <option @if($data->country == 'Andorre') selected @endif>Andorre</option>
                                                <option @if($data->country == 'Bénin') selected @endif>Bénin</option>
                                                <option @if($data->country == 'Burkina Faso') selected @endif>Burkina Faso</option>
                                                <option @if($data->country == 'Burundi') selected @endif>Burundi</option>
                                                <option @if($data->country == 'Cameroun') selected @endif>Cameroun</option>
                                                <option @if($data->country == 'Canada') selected @endif>Canada</option>
                                                <option @if($data->country == 'Cap-Vert') selected @endif>Cap-Vert</option>
                                                <option @if($data->country == 'République Centrafricaine') selected @endif>République Centrafricaine</option>
                                                <option @if($data->country == 'Comores') selected @endif>Comores</option>
                                                <option @if($data->country == 'Congo') selected @endif>Congo</option>
                                                <option @if($data->country == 'République Démocratique du Congo') selected @endif>République Démocratique du Congo</option>
                                                <option @if($data->country == "Côte d'Ivoire") selected @endif>Côte d'Ivoire</option>
                                                <option @if($data->country == 'Djibouti') selected @endif>Djibouti</option>
                                                <option @if($data->country == 'France') selected @endif>France</option>
                                                <option @if($data->country == 'Gabon') selected @endif>Gabon</option>
                                                <option @if($data->country == 'Guinée') selected @endif>Guinée</option>
                                                <option @if($data->country == 'Guinée-Bissau') selected @endif>Guinée-Bissau</option>
                                                <option @if($data->country == 'Haïti') selected @endif>Haïti</option>
                                                <option @if($data->country == 'Luxembourg') selected @endif>Luxembourg</option>
                                                <option @if($data->country == 'Madagascar') selected @endif>Madagascar</option>
                                                <option @if($data->country == 'Mali') selected @endif>Mali</option>
                                                <option @if($data->country == 'Maroc') selected @endif>Maroc</option>
                                                <option @if($data->country == 'Maurice') selected @endif>Maurice</option>
                                                <option @if($data->country == 'Mauritanie') selected @endif>Mauritanie</option>
                                                <option @if($data->country == 'Monaco') selected @endif>Monaco</option>
                                                <option @if($data->country == 'Niger') selected @endif>Niger</option>
                                                <option @if($data->country == 'Rwanda') selected @endif>Rwanda</option>
                                                <option @if($data->country == 'Sénégal') selected @endif>Sénégal</option>
                                                <option @if($data->country == 'Seychelles') selected @endif>Seychelles</option>
                                                <option @if($data->country == 'Suisse') selected @endif>Suisse</option>
                                                <option @if($data->country == 'Tchad') selected @endif>Tchad</option>
                                                <option @if($data->country == 'Togo') selected @endif>Togo</option>
                                                <option @if($data->country == 'Tunisie') selected @endif>Tunisie</option>
                                                <option @if($data->country == 'Vanuatu') selected @endif>Vanuatu</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Ville
                                        </label>
                                        <div class="col-md-5">
                                            <input value="{{ $data->city }}" type="text" name="city" data-required="1" placeholder="Lomé" class="form-control input-height" /> </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">En-tête
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Cet élément se situe au coin supérieur gauche de la facture. Ex: MEDECINE GENERALE | PEDIATRIE | ECHOGRAPHIE | RADIOGRAPHIE | ONCOLOGIE etc"></i>
                                        </label>
                                        <div class="col-md-5">
                                            <textarea name="header" id="basic-example" cols="30" rows="10" class="form-control ">{!! $data->header !!}</textarea>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="control-label col-md-3">Pied de page
                                            <i class="fa fa-info-circle text-secondary" data-toggle="tooltip" data-title="Cet élément se situe en bas (pied de page exactement) de la facture. Ex: Autorisation V52252, Loi 25 etc"></i>
                                        </label>
                                        <div class="col-md-5">
                                            <textarea name="footer" id="" cols="30" rows="10" class="form-control ">{!! $data->footer !!}</textarea>
                                        </div>
                                    </div>


                                    <div class="form-actions">
                                        <div class="row">
                                            <div class="offset-md-3 col-md-9">
                                                <button type="submit" class="btn btn-primary">Enregistrer</button>
                                                <a href="{{ url()->previous() }}" type="button" class="btn btn-default">Annuler</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="text-small text-muted pull-right">
                            <table>
                                <tr class="text-danger">
                                    <td><small>*</small></td>
                                    <td><small>Champs obligatoires</small></td>
                                </tr>
                                <tr class="text-secondary">
                                    <td><small><i class="fa fa-info-circle"></i></small></td>
                                    <td><small>Infos supplémentaires</small></td>
                                </tr>
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-plus"></i></small></td>
                                    <td><small>Ajouter des éléments dans la liste</small></td>
                                </tr>
                                @if(auth()->user()->subGold())
                                <tr class="text-dark">
                                    <td><small><i class="fa fa-microphone"></i></small></td>
                                    <td><small>Transcrire audio en texte</small></td>
                                </tr>
                                @endif
                                @if(auth()->user()->subStandard())
                                <tr class="text-dark"><td><small><i class="fa fa-user-nurse text-dark"></i></small></td>
                                    <td><small>Générer grâce à
                                            <a href="#" class="text-primary text-decoration-underline" style="text-decoration: underline !important;" data-target="#docteurIAModal" data-toggle="modal" title="En savoir plus">Docteur IA</a>
                                            </small></td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>

    </script>
@endpush
