@extends('auth.layout.app')

@section('auth_content')
<div class="limiter">
{{--    <button class="btn btn-primary" data-toggle="modal" data-target="#paymentModal" type="button" id="test-modal">--}}
{{--        test modal payment--}}
{{--    </button>--}}
    <div class="row container-login100 page-background">
        <div class="row align-items-center">
            <div class="wrap-login100 col">
                <form method="POST" action="{{ route('users.register') }}" class="login100-form validate-form" id="register-form">
                    @csrf
                    <div class="" style="margin: auto; text-align: center">
                        <a href="/">
                            <img alt="" src="{{ asset('medical') }}/assets/img/main_logo.png" style="width: 120px">
                        </a>
                        <br>
                        <img src="{{ asset('medical') }}/assets/img/medical_gif.gif" style="max-height: 200px">
                    </div>
                    @error('email')
                    <div class="sub-banner error">
                        <h2>
                            L'adresse Email a déja été utilisée.
                        </h2>
                        <p>
                            Veuillez choisir une autre  SVP
                        </p>
                    </div>
                    <br>
                    @enderror
                    <div id="step1" class="animate__animated animate__slideInRight">
                        <div class="text-center p-t-10" style="font-size: 12px">
                            Déja un compte ? <a href="{{route('login')}}" class="text-primary" style="font-size: 12px">Identifiez-vous</a>
                        </div>
                        <br>
                        <h4 class="text-right">Votre Identité</h4>
                        <br>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="name" placeholder="Votre Nom & Prénoms" value="{{old('name')}}" required>
                            <i class="far fa-user"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <select class="input100 input-height" name="sex">
                                <option selected>Homme</option>
                                <option>Femme</option>
                                <option>Autre</option>
                            </select>
                            <i class="fa-solid fa-genderless"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <select class="input100 input-height" name="role">
                                <option selected>Médecin</option>
                                <option>Infirmier</option>
                                <option>Sage-femme</option>
                                <option>Sécretaire</option>
                            </select>
                            <i class="fa-solid fa-stethoscope"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="tel" placeholder="Téléphone" required>
                            <i class="fas fa-mobile-screen"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="email" placeholder="Email" required>
                            <i class="far fa-envelope"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate="Enter password">
                            <input class="input100" id="password-input" type="password" name="password" placeholder="Mot de Passe" required>
                            {{--                        <i class="far fa-lock" ></i>--}}
                            <i class="material-symbols-rounded" style="font-size: 20px">lock</i>
                            <i class="fa fa-eye eye" style="font-size: 20px"></i>
                            <i class="fa fa-eye-slash eye" style="font-size: 20px; display: none"></i>
                        </div>
                        <div class="container-login100-form-btn text-right" style="justify-content: right">
                            <button class="btn btn-primary btn-loading " id="btn-continue" disabled>
                                Continuer <i class="fa-solid fa-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                    <div id="step2" class="animate__animated animate__slideInLeft" style="display: none">
                        <div class="text-center p-t-10" style="font-size: 12px">
                            Déja un compte ? <a href="{{route('login')}}" class="text-primary" style="font-size: 12px">Identifiez-vous</a>
                        </div>
                        <br>
                        <h4 class="text-right">Votre Centre Médical</h4>
                        <br>
                        <div class="form-check form-switch" >
                            <input class="form-check-input" name="is_doctor[]" type="checkbox" role="switch" id="doctor-check" checked style="cursor: pointer !important;">
                            &nbsp;&nbsp;
                            <label class="form-check-label" for="doctor-check" style="cursor: pointer !important;">Je suis Docteur</label>
                        </div>
                        <br>
                        <div class="wrap-input100 validate-input animate__animated animate__fadeIn" data-validate = "Enter username" id="doctor-name">
                            <input class="input100" type="text" name="doctor" placeholder="Nom complet du Directeur general" required>
                            <i class="fa-solid fa-user-doctor"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="clinical_name" placeholder="Nom de la Clinique / Hôpital / Centre" required>
                            <i class="fa-regular fa-hospital"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <select class="input100 form-control input-height" name="country">
                                <option>Algérie</option>
                                <option>Andorre</option>
                                <option>Bénin</option>
                                <option>Burkina Faso</option>
                                <option>Burundi</option>
                                <option>Cameroun</option>
                                <option>Canada</option>
                                <option>Cap-Vert</option>
                                <option>République Centrafricaine</option>
                                <option>Comores</option>
                                <option>Congo</option>
                                <option>République Démocratique du Congo</option>
                                <option>Côte d'Ivoire</option>
                                <option>Djibouti</option>
                                <option selected>France</option>
                                <option>Gabon</option>
                                <option>Guinée</option>
                                <option>Guinée-Bissau</option>
                                <option>Haïti</option>
                                <option>Luxembourg</option>
                                <option>Madagascar</option>
                                <option>Mali</option>
                                <option>Maroc</option>
                                <option>Maurice</option>
                                <option>Mauritanie</option>
                                <option>Monaco</option>
                                <option>Niger</option>
                                <option>Rwanda</option>
                                <option>Sénégal</option>
                                <option>Seychelles</option>
                                <option>Suisse</option>
                                <option>Tchad</option>
                                <option>Togo</option>
                                <option>Tunisie</option>
                                <option>Vanuatu</option>
                            </select>
                            <i class="fa-solid fa-earth-americas"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="city" placeholder="Ville de la Clinique / Hôpital / Centre" required>
                            <i class="fa-solid fa-map-pin"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="adresse" placeholder="Adresse de la Clinique / Hôpital / Centre" required>
                            <i class="fa-solid fa-location-crosshairs"></i>
                        </div>
                        <div class="wrap-input100 validate-input" data-validate = "Enter username">
                            <input class="input100" type="text" name="clinical_tel" placeholder="Téléphone de la Clinique / Hôpital / Centre" required>
                            <i class="fas fa-mobile-screen"></i>
                        </div>

                        <div class="form-check form-switch" >
                            <input class="form-check-input" name="conditions" type="checkbox" role="switch" id="conditions" style="cursor: pointer !important;">
                            &nbsp;&nbsp;
                            <label class="form-check-label conditions-terms" for="conditions" style="cursor: pointer !important;">J'ai lu et accepté les
                                <a href="{{asset('KONDY_Conditions_D_Utilisation.pdf')}}">conditions d'utilisations</a>
                                <br>
                                et les <a href="{{asset('KONDY_Contrat_D_Abonnement.pdf')}}">termes du contrat d'abonnement</a>.
                            </label>
                        </div>
                        <br><br>
                        {{--                        inputs hidden--}}
                        <input type="hidden" name="subscription_id" value="{{$subscription->id}}">
                        <input type="hidden" name="subscription_value" value="{{$subscription->annual_monthly_value}}">
                        <input type="hidden" name="subscription_name" value="{{$subscription->name}}">
                        <input type="hidden" name="subscription_mode" value="stripe">
                        <input type="hidden" name="payment_infos_sup" value="">
                        <input type="hidden" name="annual" value="1">

                        <div class="row">
                            <div class="col" style="justify-content: left">
                                <button class="btn btn-light btn-loading " id="btn-back">
                                    <i class="fa-solid fa-arrow-left"></i> Retour
                                </button>
                            </div>
                            <div class="col" style="justify-content: right">
                                <button class="btn btn-primary btn-save" id="btn-open-payment-modal" data-toggle="modal" data-target="#paymentModal" disabled type="button">
                                    Profiter des 30 jours d'essai
                                </button>
                                <button class="btn btn-primary btn-loading disabled" style="display: none">
                                    <i class="fa-solid fa-circle-notch fa-spin"></i> Profiter des 90 jours d'essai
                                </button>
                            </div>
                        </div>
                    </div>
                    <br>
                    <br><br>
                    <div class="text-center p-t-10" style="font-size: 10px; color: #4b6082">
                        &copy; Copyright {{ date('Y') }} <b>KONDY</b>. Tous droits reservés. <br>
                        Propulsé par Diaris Tech
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>
<!-- Modals Start -->
@include('modals.paiement')
<!-- Modals End -->
@endsection
@push('scripts')<!-- TIDIO CHAT BOT -->
<script src="//code.tidio.co/pzpeg7qkkyb5hvtsvcjufdbnpq2h8uhb.js"></script>
<!-- web speech -->
<!-- JITSI -->
<script src='https://meet.jit.si/external_api.js'></script>
@include('scriptjs')
@include('site.scripts')
@endpush
