<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Teleconsultation extends BaseModel
{
    use HasFactory;

    protected $table = 'teleconsultations';

    protected $fillable = [
        'description',
        'datetime',
        'typeconsultation_id',
        'temperature',
        'amount',
        'patient_id',
        'user_id',
        'sale_id',
        'company_id',
        'custom_id',
        'prescription',
        'ai_description',
        'duration',
        'company_id',
        'custom_id',
    ];

    protected $dates = ['datetime'];

    public function patient(){
        return $this->belongsTo(Patient::class);
    }

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function invoice(){
        return Invoice::where('teleconsultation_id', $this->id)->first();
    }
}
