<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionInvoice extends BaseModel
{
    use HasFactory;

    protected $table = 'subscription_invoices';

    protected $fillable = [
        'name',
        'amount_paid',
        'currency',
        'company_id',
        'subscription_id',
        'custom_id',
        'mode',
        'card_name',
        'card_email',
        'tel',
        'type',
        'stripe_id',
        'paypal_id',
        'paygate_id',
        'annual',
    ];

    public function company(){
        return $this->belongsTo(Company::class);
    }

    public function subscription(){
        return $this->belongsTo(Subscription::class);
    }
}
