<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Status extends BaseModel
{
    use HasFactory;

    protected $table = 'status';

    protected $fillable = [
        'name',
        'custom_id'
    ];

    protected $appends = ['color'];

    public function getColorAttribute(){
        if(strtolower($this->name) == 'très grave')
            return 'danger';

        if(strtolower($this->name) == 'grave')
            return 'warning';

        if(strtolower($this->name) == 'moyen')
            return 'primary';

        if(strtolower($this->name) == 'bon')
            return 'success';

        if(strtolower($this->name) == 'très bon')
            return 'success';
    }

}
