<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends BaseModel
{
    use HasFactory;

    protected $table = 'sales';

    protected $fillable = [
        'total',
        'datetime',
        'user_id',
        'company_id',
        'custom_id'
    ];

    protected $dates = ['datetime'];

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function commands(){
        return $this->hasMany(Command::class);
    }

    public function lastCommand(){
        return Command::where('sale_id', $this->id)->orderBy('created_at', 'desc')->first();
    }

    public function invoice(){
        return Invoice::where('sale_id', $this->id)->first();
    }


    public function hasRelatedRecords(){
//        if($this->commands()->exists())
//            return true;
        if($this->invoice()){
            if($this->invoice()->consultation()->exists())
                return true;
            if($this->invoice()->intervention()->exists())
                return true;
        }
        return false;
    }
}
