<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends BaseModel
{
    use HasFactory;

    protected $table = 'rooms';

    protected $fillable = [
        'name',
        'price',
        'department_id',
        'company_id',
        'custom_id'
    ];

    public function department(){
        return $this->belongsTo(Department::class);
    }

    public function interventions(){
        return $this->hasMany(Intervention::class);
    }

    public function hasRelatedRecords(){
        if($this->interventions()->exists())
            return true;
        return false;
    }
}
