<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rdv extends BaseModel
{
    use HasFactory;

    protected $table = 'rdvs';

    protected $fillable = [
        'title',
        'reason',
        'datetime',
        'done',
        'user_id',
        'patient_id',
        'company_id',
        'custom_id',
        'type',
    ];

    protected $dates = ['datetime'];

    public function patient(){
        return $this->belongsTo(Patient::class);
    }

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function datePast(){
        return (new \DateTime($this->datetime) < new \DateTime("today"));
    }

    public function hasRelatedRecords(){
//        if($this->patient()->exists())
//            return true;
//        if($this->user()->exists())
//            return true;
//        return false;
    }
}
