<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends BaseModel
{
    use HasFactory;

    protected $table = 'products';

    protected $fillable = [
        'name',
        'buying_price',
        'selling_price',
        'qte',
        'company_id',
        'custom_id'
    ];

    public function commands(){
        return $this->hasMany(Command::class);
    }

    public function hasRelatedRecords(){
        if($this->commands()->exists())
            return true;
        return false;
    }

}
