<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Patient extends BaseModel
{
    use HasFactory;

    protected $table = 'patients';

    protected $fillable = [
        'name',
        'sex',
        'tel',
        'address',
        'pathology',
        'birth',
        'size',
        'weight',
        'group_id',
        'archive',
        'job',
        'stay',
        'assured',
        'company_id',
        'custom_id',
        'antecedent',
        'email',
        'assured_social_percent',
        'assured_completed_percent',
    ];

    public function interventions(){
        return $this->hasMany(Intervention::class)->orderBy('id', 'desc');
    }

    public function consultations(){
        return $this->hasMany(Consultation::class)->orderBy('id', 'desc');
    }

    public function teleconsultations(){
        return $this->hasMany(Teleconsultation::class)->orderBy('id', 'desc');
    }

    public function group(){
        return $this->belongsTo(Group::class);
    }

    public function firstname(){
        $firstName = '';
        $i = 0;
        foreach (explode(' ', $this->name) as $word){
            if($i != 0) $firstName .= $word;
            $i++;
        }
        return $firstName;
    }

    public function lastname(){
        return explode(' ', $this->name)[0];
    }

    protected $dates = ['birth'];

    public function lastIntervention(){
        return Intervention::where('patient_id', $this->id)->orderBy('created_at', 'desc')->first();
    }

    public function lastConsultation(){
        return Consultation::where('patient_id', $this->id)->orderBy('created_at', 'desc')->first();
    }

    public function lastTeleconsultation(){
        return Teleconsultation::where('patient_id', $this->id)->orderBy('created_at', 'desc')->first();
    }

    public function age(){
        $ageFromYear = intval(date('Y')) - intval($this->birth->format('Y'));
        if(intval(date('md')) < intval($this->birth->format('md'))){
            return $ageFromYear - 1;
        }
        return $ageFromYear;
    }

    public function isStay(){
        $intervention = Intervention::where('patient_id', $this->id)->where('datetimeto', null)->orderBy('id', 'desc')->first();
        return ($intervention);
    }

    public function hasRelatedRecords(){
        if($this->interventions()->exists())
            return true;
        return false;
    }

}
