<?php

namespace App\Models;

use App\Http\Controllers\Admin\TeleconsultationController;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends BaseModel
{
    use HasFactory;

    protected $table = 'invoices';

    protected $fillable = [
        'total',
        'amount',
        'tva_amount',
        'rest_to_pay',
        'payed',
        'date',
        'user_id',
        'patient_id',
        'intervention_id',
        'consultation_id',
        'teleconsultation_id',
        'sale_id',
        'company_id',
        'custom_id',
        'discount'
    ];

    protected $dates = ['date'];

    public function sale(){
        return $this->belongsTo(Sale::class);
    }

    public function intervention(){
        return $this->belongsTo(Intervention::class);
    }

    public function consultation(){
        return $this->belongsTo(Consultation::class);
    }

    public function teleconsultation(){
        return $this->belongsTo(Teleconsultation::class);
    }

    public function patient(){
        return $this->belongsTo(Patient::class);
    }

    public function no(){
        return "0" . $this->id . "/" . $this->date->format('y');
    }

}
