<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Interventioncare extends BaseModel
{
    use HasFactory;

    protected $table = 'interventioncares';

    protected $fillable = [
        'intervention_id',
        'care_id',
        'custom_id',
        'price'
    ];

    public function intervention(){
        return $this->belongsTo(Intervention::class);
    }

    public function care(){
        return $this->belongsTo(Care::class);
    }

    public function amount(){
//        return $this->intervention->patient->assured ? $this->care->amount : $this->care->basicAmount();
        return $this->care->amount;
    }

}
