<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Intervention extends BaseModel
{
    use HasFactory;

    protected $table = 'interventions';

    protected $fillable = [
        'description',
        'temperature',
        'datetimefrom',
        'datetimeto',
        'files',
        'patient_id',
        'user_id',
        'typeintervention_id',
        'trouble_id',
        'verdict_id',
        'status_id',
        'room_id',
        'sale_id',
        'company_id',
        'custom_id',
        'tension'
    ];

    protected $appends = ['bgcolor'];

    protected $dates = ['datetimefrom', 'datetimeto'];

    public function patient(){
        return $this->belongsTo(Patient::class);
    }

    public function room(){
        return $this->belongsTo(Room::class);
    }

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function typeintervention(){
        return $this->belongsTo(Typeintervention::class);
    }

    public function trouble(){
        return $this->belongsTo(Trouble::class);
    }

    public function group(){
        return $this->belongsTo(Group::class);
    }

    public function verdict(){
        return $this->belongsTo(Verdict::class);
    }

    public function status(){
        return $this->belongsTo(Status::class);
    }

    public function cares(){
        return $this->belongsToMany(Care::class, 'interventioncares');
    }

    public function invoice(){
        return Invoice::where('intervention_id', $this->id)->first();
    }

    public function sale(){
        return $this->belongsTo(Sale::class);
    }

    public function interventioncares(){
        return $this->hasMany(Interventioncare::class);
    }

    public function getBgcolorAttribute(){

    }

    public function days(){
        return $this->datetimeto ? $this->datetimefrom->diffInDays($this->datetimeto) : 1;
    }

    public function analyses(){
        return $this->belongsToMany(Analysis::class, 'interventionanalyses');
    }

    public function interventionanalyses(){
        return $this->hasMany(Interventionanalysis::class);
    }




}
