<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group extends BaseModel
{
    use HasFactory;

    protected $table = 'groups';

    protected $fillable = [
        'name',
        'custom_id'
    ];

    public function patients(){
        return $this->hasMany(Patient::class);
    }

    public function hasRelatedRecords(){
        if($this->patients()->exists())
            return true;
        return false;
    }

}
