<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends BaseModel
{
    use HasFactory;

    protected $table = 'departments';

    protected $fillable = [
        'name',
        'company_id',
        'custom_id'
    ];

    public function rooms(){
        return $this->hasMany(Room::class);
    }

    public function hasRelatedRecords(){
        if($this->rooms()->exists())
            return true;
        return false;
    }
}
